/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.XZInputStream;

public class DocumentSources {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentSources.class);
    private static final String ZIP_FILE_EXTENSION = ".zip";
    private static final String GZ_FILE_EXTENSION = ".gz";
    private static final String XZ_FILE_EXTENSION = ".xz";
    private static final String CONTENT_DISPOSITION_HEADER = "Content-Disposition";
    private static final Pattern CONTENT_DISPOSITION_FILE_NAME_PATTERN = Pattern.compile(".*filename=\"([^\\s;]*)\".*");
    private static final int CONTENT_DISPOSITION_FILE_NAME_PATTERN_GROUP = 1;
    private static final Pattern ZIP_ENTRY_ONTOLOGY_NAME_PATTERN = Pattern.compile(".*owl|rdf|xml|mos");
    private static final String ACCEPTABLE_CONTENT_ENCODING = "xz,gzip,deflate";
    private static final String TEXTPLAIN_REQUEST_TYPE = ", text/plain; q=0.1";
    private static final String LAST_REQUEST_TYPE = ", */*; q=0.09";
    private static final String DEFAULT_REQUEST = "application/rdf+xml, application/xml; q=0.7, text/xml; q=0.6, text/plain; q=0.1, */*; q=0.09";

    private DocumentSources() {
    }

    public static Reader wrapInputAsReader(OWLOntologyDocumentSource source, OWLOntologyLoaderConfiguration configuration, Charset encoding) throws OWLOntologyInputSourceException {
        Optional<Reader> reader = source.getReader();
        if (reader.isPresent()) {
            return new BufferedReader(reader.get());
        }
        return new BufferedReader(new InputStreamReader(DocumentSources.wrap(DocumentSources.wrapInput(source, configuration)), encoding));
    }

    public static Reader wrapInputAsReader(OWLOntologyDocumentSource source, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyInputSourceException {
        return DocumentSources.wrapInputAsReader(source, configuration, StandardCharsets.UTF_8);
    }

    public static InputStream wrapInput(OWLOntologyDocumentSource source, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyInputSourceException {
        Optional<InputStream> input = source.getInputStream();
        if (!input.isPresent() && !source.hasAlredyFailedOnIRIResolution()) {
            if (source.getDocumentIRI().getNamespace().startsWith("jar:")) {
                if (source.getDocumentIRI().getNamespace().startsWith("jar:!")) {
                    Object name = source.getDocumentIRI().toString().substring(5);
                    if (!((String)name).startsWith("/")) {
                        name = "/" + (String)name;
                    }
                    return DocumentSources.class.getResourceAsStream((String)name);
                }
                try {
                    return DocumentSources.streamFromJar(source.getDocumentIRI()).getInputStream();
                }
                catch (IOException e) {
                    source.setIRIResolutionFailed(true);
                    throw new OWLParserException(e);
                }
            }
            Optional<String> headers = source.getAcceptHeaders();
            input = headers.isPresent() ? DocumentSources.getInputStream(source.getDocumentIRI(), configuration, headers.get()) : DocumentSources.getInputStream(source.getDocumentIRI(), configuration, DEFAULT_REQUEST);
        }
        if (input.isPresent()) {
            return new BufferedInputStream(input.get());
        }
        throw new OWLOntologyInputSourceException("No input reader can be found");
    }

    protected static JarURLConnection streamFromJar(IRI documentIRI) throws IOException, MalformedURLException {
        return (JarURLConnection)new URL(documentIRI.toString()).openConnection();
    }

    @Deprecated
    public static Optional<InputStream> getInputStream(IRI documentIRI, OWLOntologyLoaderConfiguration config) throws OWLOntologyInputSourceException {
        return DocumentSources.getInputStream(documentIRI, config, DEFAULT_REQUEST);
    }

    public static Optional<InputStream> getInputStream(IRI documentIRI, OWLOntologyLoaderConfiguration config, String acceptHeaders) throws OWLOntologyInputSourceException {
        try {
            URL originalURL = documentIRI.toURI().toURL();
            URLConnection conn = originalURL.openConnection();
            Object actualAcceptHeaders = acceptHeaders;
            if (!acceptHeaders.contains("text/plain")) {
                actualAcceptHeaders = (String)actualAcceptHeaders + TEXTPLAIN_REQUEST_TYPE;
            }
            if (!acceptHeaders.contains("*/*")) {
                actualAcceptHeaders = (String)actualAcceptHeaders + LAST_REQUEST_TYPE;
            }
            conn.addRequestProperty("Accept", (String)actualAcceptHeaders);
            if (config.getAuthorizationValue() != null && !config.getAuthorizationValue().isEmpty()) {
                conn.setRequestProperty("Authorization", config.getAuthorizationValue());
            }
            if (config.isAcceptingHTTPCompression()) {
                conn.setRequestProperty("Accept-Encoding", ACCEPTABLE_CONTENT_ENCODING);
            }
            int connectionTimeout = config.getConnectionTimeout();
            conn.setConnectTimeout(connectionTimeout);
            conn = DocumentSources.connect(config, conn, connectionTimeout, (String)actualAcceptHeaders, new HashSet<String>());
            String contentEncoding = conn.getContentEncoding();
            InputStream is = DocumentSources.connectWithFiveRetries(documentIRI, config, conn, connectionTimeout, contentEncoding);
            if (is == null) {
                return OWLAPIPreconditions.emptyOptional();
            }
            return OWLAPIPreconditions.optional(is);
        }
        catch (IOException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    protected static URLConnection connect(OWLOntologyLoaderConfiguration config, URLConnection conn, int connectionTimeout, String acceptHeaders, Set<String> visited) throws IOException {
        if (conn instanceof HttpURLConnection && config.isFollowRedirects()) {
            HttpURLConnection con = (HttpURLConnection)conn;
            con.connect();
            int responseCode = con.getResponseCode();
            if (responseCode == 302 || responseCode == 301 || responseCode == 303 || responseCode == 307 || responseCode == 308) {
                String location = con.getHeaderField("Location");
                if (visited.add(location)) {
                    URL newURL = new URL(location);
                    return DocumentSources.connect(config, DocumentSources.rebuildConnection(config, connectionTimeout, newURL, acceptHeaders), connectionTimeout, acceptHeaders, visited);
                }
                throw new IllegalStateException("Infinite loop: redirect cycle detected. " + String.valueOf(visited));
            }
        }
        return conn;
    }

    protected static URLConnection rebuildConnection(OWLOntologyLoaderConfiguration config, int connectionTimeout, URL newURL, String acceptHeaders) throws IOException {
        URLConnection conn = newURL.openConnection();
        conn.addRequestProperty("Accept", acceptHeaders);
        if (config.isAcceptingHTTPCompression()) {
            conn.setRequestProperty("Accept-Encoding", ACCEPTABLE_CONTENT_ENCODING);
        }
        conn.setConnectTimeout(connectionTimeout);
        return conn;
    }

    @Nullable
    protected static InputStream connectWithFiveRetries(IRI documentIRI, OWLOntologyLoaderConfiguration config, URLConnection conn, int connectionTimeout, String contentEncoding) throws IOException, OWLOntologyInputSourceException {
        InputStream is = null;
        int count = 0;
        while (count < config.getRetriesToAttempt() && is == null) {
            try {
                is = DocumentSources.getInputStreamFromContentEncoding(documentIRI, conn, contentEncoding);
            }
            catch (SocketTimeoutException e) {
                if (++count == 5) {
                    throw new OWLOntologyInputSourceException("cannot connect to " + String.valueOf(documentIRI) + "; retry limit exhausted", e);
                }
                conn.setConnectTimeout(connectionTimeout + connectionTimeout * count);
            }
        }
        return is;
    }

    public static InputStream wrap(InputStream delegate) {
        OWLAPIPreconditions.checkNotNull(delegate, "delegate cannot be null");
        return new BOMInputStream(delegate, new ByteOrderMark[]{ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE});
    }

    private static boolean couldBeOntology(@Nullable ZipEntry zipEntry) {
        if (zipEntry == null) {
            return false;
        }
        return ZIP_ENTRY_ONTOLOGY_NAME_PATTERN.matcher(zipEntry.getName()).matches();
    }

    private static InputStream getInputStreamFromContentEncoding(@Nullable IRI documentIRI, URLConnection conn, @Nullable String contentEncoding) throws IOException {
        InputStream toReturn;
        String fileName = DocumentSources.getFileNameFromContentDisposition(conn);
        if (fileName == null) {
            fileName = documentIRI == null ? "" : documentIRI.toString();
        }
        InputStream in = conn.getInputStream();
        if (contentEncoding != null && (toReturn = DocumentSources.handleKnownContentEncodings(contentEncoding, in, fileName)) != null) {
            return toReturn;
        }
        return DocumentSources.wrap(DocumentSources.checkFileName(in, fileName));
    }

    private static InputStream checkFileName(InputStream in, String fileName) throws IOException {
        if (DocumentSources.isGzFileName(fileName)) {
            LOGGER.info("URL connection has no content encoding but name ends with .gz");
            return new BufferedInputStream(new GZIPInputStream(in));
        }
        if (DocumentSources.isXzFileName(fileName)) {
            LOGGER.info("URL connection has no content encoding but name ends with .xz");
            return new BufferedInputStream((InputStream)new XZInputStream(in));
        }
        if (DocumentSources.isZipFileName(fileName)) {
            ZipInputStream zis = new ZipInputStream(in);
            ZipEntry entry = null;
            ZipEntry nextEntry = zis.getNextEntry();
            while (entry != null && nextEntry != null) {
                if (DocumentSources.couldBeOntology(nextEntry)) {
                    entry = nextEntry;
                }
                nextEntry = zis.getNextEntry();
            }
            return zis;
        }
        return in;
    }

    @Nullable
    protected static InputStream handleKnownContentEncodings(String contentEncoding, InputStream in, String fileName) throws IOException {
        if ("xz".equals(contentEncoding)) {
            LOGGER.info("URL connection input stream is compressed using xz");
            return new BufferedInputStream(DocumentSources.checkFileName((InputStream)new XZInputStream(in), fileName));
        }
        if ("gzip".equals(contentEncoding)) {
            LOGGER.info("URL connection input stream is compressed using gzip");
            return new BufferedInputStream(DocumentSources.checkFileName(new GZIPInputStream(in), fileName));
        }
        if ("deflate".equals(contentEncoding)) {
            LOGGER.info("URL connection input stream is compressed using deflate");
            return DocumentSources.checkFileName(new InflaterInputStream(in, new Inflater(true)), fileName);
        }
        return null;
    }

    @Nullable
    private static String getFileNameFromContentDisposition(URLConnection connection) {
        Matcher matcher;
        String contentDispositionHeaderValue = connection.getHeaderField(CONTENT_DISPOSITION_HEADER);
        if (contentDispositionHeaderValue != null && (matcher = CONTENT_DISPOSITION_FILE_NAME_PATTERN.matcher(contentDispositionHeaderValue)).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private static boolean isZipFileName(String fileName) {
        return fileName.toLowerCase(Locale.getDefault()).endsWith(ZIP_FILE_EXTENSION);
    }

    private static boolean isGzFileName(String fileName) {
        return fileName.toLowerCase(Locale.getDefault()).endsWith(GZ_FILE_EXTENSION);
    }

    private static boolean isXzFileName(String fileName) {
        return fileName.toLowerCase(Locale.getDefault()).endsWith(XZ_FILE_EXTENSION);
    }
}

