/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;
import org.semanticweb.owlapi.util.RemappingIndividualProvider;

public class CoerceConstantsIntoDataPropertyRange
extends AbstractCompositeOntologyChange {
    public CoerceConstantsIntoDataPropertyRange(OWLOntologyManager m, Collection<OWLOntology> ontologies) {
        super(m.getOWLDataFactory());
        OWLAPIPreconditions.checkNotNull(ontologies, "ontologies cannot be null");
        Map<OWLDataPropertyExpression, OWLDatatype> map = OWLAPIStreamUtils.asMap(this.datatypes(ontologies), ax -> (OWLDataPropertyExpression)ax.getProperty(), ax -> ((OWLDataRange)ax.getRange()).asOWLDatatype());
        OWLConstantReplacer replacer = new OWLConstantReplacer(m, map);
        ontologies.forEach(o -> o.logicalAxioms().forEach(ax -> this.duplicate(replacer, (OWLOntology)o, (OWLLogicalAxiom)ax)));
    }

    public Stream<OWLDataPropertyRangeAxiom> datatypes(Collection<OWLOntology> ontologies) {
        return ontologies.stream().flatMap(ont -> ont.axioms(AxiomType.DATA_PROPERTY_RANGE)).filter(ax -> ((OWLDataRange)ax.getRange()).isOWLDatatype());
    }

    protected void duplicate(OWLConstantReplacer replacer, OWLOntology o, OWLLogicalAxiom ax) {
        OWLAxiom dupAx = replacer.duplicateObject(ax);
        if (!ax.equals(dupAx)) {
            this.addChange(new RemoveAxiom(o, ax));
            this.addChange(new AddAxiom(o, dupAx));
        }
    }

    private class OWLConstantReplacer
    extends OWLObjectDuplicator {
        private final Map<OWLDataPropertyExpression, OWLDatatype> map;

        OWLConstantReplacer(OWLOntologyManager m, Map<OWLDataPropertyExpression, OWLDatatype> map) {
            super(Collections.emptyMap(), Collections.emptyMap(), m, new RemappingIndividualProvider(false, m.getOWLDataFactory()));
            this.map = map;
        }

        private OWLDataOneOf process(OWLDataPropertyExpression prop, OWLDataOneOf oneOf) {
            return CoerceConstantsIntoDataPropertyRange.this.df.getOWLDataOneOf(oneOf.values().map(c -> this.process(prop, (OWLLiteral)c)));
        }

        private OWLLiteral process(OWLDataPropertyExpression prop, OWLLiteral con) {
            OWLDatatype dt = this.map.get(prop);
            if (dt == null) {
                return con;
            }
            return CoerceConstantsIntoDataPropertyRange.this.df.getOWLLiteral(con.getLiteral(), dt);
        }

        @Override
        public OWLDataHasValue visit(OWLDataHasValue ce) {
            return CoerceConstantsIntoDataPropertyRange.this.df.getOWLDataHasValue((OWLDataPropertyExpression)ce.getProperty(), this.process((OWLDataPropertyExpression)ce.getProperty(), (OWLLiteral)ce.getFiller()));
        }

        @Override
        public OWLDataSomeValuesFrom visit(OWLDataSomeValuesFrom ce) {
            if (ce.getFiller() instanceof OWLDataOneOf) {
                return CoerceConstantsIntoDataPropertyRange.this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)ce.getProperty(), this.process((OWLDataPropertyExpression)ce.getProperty(), (OWLDataOneOf)ce.getFiller()));
            }
            return super.visit(ce);
        }

        @Override
        public OWLDataMinCardinality visit(OWLDataMinCardinality ce) {
            if (ce.getFiller() instanceof OWLDataOneOf) {
                return CoerceConstantsIntoDataPropertyRange.this.df.getOWLDataMinCardinality(ce.getCardinality(), (OWLDataPropertyExpression)ce.getProperty(), this.process((OWLDataPropertyExpression)ce.getProperty(), (OWLDataOneOf)ce.getFiller()));
            }
            return super.visit(ce);
        }

        @Override
        public OWLDataMaxCardinality visit(OWLDataMaxCardinality ce) {
            if (ce.getFiller() instanceof OWLDataOneOf) {
                return CoerceConstantsIntoDataPropertyRange.this.df.getOWLDataMaxCardinality(ce.getCardinality(), (OWLDataPropertyExpression)ce.getProperty(), this.process((OWLDataPropertyExpression)ce.getProperty(), (OWLDataOneOf)ce.getFiller()));
            }
            return super.visit(ce);
        }

        @Override
        public OWLDataExactCardinality visit(OWLDataExactCardinality ce) {
            if (ce.getFiller() instanceof OWLDataOneOf) {
                return CoerceConstantsIntoDataPropertyRange.this.df.getOWLDataExactCardinality(ce.getCardinality(), (OWLDataPropertyExpression)ce.getProperty(), this.process((OWLDataPropertyExpression)ce.getProperty(), (OWLDataOneOf)ce.getFiller()));
            }
            return super.visit(ce);
        }

        @Override
        public OWLDataAllValuesFrom visit(OWLDataAllValuesFrom ce) {
            if (ce.getFiller() instanceof OWLDataOneOf) {
                return CoerceConstantsIntoDataPropertyRange.this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)ce.getProperty(), this.process((OWLDataPropertyExpression)ce.getProperty(), (OWLDataOneOf)ce.getFiller()));
            }
            return super.visit(ce);
        }

        @Override
        public OWLDataPropertyAssertionAxiom visit(OWLDataPropertyAssertionAxiom axiom) {
            return CoerceConstantsIntoDataPropertyRange.this.df.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)axiom.getProperty(), axiom.getSubject(), this.process((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject()));
        }

        @Override
        public OWLNegativeDataPropertyAssertionAxiom visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
            return CoerceConstantsIntoDataPropertyRange.this.df.getOWLNegativeDataPropertyAssertionAxiom((OWLDataPropertyExpression)axiom.getProperty(), axiom.getSubject(), this.process((OWLDataPropertyExpression)axiom.getProperty(), (OWLLiteral)axiom.getObject()));
        }
    }
}

