/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.concurrent;

import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ChangeDetails;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasAxiomsByType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import uk.ac.manchester.cs.owl.owlapi.HasTrimToSize;

public class ConcurrentOWLOntologyImpl
implements OWLMutableOntology,
HasTrimToSize {
    private final OWLOntology delegate;
    private ReadWriteLock lock;

    @Inject
    public ConcurrentOWLOntologyImpl(OWLOntology delegate, ReadWriteLock readWriteLock) {
        this.delegate = (OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)delegate);
        this.lock = (ReadWriteLock)OWLAPIPreconditions.verifyNotNull((Object)readWriteLock);
    }

    public int typeIndex() {
        return this.delegate.typeIndex();
    }

    public void setLock(ReadWriteLock lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withWriteLock(Supplier<T> t) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            T t2 = t.get();
            return t2;
        }
        finally {
            writeLock.unlock();
        }
    }

    private void callWriteLock(Runnable t) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            t.run();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withReadLock(Supplier<T> t) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            T t2 = t.get();
            return t2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean withBooleanReadLock(BooleanSupplier t) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = t.getAsBoolean();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int withIntReadLock(IntSupplier t) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            int n = t.getAsInt();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    private void callReadLock(Store t) throws OWLOntologyStorageException {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            t.store();
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void trimToSize() {
        this.callWriteLock(this::trimToSizeInternal);
    }

    protected void trimToSizeInternal() {
        if (this.delegate instanceof HasTrimToSize) {
            ((HasTrimToSize)this.delegate).trimToSize();
        }
    }

    public void accept(OWLNamedObjectVisitor owlNamedObjectVisitor) {
        this.delegate.accept(owlNamedObjectVisitor);
    }

    public <O> O accept(OWLNamedObjectVisitorEx<O> owlNamedObjectVisitorEx) {
        return (O)this.delegate.accept(owlNamedObjectVisitorEx);
    }

    public int hashCode() {
        return this.withIntReadLock(() -> ((OWLOntology)this.delegate).hashCode());
    }

    public boolean equals(@Nullable Object obj) {
        return this.withBooleanReadLock(() -> this.delegate.equals(obj));
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getOWLOntologyManager());
    }

    public void setOWLOntologyManager(@Nullable OWLOntologyManager owlOntologyManager) {
        this.callWriteLock(() -> this.delegate.setOWLOntologyManager(owlOntologyManager));
    }

    public OWLOntologyID getOntologyID() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getOntologyID());
    }

    public boolean isAnonymous() {
        return this.withBooleanReadLock(() -> ((OWLOntology)this.delegate).isAnonymous());
    }

    public Set<OWLAnnotation> getAnnotations() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getAnnotations());
    }

    public Set<IRI> getDirectImportsDocuments() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getDirectImportsDocuments());
    }

    public Stream<IRI> directImportsDocuments() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).directImportsDocuments());
    }

    public Set<OWLOntology> getDirectImports() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getDirectImports());
    }

    public Stream<OWLOntology> directImports() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).directImports());
    }

    public Set<OWLOntology> getImports() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getImports());
    }

    public Stream<OWLOntology> imports() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).imports());
    }

    public Set<OWLOntology> getImportsClosure() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getImportsClosure());
    }

    public Stream<OWLOntology> importsClosure() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).importsClosure());
    }

    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getImportsDeclarations());
    }

    public boolean isEmpty() {
        return this.withBooleanReadLock(() -> ((OWLOntology)this.delegate).isEmpty());
    }

    public Set<OWLAxiom> getTBoxAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.getTBoxAxioms(imports));
    }

    public Set<OWLAxiom> getABoxAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.getABoxAxioms(imports));
    }

    public Set<OWLAxiom> getRBoxAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.getRBoxAxioms(imports));
    }

    public Stream<OWLAxiom> tboxAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.tboxAxioms(imports));
    }

    public Stream<OWLAxiom> aboxAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.aboxAxioms(imports));
    }

    public Stream<OWLAxiom> rboxAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.rboxAxioms(imports));
    }

    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getGeneralClassAxioms());
    }

    public Set<OWLEntity> getSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getSignature());
    }

    public Set<OWLEntity> getSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getSignature(imports));
    }

    public Stream<OWLClassAxiom> generalClassAxioms() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).generalClassAxioms());
    }

    public Stream<OWLEntity> signature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).signature());
    }

    public Stream<OWLEntity> signature(Imports imports) {
        return this.withReadLock(() -> this.delegate.signature(imports));
    }

    public boolean isDeclared(OWLEntity owlEntity) {
        return this.withBooleanReadLock(() -> this.delegate.isDeclared(owlEntity));
    }

    public boolean isDeclared(OWLEntity owlEntity, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.isDeclared(owlEntity, imports));
    }

    public void saveOntology() throws OWLOntologyStorageException {
        this.callReadLock(() -> ((OWLOntology)this.delegate).saveOntology());
    }

    public void saveOntology(IRI iri) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(iri));
    }

    public void saveOntology(OutputStream outputStream) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(outputStream));
    }

    public void saveOntology(OWLDocumentFormat owlDocumentFormat) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlDocumentFormat));
    }

    public void saveOntology(OWLDocumentFormat owlDocumentFormat, IRI iri) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlDocumentFormat, iri));
    }

    public void saveOntology(OWLDocumentFormat owlDocumentFormat, OutputStream outputStream) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlDocumentFormat, outputStream));
    }

    public void saveOntology(OWLOntologyDocumentTarget owlOntologyDocumentTarget) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlOntologyDocumentTarget));
    }

    public void saveOntology(OWLDocumentFormat owlDocumentFormat, OWLOntologyDocumentTarget owlOntologyDocumentTarget) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlDocumentFormat, owlOntologyDocumentTarget));
    }

    public Set<OWLClassExpression> getNestedClassExpressions() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getNestedClassExpressions());
    }

    public void accept(OWLObjectVisitor owlObjectVisitor) {
        this.delegate.accept(owlObjectVisitor);
    }

    public <O> O accept(OWLObjectVisitorEx<O> owlObjectVisitorEx) {
        return (O)this.delegate.accept(owlObjectVisitorEx);
    }

    public boolean isTopEntity() {
        return this.withBooleanReadLock(() -> ((OWLOntology)this.delegate).isTopEntity());
    }

    public boolean isBottomEntity() {
        return this.withBooleanReadLock(() -> ((OWLOntology)this.delegate).isBottomEntity());
    }

    public String toString() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).toString());
    }

    public int compareTo(@Nullable OWLObject o) {
        return this.withIntReadLock(() -> this.delegate.compareTo((Object)o));
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(owlEntity));
    }

    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntitiesOfTypeInSignature(type));
    }

    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type, Imports includeImportsClosure) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntitiesOfTypeInSignature(type, includeImportsClosure));
    }

    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getAnonymousIndividuals());
    }

    public Set<OWLClass> getClassesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getClassesInSignature());
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getObjectPropertiesInSignature());
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getDataPropertiesInSignature());
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getIndividualsInSignature());
    }

    public Set<OWLDatatype> getDatatypesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getDatatypesInSignature());
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getAnnotationPropertiesInSignature());
    }

    public Set<OWLAxiom> getAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(imports));
    }

    public int getAxiomCount(Imports imports) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(imports));
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.getLogicalAxioms(imports));
    }

    public int getLogicalAxiomCount(Imports imports) {
        return this.withIntReadLock(() -> this.delegate.getLogicalAxiomCount(imports));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(axiomType, imports));
    }

    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> axiomType, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(axiomType, imports));
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, Imports imports) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(axiomType, imports));
    }

    public boolean containsAxiom(OWLAxiom owlAxiom, Imports imports, AxiomAnnotations axiomAnnotations) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiom(owlAxiom, imports, axiomAnnotations));
    }

    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom owlAxiom, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxiomsIgnoreAnnotations(owlAxiom, imports));
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom owlAxiom, Imports imports) {
        return this.withReadLock(() -> this.delegate.axiomsIgnoreAnnotations(owlAxiom, imports));
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlPrimitive, Imports imports) {
        return this.withReadLock(() -> this.delegate.getReferencingAxioms(owlPrimitive, imports));
    }

    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive owlPrimitive, Imports imports) {
        return this.withReadLock(() -> this.delegate.referencingAxioms(owlPrimitive, imports));
    }

    public Set<OWLClassAxiom> getAxioms(OWLClass owlClass, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlClass, imports));
    }

    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlObjectPropertyExpression, imports));
    }

    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty owlDataProperty, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDataProperty, imports));
    }

    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual owlIndividual, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlIndividual, imports));
    }

    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty owlAnnotationProperty, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlAnnotationProperty, imports));
    }

    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype owlDatatype, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDatatype, imports));
    }

    public Set<OWLAxiom> getAxioms() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getAxioms());
    }

    public Stream<OWLAxiom> axioms() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).axioms());
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getLogicalAxioms());
    }

    public Stream<OWLLogicalAxiom> logicalAxioms() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).logicalAxioms());
    }

    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType) {
        return this.withReadLock(() -> this.delegate.getAxioms(axiomType));
    }

    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> axiomType) {
        return this.withReadLock(() -> this.delegate.axioms(axiomType));
    }

    public boolean equalAxioms(HasAxiomsByType o) {
        return this.withBooleanReadLock(() -> this.delegate.equalAxioms(o));
    }

    public boolean containsAxiom(OWLAxiom owlAxiom) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiom(owlAxiom));
    }

    public Set<OWLAxiom> getAxioms(boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(b));
    }

    public int getAxiomCount(boolean b) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(b));
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms(boolean b) {
        return this.withReadLock(() -> this.delegate.getLogicalAxioms(b));
    }

    public int getLogicalAxiomCount(boolean b) {
        return this.withIntReadLock(() -> this.delegate.getLogicalAxiomCount(b));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> axiomType, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(axiomType, b));
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, boolean b) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(axiomType, b));
    }

    public boolean containsAxiom(OWLAxiom owlAxiom, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiom(owlAxiom, b));
    }

    public boolean containsAxiomIgnoreAnnotations(OWLAxiom owlAxiom, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiomIgnoreAnnotations(owlAxiom, b));
    }

    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom owlAxiom, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxiomsIgnoreAnnotations(owlAxiom, b));
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlPrimitive, boolean b) {
        return this.withReadLock(() -> this.delegate.getReferencingAxioms(owlPrimitive, b));
    }

    public Set<OWLClassAxiom> getAxioms(OWLClass owlClass, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlClass, b));
    }

    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlObjectPropertyExpression, b));
    }

    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty owlDataProperty, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDataProperty, b));
    }

    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual owlIndividual, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlIndividual, b));
    }

    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty owlAnnotationProperty, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlAnnotationProperty, b));
    }

    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype owlDatatype, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDatatype, b));
    }

    public int getAxiomCount() {
        return this.withIntReadLock(() -> ((OWLOntology)this.delegate).getAxiomCount());
    }

    public int getLogicalAxiomCount() {
        return this.withIntReadLock(() -> ((OWLOntology)this.delegate).getLogicalAxiomCount());
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(axiomType));
    }

    public boolean containsAxiomIgnoreAnnotations(OWLAxiom owlAxiom) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiomIgnoreAnnotations(owlAxiom));
    }

    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom owlAxiom) {
        return this.withReadLock(() -> this.delegate.getAxiomsIgnoreAnnotations(owlAxiom));
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom owlAxiom) {
        return this.withReadLock(() -> this.delegate.axiomsIgnoreAnnotations(owlAxiom));
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive owlPrimitive) {
        return this.withReadLock(() -> this.delegate.getReferencingAxioms(owlPrimitive));
    }

    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive owlPrimitive) {
        return this.withReadLock(() -> this.delegate.referencingAxioms(owlPrimitive));
    }

    public Set<OWLClassAxiom> getAxioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlClass));
    }

    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDataProperty));
    }

    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlIndividual));
    }

    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlAnnotationProperty));
    }

    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype owlDatatype) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDatatype));
    }

    public Stream<OWLClassAxiom> axioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.axioms(owlClass));
    }

    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.axioms(owlObjectPropertyExpression));
    }

    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.axioms(owlDataProperty));
    }

    public Stream<OWLIndividualAxiom> axioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.axioms(owlIndividual));
    }

    public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.axioms(owlAnnotationProperty));
    }

    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype owlDatatype) {
        return this.withReadLock(() -> this.delegate.axioms(owlDatatype));
    }

    public Set<OWLClass> getClassesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getClassesInSignature(imports));
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getObjectPropertiesInSignature(imports));
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getDataPropertiesInSignature(imports));
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getIndividualsInSignature(imports));
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(Imports imports) {
        return this.withReadLock(() -> this.delegate.getReferencedAnonymousIndividuals(imports));
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals(Imports imports) {
        return this.withReadLock(() -> this.delegate.referencedAnonymousIndividuals(imports));
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).referencedAnonymousIndividuals());
    }

    public Set<OWLDatatype> getDatatypesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getDatatypesInSignature(imports));
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.getAnnotationPropertiesInSignature(imports));
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(owlEntity, imports));
    }

    public boolean containsEntityInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(iri, imports));
    }

    public boolean containsClassInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsClassInSignature(iri, imports));
    }

    public boolean containsObjectPropertyInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsObjectPropertyInSignature(iri, imports));
    }

    public boolean containsDataPropertyInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsDataPropertyInSignature(iri, imports));
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsAnnotationPropertyInSignature(iri, imports));
    }

    public boolean containsDatatypeInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsDatatypeInSignature(iri, imports));
    }

    public boolean containsIndividualInSignature(IRI iri, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsIndividualInSignature(iri, imports));
    }

    public boolean containsDatatypeInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsDatatypeInSignature(iri));
    }

    public boolean containsEntityInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(iri));
    }

    public boolean containsClassInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsClassInSignature(iri));
    }

    public boolean containsObjectPropertyInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsObjectPropertyInSignature(iri));
    }

    public boolean containsDataPropertyInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsDataPropertyInSignature(iri));
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsAnnotationPropertyInSignature(iri));
    }

    public boolean containsIndividualInSignature(IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsIndividualInSignature(iri));
    }

    public Set<OWLEntity> getEntitiesInSignature(IRI iri, Imports imports) {
        return this.withReadLock(() -> this.delegate.getEntitiesInSignature(iri, imports));
    }

    public Set<IRI> getPunnedIRIs(Imports imports) {
        return this.withReadLock(() -> this.delegate.getPunnedIRIs(imports));
    }

    public boolean containsReference(OWLEntity owlEntity, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsReference(owlEntity, imports));
    }

    public boolean containsReference(OWLEntity owlEntity) {
        return this.withBooleanReadLock(() -> this.delegate.containsReference(owlEntity));
    }

    public Set<OWLEntity> getEntitiesInSignature(IRI iri) {
        return this.withReadLock(() -> this.delegate.getEntitiesInSignature(iri));
    }

    public Stream<OWLEntity> entitiesInSignature(IRI iri) {
        return this.withReadLock(() -> this.delegate.entitiesInSignature(iri));
    }

    public Set<OWLClass> getClassesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getClassesInSignature(b));
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getObjectPropertiesInSignature(b));
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getDataPropertiesInSignature(b));
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getIndividualsInSignature(b));
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(boolean b) {
        return this.withReadLock(() -> this.delegate.getReferencedAnonymousIndividuals(b));
    }

    public Set<OWLDatatype> getDatatypesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getDatatypesInSignature(b));
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getAnnotationPropertiesInSignature(b));
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(owlEntity, b));
    }

    public boolean containsEntityInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(iri, b));
    }

    public boolean containsClassInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsClassInSignature(iri, b));
    }

    public boolean containsObjectPropertyInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsObjectPropertyInSignature(iri, b));
    }

    public boolean containsDataPropertyInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsDataPropertyInSignature(iri, b));
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsAnnotationPropertyInSignature(iri, b));
    }

    public boolean containsDatatypeInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsDatatypeInSignature(iri, b));
    }

    public boolean containsIndividualInSignature(IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsIndividualInSignature(iri, b));
    }

    public Set<OWLEntity> getEntitiesInSignature(IRI iri, boolean b) {
        return this.withReadLock(() -> this.delegate.getEntitiesInSignature(iri, b));
    }

    public boolean containsReference(OWLEntity owlEntity, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsReference(owlEntity, b));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> aClass, OWLObject owlObject, Imports imports, Navigation navigation) {
        return this.withReadLock(() -> this.delegate.getAxioms(aClass, owlObject, imports, navigation));
    }

    public <T extends OWLAxiom> Stream<T> axioms(Class<T> aClass, OWLObject owlObject, Imports imports, Navigation navigation) {
        return this.withReadLock(() -> this.delegate.axioms(aClass, owlObject, imports, navigation));
    }

    public <T extends OWLAxiom> Collection<T> filterAxioms(OWLAxiomSearchFilter owlAxiomSearchFilter, Object o, Imports imports) {
        return this.withReadLock(() -> this.delegate.filterAxioms(owlAxiomSearchFilter, o, imports));
    }

    public boolean contains(OWLAxiomSearchFilter owlAxiomSearchFilter, Object o, Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.contains(owlAxiomSearchFilter, o, imports));
    }

    public boolean contains(OWLAxiomSearchFilter owlAxiomSearchFilter, Object o) {
        return this.withBooleanReadLock(() -> this.delegate.contains(owlAxiomSearchFilter, o));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> aClass, Class<? extends OWLObject> aClass1, OWLObject owlObject, Imports imports, Navigation navigation) {
        return this.withReadLock(() -> this.delegate.getAxioms(aClass, aClass1, owlObject, imports, navigation));
    }

    public <T extends OWLAxiom> Stream<T> axioms(Class<T> aClass, Class<? extends OWLObject> aClass1, OWLObject owlObject, Imports imports, Navigation navigation) {
        return this.withReadLock(() -> this.delegate.axioms(aClass, aClass1, owlObject, imports, navigation));
    }

    public Set<OWLSubAnnotationPropertyOfAxiom> getSubAnnotationPropertyOfAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.getSubAnnotationPropertyOfAxioms(owlAnnotationProperty));
    }

    public Set<OWLAnnotationPropertyDomainAxiom> getAnnotationPropertyDomainAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.getAnnotationPropertyDomainAxioms(owlAnnotationProperty));
    }

    public Set<OWLAnnotationPropertyRangeAxiom> getAnnotationPropertyRangeAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.getAnnotationPropertyRangeAxioms(owlAnnotationProperty));
    }

    public Stream<OWLAnnotationPropertyDomainAxiom> annotationPropertyDomainAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.annotationPropertyDomainAxioms(owlAnnotationProperty));
    }

    public Stream<OWLAnnotationPropertyRangeAxiom> annotationPropertyRangeAxioms(OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.annotationPropertyRangeAxioms(owlAnnotationProperty));
    }

    public Set<OWLDeclarationAxiom> getDeclarationAxioms(OWLEntity owlEntity) {
        return this.withReadLock(() -> this.delegate.getDeclarationAxioms(owlEntity));
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject owlAnnotationSubject) {
        return this.withReadLock(() -> this.delegate.getAnnotationAssertionAxioms(owlAnnotationSubject));
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getSubClassAxiomsForSubClass(owlClass));
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getSubClassAxiomsForSuperClass(owlClass));
    }

    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getEquivalentClassesAxioms(owlClass));
    }

    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getDisjointClassesAxioms(owlClass));
    }

    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getDisjointUnionAxioms(owlClass));
    }

    public Set<OWLHasKeyAxiom> getHasKeyAxioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getHasKeyAxioms(owlClass));
    }

    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getObjectSubPropertyAxiomsForSubProperty(owlObjectPropertyExpression));
    }

    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getObjectSubPropertyAxiomsForSuperProperty(owlObjectPropertyExpression));
    }

    public Set<OWLObjectPropertyDomainAxiom> getObjectPropertyDomainAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getObjectPropertyDomainAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLObjectPropertyRangeAxiom> getObjectPropertyRangeAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getObjectPropertyRangeAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLInverseObjectPropertiesAxiom> getInverseObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getInverseObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLEquivalentObjectPropertiesAxiom> getEquivalentObjectPropertiesAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getEquivalentObjectPropertiesAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLDisjointObjectPropertiesAxiom> getDisjointObjectPropertiesAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getDisjointObjectPropertiesAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLFunctionalObjectPropertyAxiom> getFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getFunctionalObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLInverseFunctionalObjectPropertyAxiom> getInverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getInverseFunctionalObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLSymmetricObjectPropertyAxiom> getSymmetricObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getSymmetricObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLAsymmetricObjectPropertyAxiom> getAsymmetricObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getAsymmetricObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLReflexiveObjectPropertyAxiom> getReflexiveObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getReflexiveObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLIrreflexiveObjectPropertyAxiom> getIrreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getIrreflexiveObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLTransitiveObjectPropertyAxiom> getTransitiveObjectPropertyAxioms(OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getTransitiveObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSubProperty(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getDataSubPropertyAxiomsForSubProperty(owlDataProperty));
    }

    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression owlDataPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getDataSubPropertyAxiomsForSuperProperty(owlDataPropertyExpression));
    }

    public Set<OWLDataPropertyDomainAxiom> getDataPropertyDomainAxioms(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getDataPropertyDomainAxioms(owlDataProperty));
    }

    public Set<OWLDataPropertyRangeAxiom> getDataPropertyRangeAxioms(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getDataPropertyRangeAxioms(owlDataProperty));
    }

    public Set<OWLEquivalentDataPropertiesAxiom> getEquivalentDataPropertiesAxioms(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getEquivalentDataPropertiesAxioms(owlDataProperty));
    }

    public Set<OWLDisjointDataPropertiesAxiom> getDisjointDataPropertiesAxioms(OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getDisjointDataPropertiesAxioms(owlDataProperty));
    }

    public Set<OWLFunctionalDataPropertyAxiom> getFunctionalDataPropertyAxioms(OWLDataPropertyExpression owlDataPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getFunctionalDataPropertyAxioms(owlDataPropertyExpression));
    }

    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getClassAssertionAxioms(owlIndividual));
    }

    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLClassExpression owlClassExpression) {
        return this.withReadLock(() -> this.delegate.getClassAssertionAxioms(owlClassExpression));
    }

    public Set<OWLDataPropertyAssertionAxiom> getDataPropertyAssertionAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getDataPropertyAssertionAxioms(owlIndividual));
    }

    public Set<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getObjectPropertyAssertionAxioms(owlIndividual));
    }

    public Set<OWLNegativeObjectPropertyAssertionAxiom> getNegativeObjectPropertyAssertionAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getNegativeObjectPropertyAssertionAxioms(owlIndividual));
    }

    public Set<OWLNegativeDataPropertyAssertionAxiom> getNegativeDataPropertyAssertionAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getNegativeDataPropertyAssertionAxioms(owlIndividual));
    }

    public Set<OWLSameIndividualAxiom> getSameIndividualAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getSameIndividualAxioms(owlIndividual));
    }

    public Set<OWLDifferentIndividualsAxiom> getDifferentIndividualAxioms(OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getDifferentIndividualAxioms(owlIndividual));
    }

    public Set<OWLDatatypeDefinitionAxiom> getDatatypeDefinitions(OWLDatatype owlDatatype) {
        return this.withReadLock(() -> this.delegate.getDatatypeDefinitions(owlDatatype));
    }

    public ChangeApplied applyChange(OWLOntologyChange owlOntologyChange) {
        return this.withWriteLock(() -> this.getMutableOntology().applyChange(owlOntologyChange));
    }

    public ChangeDetails applyChangesAndGetDetails(List<? extends OWLOntologyChange> list) {
        return this.withWriteLock(() -> this.getMutableOntology().applyChangesAndGetDetails(list));
    }

    public ChangeApplied addAxiom(OWLAxiom owlAxiom) {
        return this.withWriteLock(() -> this.getMutableOntology().addAxiom(owlAxiom));
    }

    public ChangeApplied addAxioms(Collection<? extends OWLAxiom> set) {
        return this.withWriteLock(() -> this.getMutableOntology().addAxioms(set));
    }

    public ChangeApplied addAxioms(OWLAxiom ... set) {
        return this.withWriteLock(() -> this.getMutableOntology().addAxioms(set));
    }

    public ChangeApplied add(OWLAxiom owlAxiom) {
        return this.withWriteLock(() -> this.getMutableOntology().add(owlAxiom));
    }

    public ChangeApplied add(Collection<? extends OWLAxiom> set) {
        return this.withWriteLock(() -> this.getMutableOntology().add(set));
    }

    public ChangeApplied add(OWLAxiom ... set) {
        return this.withWriteLock(() -> this.getMutableOntology().add(set));
    }

    private OWLMutableOntology getMutableOntology() {
        return (OWLMutableOntology)this.delegate;
    }

    public Stream<OWLImportsDeclaration> importsDeclarations() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).importsDeclarations());
    }

    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key, Imports includeImportsClosure) {
        return this.withReadLock(() -> this.delegate.axioms(filter, key, includeImportsClosure));
    }

    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key) {
        return this.withReadLock(() -> this.delegate.axioms(filter, key));
    }

    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, Class<? extends OWLObject> explicitClass, OWLObject entity, Navigation forSubPosition) {
        return this.withReadLock(() -> this.delegate.axioms(type, explicitClass, entity, forSubPosition));
    }

    public Stream<OWLSubAnnotationPropertyOfAxiom> subAnnotationPropertyOfAxioms(OWLAnnotationProperty subProperty) {
        return this.withReadLock(() -> this.delegate.subAnnotationPropertyOfAxioms(subProperty));
    }

    public Stream<OWLDatatypeDefinitionAxiom> datatypeDefinitions(OWLDatatype datatype) {
        return this.withReadLock(() -> this.delegate.datatypeDefinitions(datatype));
    }

    public ChangeApplied removeAxiom(OWLAxiom axiom) {
        return this.withWriteLock(() -> this.delegate.removeAxiom(axiom));
    }

    public ChangeApplied removeAxioms(Collection<? extends OWLAxiom> axioms) {
        return this.withWriteLock(() -> this.delegate.removeAxioms(axioms));
    }

    public ChangeApplied removeAxioms(OWLAxiom ... axioms) {
        return this.withWriteLock(() -> this.delegate.removeAxioms(axioms));
    }

    public ChangeApplied remove(OWLAxiom axiom) {
        return this.withWriteLock(() -> this.delegate.remove(axiom));
    }

    public ChangeApplied remove(Collection<? extends OWLAxiom> axioms) {
        return this.withWriteLock(() -> this.delegate.remove(axioms));
    }

    public ChangeApplied remove(OWLAxiom ... axioms) {
        return this.withWriteLock(() -> this.delegate.remove(axioms));
    }

    public ChangeApplied applyDirectChange(OWLOntologyChange change) {
        return this.withWriteLock(() -> this.delegate.applyDirectChange(change));
    }

    public Stream<OWLDisjointObjectPropertiesAxiom> disjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.disjointObjectPropertiesAxioms(property));
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).objectPropertiesInSignature());
    }

    public Stream<OWLAnnotationAssertionAxiom> annotationAssertionAxioms(OWLAnnotationSubject entity) {
        return this.withReadLock(() -> this.delegate.annotationAssertionAxioms(entity));
    }

    public Stream<OWLAnnotationAssertionAxiom> annotationAssertionAxioms(OWLAnnotationSubject entity, Imports imports) {
        return this.withReadLock(() -> this.delegate.annotationAssertionAxioms(entity, imports));
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).annotationPropertiesInSignature());
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.annotationPropertiesInSignature(imports));
    }

    public Stream<OWLAnnotation> annotations() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).annotations());
    }

    public List<OWLAnnotation> annotationsAsList() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).annotationsAsList());
    }

    public Stream<OWLAnnotation> annotations(OWLAnnotationProperty p) {
        return this.withReadLock(() -> this.delegate.annotations(p));
    }

    public Stream<OWLAnnotation> annotations(Predicate<OWLAnnotation> p) {
        return this.withReadLock(() -> this.delegate.annotations(p));
    }

    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).anonymousIndividuals());
    }

    public Stream<OWLAsymmetricObjectPropertyAxiom> asymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.asymmetricObjectPropertyAxioms(property));
    }

    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, OWLObject entity, Navigation forSubPosition) {
        return this.withReadLock(() -> this.delegate.axioms(type, entity, forSubPosition));
    }

    public Stream<OWLAxiom> axioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(imports));
    }

    public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty property, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(property, imports));
    }

    public Stream<OWLClassAxiom> axioms(OWLClass cls, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(cls, imports));
    }

    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty property, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(property, imports));
    }

    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype datatype, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(datatype, imports));
    }

    public Stream<OWLIndividualAxiom> axioms(OWLIndividual individual, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(individual, imports));
    }

    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression property, Imports imports) {
        return this.withReadLock(() -> this.delegate.axioms(property, imports));
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLClassExpression ce) {
        return this.withReadLock(() -> this.delegate.classAssertionAxioms(ce));
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.classAssertionAxioms(individual));
    }

    public Stream<OWLClass> classesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).classesInSignature());
    }

    public Stream<OWLClass> classesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.classesInSignature(imports));
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).dataPropertiesInSignature());
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.dataPropertiesInSignature(imports));
    }

    public Stream<OWLDataPropertyAssertionAxiom> dataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.dataPropertyAssertionAxioms(individual));
    }

    public Stream<OWLDataPropertyDomainAxiom> dataPropertyDomainAxioms(OWLDataProperty property) {
        return this.withReadLock(() -> this.delegate.dataPropertyDomainAxioms(property));
    }

    public Stream<OWLDataPropertyRangeAxiom> dataPropertyRangeAxioms(OWLDataProperty property) {
        return this.withReadLock(() -> this.delegate.dataPropertyRangeAxioms(property));
    }

    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSubProperty(OWLDataProperty subProperty) {
        return this.withReadLock(() -> this.delegate.dataSubPropertyAxiomsForSubProperty(subProperty));
    }

    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression superProperty) {
        return this.withReadLock(() -> this.delegate.dataSubPropertyAxiomsForSuperProperty(superProperty));
    }

    public Stream<OWLDatatype> datatypesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).datatypesInSignature());
    }

    public Stream<OWLDatatype> datatypesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.datatypesInSignature(imports));
    }

    public Stream<OWLDeclarationAxiom> declarationAxioms(OWLEntity subject) {
        return this.withReadLock(() -> this.delegate.declarationAxioms(subject));
    }

    public Stream<OWLDifferentIndividualsAxiom> differentIndividualAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.differentIndividualAxioms(individual));
    }

    public Stream<OWLDisjointClassesAxiom> disjointClassesAxioms(OWLClass cls) {
        return this.withReadLock(() -> this.delegate.disjointClassesAxioms(cls));
    }

    public Stream<OWLDisjointDataPropertiesAxiom> disjointDataPropertiesAxioms(OWLDataProperty property) {
        return this.withReadLock(() -> this.delegate.disjointDataPropertiesAxioms(property));
    }

    public Stream<OWLDisjointUnionAxiom> disjointUnionAxioms(OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.disjointUnionAxioms(owlClass));
    }

    public Stream<OWLEntity> entitiesInSignature(IRI iri, Imports imports) {
        return this.withReadLock(() -> this.delegate.entitiesInSignature(iri, imports));
    }

    public Stream<OWLEquivalentClassesAxiom> equivalentClassesAxioms(OWLClass cls) {
        return this.withReadLock(() -> this.delegate.equivalentClassesAxioms(cls));
    }

    public Stream<OWLEquivalentDataPropertiesAxiom> equivalentDataPropertiesAxioms(OWLDataProperty property) {
        return this.withReadLock(() -> this.delegate.equivalentDataPropertiesAxioms(property));
    }

    public Stream<OWLEquivalentObjectPropertiesAxiom> equivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.equivalentObjectPropertiesAxioms(property));
    }

    public <T extends OWLAxiom> Collection<T> filterAxioms(OWLAxiomSearchFilter filter, Object key) {
        return this.withReadLock(() -> this.delegate.filterAxioms(filter, key));
    }

    public Stream<OWLFunctionalDataPropertyAxiom> functionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.functionalDataPropertyAxioms(property));
    }

    public Stream<OWLFunctionalObjectPropertyAxiom> functionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.functionalObjectPropertyAxioms(property));
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject entity, Imports imports) {
        return this.withReadLock(() -> this.delegate.getAnnotationAssertionAxioms(entity, imports));
    }

    public Set<OWLAnnotation> getAnnotations(OWLAnnotationProperty annotationProperty) {
        return this.withReadLock(() -> this.delegate.getAnnotations(annotationProperty));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, Class<? extends OWLObject> explicitClass, OWLObject entity, Navigation forSubPosition) {
        return this.withReadLock(() -> this.delegate.getAxioms(type, explicitClass, entity, forSubPosition));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, OWLObject entity, Navigation forSubPosition) {
        return this.withReadLock(() -> this.delegate.getAxioms(type, entity, forSubPosition));
    }

    @Nullable
    public OWLDocumentFormat getFormat() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getFormat());
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getReferencedAnonymousIndividuals());
    }

    public Stream<OWLHasKeyAxiom> hasKeyAxioms(OWLClass cls) {
        return this.withReadLock(() -> this.delegate.hasKeyAxioms(cls));
    }

    public Stream<OWLNamedIndividual> individualsInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).individualsInSignature());
    }

    public Stream<OWLNamedIndividual> individualsInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.individualsInSignature(imports));
    }

    public Stream<OWLInverseFunctionalObjectPropertyAxiom> inverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.inverseFunctionalObjectPropertyAxioms(property));
    }

    public Stream<OWLInverseObjectPropertiesAxiom> inverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.inverseObjectPropertyAxioms(property));
    }

    public Stream<OWLIrreflexiveObjectPropertyAxiom> irreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.irreflexiveObjectPropertyAxioms(property));
    }

    public Stream<OWLLogicalAxiom> logicalAxioms(Imports imports) {
        return this.withReadLock(() -> this.delegate.logicalAxioms(imports));
    }

    public Stream<OWLNegativeDataPropertyAssertionAxiom> negativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.negativeDataPropertyAssertionAxioms(individual));
    }

    public Stream<OWLNegativeObjectPropertyAssertionAxiom> negativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.negativeObjectPropertyAssertionAxioms(individual));
    }

    public Stream<OWLClassExpression> nestedClassExpressions() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).nestedClassExpressions());
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature(Imports imports) {
        return this.withReadLock(() -> this.delegate.objectPropertiesInSignature(imports));
    }

    public Stream<OWLObjectPropertyAssertionAxiom> objectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.objectPropertyAssertionAxioms(individual));
    }

    public Stream<OWLObjectPropertyDomainAxiom> objectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.objectPropertyDomainAxioms(property));
    }

    public Stream<OWLObjectPropertyRangeAxiom> objectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.objectPropertyRangeAxioms(property));
    }

    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression subProperty) {
        return this.withReadLock(() -> this.delegate.objectSubPropertyAxiomsForSubProperty(subProperty));
    }

    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression superProperty) {
        return this.withReadLock(() -> this.delegate.objectSubPropertyAxiomsForSuperProperty(superProperty));
    }

    public Stream<OWLReflexiveObjectPropertyAxiom> reflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.reflexiveObjectPropertyAxioms(property));
    }

    public Stream<OWLSameIndividualAxiom> sameIndividualAxioms(OWLIndividual individual) {
        return this.withReadLock(() -> this.delegate.sameIndividualAxioms(individual));
    }

    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSubClass(OWLClass cls) {
        return this.withReadLock(() -> this.delegate.subClassAxiomsForSubClass(cls));
    }

    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSuperClass(OWLClass cls) {
        return this.withReadLock(() -> this.delegate.subClassAxiomsForSuperClass(cls));
    }

    public Stream<OWLSymmetricObjectPropertyAxiom> symmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.symmetricObjectPropertyAxioms(property));
    }

    public Stream<OWLTransitiveObjectPropertyAxiom> transitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLock(() -> this.delegate.transitiveObjectPropertyAxioms(property));
    }

    private static interface Store {
        public void store() throws OWLOntologyStorageException;
    }
}

