/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasAnnotationPropertiesInSignature;
import org.semanticweb.owlapi.model.HasAxiomsByType;
import org.semanticweb.owlapi.model.HasDatatypesInSignature;
import org.semanticweb.owlapi.model.HasImportsClosure;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomCollection;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.Internals;
import uk.ac.manchester.cs.owl.owlapi.MapPointer;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomIndexImpl;

public class OWLImmutableOntologyImpl
extends OWLAxiomIndexImpl
implements OWLOntology,
Serializable {
    protected static LoadingCache<OWLImmutableOntologyImpl, Set<OWLEntity>> ontsignatures = OWLImmutableOntologyImpl.build(OWLImmutableOntologyImpl::build);
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLAnonymousIndividual>> ontanonCaches = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(key.ints.get(OWLAnonymousIndividual.class, OWLAxiom.class).get().keySet().distinct().sorted()));
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLClass>> ontclassesSignatures = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(key.ints.get(OWLClass.class, OWLAxiom.class).get().keySet().distinct().sorted()));
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLDataProperty>> ontdataPropertySignatures = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(key.ints.get(OWLDataProperty.class, OWLAxiom.class).get().keySet().distinct().sorted()));
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLObjectProperty>> ontobjectPropertySignatures = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(key.ints.get(OWLObjectProperty.class, OWLAxiom.class).get().keySet().distinct().sorted()));
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLDatatype>> ontdatatypeSignatures = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(Stream.concat(key.ints.get(OWLDatatype.class, OWLAxiom.class).get().keySet(), key.ints.getOntologyAnnotations().flatMap(HasDatatypesInSignature::datatypesInSignature)).distinct().sorted()));
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLNamedIndividual>> ontindividualSignatures = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(key.ints.get(OWLNamedIndividual.class, OWLAxiom.class).get().keySet().distinct().sorted()));
    protected static LoadingCache<OWLImmutableOntologyImpl, List<OWLAnnotationProperty>> ontannotationPropertiesSignatures = OWLImmutableOntologyImpl.build(key -> OWLAPIStreamUtils.asList(Stream.concat(key.ints.get(OWLAnnotationProperty.class, OWLAxiom.class, Navigation.IN_SUB_POSITION).get().keySet(), key.ints.getOntologyAnnotations().flatMap(HasAnnotationPropertiesInSignature::annotationPropertiesInSignature)).distinct().sorted()));
    @Nullable
    protected OWLOntologyManager manager;
    protected OWLDataFactory df;
    protected OWLOntologyID ontologyID;

    protected static void invalidateOntologyCaches(OWLImmutableOntologyImpl o) {
        ontsignatures.invalidate((Object)o);
        ontanonCaches.invalidate((Object)o);
        ontclassesSignatures.invalidate((Object)o);
        ontdataPropertySignatures.invalidate((Object)o);
        ontobjectPropertySignatures.invalidate((Object)o);
        ontdatatypeSignatures.invalidate((Object)o);
        ontindividualSignatures.invalidate((Object)o);
        ontannotationPropertiesSignatures.invalidate((Object)o);
    }

    private static Set<OWLEntity> build(OWLImmutableOntologyImpl key) {
        Stream stream = Stream.of(key.classesInSignature(), key.objectPropertiesInSignature(), key.dataPropertiesInSignature(), key.individualsInSignature(), key.datatypesInSignature(), key.annotationPropertiesInSignature(), key.annotations().flatMap(HasSignature::signature)).flatMap(x -> x);
        return OWLAPIStreamUtils.asSet(stream.distinct().sorted());
    }

    public OWLImmutableOntologyImpl(OWLOntologyManager manager, OWLOntologyID ontologyID) {
        this.manager = (OWLOntologyManager)OWLAPIPreconditions.checkNotNull((Object)manager, (String)"manager cannot be null");
        this.ontologyID = (OWLOntologyID)OWLAPIPreconditions.checkNotNull((Object)ontologyID, (String)"ontologyID cannot be null");
        this.df = manager.getOWLDataFactory();
    }

    private static void add(Set<IRI> punned, Set<IRI> test, OWLEntity e) {
        if (!test.add(e.getIRI())) {
            punned.add(e.getIRI());
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("Ontology(").append(this.ontologyID).append(") [Axioms: ").append(this.ints.getAxiomCount()).append(" Logical Axioms: ").append(this.ints.getLogicalAxiomCount()).append("] First 20 axioms: {");
        this.ints.getAxioms().limit(20L).forEach(a -> sb.append(a).append(' '));
        sb.append('}');
        return sb.toString();
    }

    public OWLOntologyManager getOWLOntologyManager() {
        OWLOntologyManager m = this.manager;
        if (m == null) {
            throw new IllegalStateException("Manager on ontology " + String.valueOf(this.getOntologyID()) + " is null; the ontology is no longer associated to a manager. Ensure the ontology is not being used after being removed from its manager.");
        }
        return (OWLOntologyManager)OWLAPIPreconditions.verifyNotNull((Object)m, (String)"manager cannot be null at this stage");
    }

    public void setOWLOntologyManager(@Nullable OWLOntologyManager manager) {
        this.manager = manager;
    }

    public OWLOntologyID getOntologyID() {
        return this.ontologyID;
    }

    public boolean isAnonymous() {
        return this.ontologyID.isAnonymous();
    }

    public boolean isEmpty() {
        return this.ints.isEmpty();
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        return this.ints.getAxiomCount(axiomType);
    }

    public int getAxiomCount() {
        return this.ints.getAxiomCount();
    }

    public boolean containsAxiom(OWLAxiom axiom) {
        return Internals.contains(this.ints.getAxiomsByType(), axiom.getAxiomType(), axiom);
    }

    public Stream<OWLAxiom> axioms() {
        return this.ints.getAxioms();
    }

    public boolean equalAxioms(HasAxiomsByType o) {
        if (o instanceof OWLAxiomCollection) {
            OWLAxiomCollection ont = (OWLAxiomCollection)o;
            return AxiomType.AXIOM_TYPES.stream().allMatch(t -> this.getAxiomCount((AxiomType)t) == ont.getAxiomCount(t)) && AxiomType.AXIOM_TYPES.stream().allMatch(t -> this.axioms((AxiomType)t).collect(Collectors.toSet()).equals(o.axioms(t).collect(Collectors.toSet())));
        }
        return super.equalAxioms(o);
    }

    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> axiomType) {
        return this.ints.getAxiomsByType().getValues(axiomType);
    }

    public Stream<OWLLogicalAxiom> logicalAxioms() {
        return this.ints.getLogicalAxioms();
    }

    public int getLogicalAxiomCount() {
        return this.ints.getLogicalAxiomCount();
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, Imports imports) {
        return imports.stream((HasImportsClosure)this).mapToInt(o -> o.getAxiomCount(axiomType)).sum();
    }

    public int getAxiomCount(Imports imports) {
        return imports.stream((HasImportsClosure)this).mapToInt(OWLAxiomCollection::getAxiomCount).sum();
    }

    public Stream<OWLAxiom> tboxAxioms(Imports imports) {
        return AxiomType.TBoxAxiomTypes.stream().flatMap(t -> this.axioms((AxiomType)t, imports));
    }

    public Stream<OWLAxiom> aboxAxioms(Imports imports) {
        return AxiomType.ABoxAxiomTypes.stream().flatMap(t -> this.axioms((AxiomType)t, imports));
    }

    public Stream<OWLAxiom> rboxAxioms(Imports imports) {
        return AxiomType.RBoxAxiomTypes.stream().flatMap(t -> this.axioms((AxiomType)t, imports));
    }

    public int getLogicalAxiomCount(Imports imports) {
        return imports.stream((HasImportsClosure)this).mapToInt(OWLAxiomCollection::getLogicalAxiomCount).sum();
    }

    public Stream<OWLAnnotation> annotations() {
        return this.ints.getOntologyAnnotations().sorted();
    }

    public List<OWLAnnotation> annotationsAsList() {
        return OWLAPIStreamUtils.asList(this.annotations());
    }

    public Stream<OWLClassAxiom> generalClassAxioms() {
        return this.ints.getGeneralClassAxioms();
    }

    public boolean containsAxiom(OWLAxiom axiom, Imports imports, AxiomAnnotations ignoreAnnotations) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> ignoreAnnotations.contains(o, axiom));
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom axiom) {
        return this.axioms(axiom.getAxiomType()).map(x -> x).filter(ax -> ax.equalsIgnoreAnnotations(axiom));
    }

    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom) {
        if (this.containsAxiom(axiom)) {
            return true;
        }
        return this.axioms(axiom.getAxiomType()).anyMatch(ax -> ax.equalsIgnoreAnnotations(axiom));
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom axiom, Imports imports) {
        return imports.stream((HasImportsClosure)this).flatMap(o -> o.axiomsIgnoreAnnotations(axiom));
    }

    public boolean containsClassInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsClassInSignature(iri));
    }

    public boolean containsObjectPropertyInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsObjectPropertyInSignature(iri));
    }

    public boolean containsDataPropertyInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsDataPropertyInSignature(iri));
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri, Imports imports) {
        boolean result = imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsAnnotationPropertyInSignature(iri));
        if (result) {
            return result;
        }
        return this.checkOntologyAnnotations(this.df.getOWLAnnotationProperty(iri));
    }

    private boolean checkOntologyAnnotations(OWLAnnotationProperty p) {
        return this.ints.getOntologyAnnotations().anyMatch(ann -> ann.getProperty().equals((Object)p));
    }

    public boolean containsIndividualInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsIndividualInSignature(iri));
    }

    public boolean containsDatatypeInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsDatatypeInSignature(iri));
    }

    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        return this.ints.anyEntities(type);
    }

    public Stream<OWLEntity> entitiesInSignature(IRI iri) {
        return this.unsortedSignature().filter(c -> c.getIRI().equals((Object)iri)).sorted();
    }

    public Stream<OWLEntity> unsortedSignature() {
        return Stream.of(this.ints.get(OWLClass.class, OWLAxiom.class).get().keySet(), this.ints.get(OWLObjectProperty.class, OWLAxiom.class).get().keySet(), this.ints.get(OWLDataProperty.class, OWLAxiom.class).get().keySet(), this.ints.get(OWLNamedIndividual.class, OWLAxiom.class).get().keySet(), this.ints.get(OWLDatatype.class, OWLAxiom.class).get().keySet(), this.ints.get(OWLAnnotationProperty.class, OWLAxiom.class, Navigation.IN_SUB_POSITION).get().keySet(), this.ints.getOntologyAnnotations().map(OWLAnnotation::getProperty)).flatMap(Function.identity());
    }

    public Set<IRI> getPunnedIRIs(Imports includeImportsClosure) {
        HashSet<IRI> punned = new HashSet<IRI>();
        HashSet test = new HashSet();
        includeImportsClosure.stream((HasImportsClosure)this).flatMap(HasSignature::unsortedSignature).forEach(e -> OWLImmutableOntologyImpl.add(punned, test, e));
        if (punned.isEmpty()) {
            return Collections.emptySet();
        }
        return punned;
    }

    public boolean containsReference(OWLEntity entity, Imports includeImportsClosure) {
        if (includeImportsClosure == Imports.EXCLUDED) {
            return this.ints.containsReference(entity);
        }
        return this.importsClosure().anyMatch(o -> o.containsReference(entity, Imports.EXCLUDED));
    }

    public boolean isDeclared(OWLEntity owlEntity) {
        return this.ints.isDeclared(owlEntity);
    }

    @Override
    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        Set set = (Set)ontsignatures.getIfPresent((Object)this);
        if (set == null) {
            if (this.ints.containsReference(owlEntity)) {
                return true;
            }
            return this.annotations().flatMap(HasSignature::signature).anyMatch(arg_0 -> ((OWLEntity)owlEntity).equals(arg_0));
        }
        return set.contains(owlEntity);
    }

    @Override
    public Stream<OWLEntity> signature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)ontsignatures.get((Object)this)));
    }

    @Override
    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)ontanonCaches.get((Object)this)));
    }

    @Override
    public Stream<OWLClass> classesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)ontclassesSignatures.get((Object)this)));
    }

    @Override
    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)ontdataPropertySignatures.get((Object)this)));
    }

    @Override
    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)ontobjectPropertySignatures.get((Object)this)));
    }

    @Override
    public Stream<OWLNamedIndividual> individualsInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)ontindividualSignatures.get((Object)this)));
    }

    @Override
    public Stream<OWLDatatype> datatypesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)ontdatatypeSignatures.get((Object)this)));
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals() {
        return this.anonymousIndividuals();
    }

    @Override
    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return OWLAPIStreamUtils.streamFromSorted((Collection)((Collection)ontannotationPropertiesSignatures.get((Object)this)));
    }

    public Stream<OWLImportsDeclaration> importsDeclarations() {
        return this.ints.getImportsDeclarations();
    }

    public Stream<IRI> directImportsDocuments() {
        return this.ints.getImportsDeclarations().map(OWLImportsDeclaration::getIRI);
    }

    public Stream<OWLOntology> imports() {
        return this.getOWLOntologyManager().imports((OWLOntology)this);
    }

    public Stream<OWLOntology> directImports() {
        return this.getOWLOntologyManager().directImports((OWLOntology)this);
    }

    public Stream<OWLOntology> importsClosure() {
        return this.getOWLOntologyManager().importsClosure((OWLOntology)this);
    }

    public Stream<OWLClassAxiom> axioms(OWLClass cls) {
        return this.ints.get(OWLClass.class, OWLClassAxiom.class).get().values(cls, OWLClassAxiom.class);
    }

    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression property) {
        return Stream.of(this.asymmetricObjectPropertyAxioms(property), this.reflexiveObjectPropertyAxioms(property), this.symmetricObjectPropertyAxioms(property), this.irreflexiveObjectPropertyAxioms(property), this.transitiveObjectPropertyAxioms(property), this.inverseFunctionalObjectPropertyAxioms(property), this.functionalObjectPropertyAxioms(property), this.inverseObjectPropertyAxioms(property), this.objectPropertyDomainAxioms(property), this.equivalentObjectPropertiesAxioms(property), this.disjointObjectPropertiesAxioms(property), this.objectPropertyRangeAxioms(property), this.objectSubPropertyAxiomsForSubProperty(property)).flatMap(x -> x);
    }

    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty property) {
        return Stream.of(this.dataPropertyDomainAxioms(property), this.equivalentDataPropertiesAxioms(property), this.disjointDataPropertiesAxioms(property), this.dataPropertyRangeAxioms(property), this.functionalDataPropertyAxioms((OWLDataPropertyExpression)property), this.dataSubPropertyAxiomsForSubProperty(property)).flatMap(x -> x);
    }

    public Stream<OWLIndividualAxiom> axioms(OWLIndividual individual) {
        return Stream.of(this.classAssertionAxioms(individual), this.objectPropertyAssertionAxioms(individual), this.dataPropertyAssertionAxioms(individual), this.negativeObjectPropertyAssertionAxioms(individual), this.negativeDataPropertyAssertionAxioms(individual), this.sameIndividualAxioms(individual), this.differentIndividualAxioms(individual)).flatMap(x -> x);
    }

    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype datatype) {
        return this.datatypeDefinitions(datatype);
    }

    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive owlEntity) {
        if (owlEntity instanceof OWLEntity) {
            return this.ints.getReferencingAxioms((OWLEntity)owlEntity);
        }
        if (owlEntity instanceof OWLAnonymousIndividual) {
            return this.ints.get(OWLAnonymousIndividual.class, OWLAxiom.class).get().values((OWLAnonymousIndividual)owlEntity, OWLAxiom.class);
        }
        if (owlEntity.isIRI()) {
            HashSet axioms = new HashSet();
            String iriString = owlEntity.toString();
            this.entitiesInSignature((IRI)owlEntity).forEach(e -> OWLAPIStreamUtils.add((Collection)axioms, this.referencingAxioms((OWLPrimitive)e)));
            this.axioms(AxiomType.DATA_PROPERTY_ASSERTION).filter(ax -> OWL2Datatype.XSD_ANY_URI.matches((OWLEntity)((OWLLiteral)ax.getObject()).getDatatype())).filter(ax -> ((OWLLiteral)ax.getObject()).getLiteral().equals(iriString)).forEach(axioms::add);
            this.axioms(AxiomType.ANNOTATION_ASSERTION).forEach(ax -> this.examineAssertion(owlEntity, axioms, (OWLAnnotationAssertionAxiom)ax));
            this.axioms(AxiomType.ANNOTATION_PROPERTY_DOMAIN).forEach(ax -> this.examineDomain(owlEntity, axioms, (OWLAnnotationPropertyDomainAxiom)ax));
            this.axioms(AxiomType.ANNOTATION_PROPERTY_RANGE).forEach(ax -> this.examineRange(owlEntity, axioms, (OWLAnnotationPropertyRangeAxiom)ax));
            this.axioms().filter(OWLAxiom::isAnnotated).forEach(ax -> this.examineAnnotations(owlEntity, axioms, (OWLAxiom)ax));
            return axioms.stream();
        }
        if (owlEntity instanceof OWLLiteral) {
            HashSet axioms = new HashSet();
            FindLiterals v = new FindLiterals((OWLLiteral)owlEntity);
            AxiomType.AXIOM_TYPES.stream().flatMap(this::axioms).filter(ax -> (Boolean)ax.accept((OWLObjectVisitorEx)v)).forEach(axioms::add);
            return axioms.stream();
        }
        return OWLAPIStreamUtils.empty();
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLClassExpression ce) {
        if (ce.isAnonymous()) {
            this.axioms(AxiomType.CLASS_ASSERTION).filter(x -> x.getClassExpression().equals((Object)ce));
        }
        return super.classAssertionAxioms(ce);
    }

    protected void examineAssertion(OWLPrimitive owlEntity, Set<OWLAxiom> axioms, OWLAnnotationAssertionAxiom ax) {
        if (((OWLAnnotationSubject)ax.getSubject()).equals((Object)owlEntity)) {
            axioms.add((OWLAxiom)ax);
        } else if (ax.annotationValue().equals((Object)owlEntity)) {
            axioms.add((OWLAxiom)ax);
        } else {
            ax.getValue().asLiteral().ifPresent(lit -> {
                if (OWL2Datatype.XSD_ANY_URI.matches((OWLEntity)lit.getDatatype()) && lit.getLiteral().equals(owlEntity.toString())) {
                    axioms.add((OWLAxiom)ax);
                }
            });
        }
    }

    protected void examineDomain(OWLPrimitive owlEntity, Set<OWLAxiom> axioms, OWLAnnotationPropertyDomainAxiom ax) {
        if (((IRI)ax.getDomain()).equals((Object)owlEntity)) {
            axioms.add((OWLAxiom)ax);
        }
    }

    protected void examineRange(OWLPrimitive owlEntity, Set<OWLAxiom> axioms, OWLAnnotationPropertyRangeAxiom ax) {
        if (((IRI)ax.getRange()).equals((Object)owlEntity)) {
            axioms.add((OWLAxiom)ax);
        }
    }

    protected void examineAnnotations(OWLPrimitive owlEntity, Set<OWLAxiom> axioms, OWLAxiom ax) {
        if (this.recurse(ax.annotations(), arg_0 -> ((OWLPrimitive)owlEntity).equals(arg_0))) {
            axioms.add(ax);
        }
    }

    private boolean recurse(Stream<OWLAnnotation> s, Predicate<OWLAnnotationValue> p) {
        return s.anyMatch(a -> p.test(a.annotationValue()) || this.recurse(a.annotations(), p));
    }

    public <A extends OWLAxiom> Stream<A> axioms(Class<A> type, Class<? extends OWLObject> explicitClass, OWLObject entity, Navigation forSubPosition) {
        Optional<MapPointer<OWLObject, A>> optional = this.ints.get(explicitClass, type, forSubPosition);
        if (optional.isPresent()) {
            return optional.get().values((OWLObject)entity, type);
        }
        if (!(entity instanceof OWLEntity)) {
            return OWLAPIStreamUtils.empty();
        }
        return this.axioms(AxiomType.getTypeForClass(type)).filter(a -> a.containsEntityInSignature((OWLEntity)entity));
    }

    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key, Imports imports) {
        return imports.stream((HasImportsClosure)this).flatMap(o -> o.axioms(filter, key));
    }

    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key) {
        Collection<OWLAxiom> c = this.ints.filterAxioms(filter, key);
        return c.stream();
    }

    public boolean contains(OWLAxiomSearchFilter filter, Object key) {
        return this.ints.contains(filter, key);
    }

    public boolean contains(OWLAxiomSearchFilter filter, Object key, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.contains(filter, key));
    }

    public boolean containsDatatypeInSignature(IRI iri) {
        return this.ints.containsDatatypeInSignature(iri);
    }

    public boolean containsClassInSignature(IRI iri) {
        return this.ints.containsClassInSignature(iri);
    }

    public boolean containsObjectPropertyInSignature(IRI iri) {
        return this.ints.containsObjectPropertyInSignature(iri);
    }

    public boolean containsDataPropertyInSignature(IRI iri) {
        return this.ints.containsDataPropertyInSignature(iri);
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri) {
        return this.ints.containsAnnotationPropertyInSignature(iri);
    }

    public boolean containsIndividualInSignature(IRI iri) {
        return this.ints.containsIndividualInSignature(iri);
    }

    public boolean containsReference(OWLEntity entity) {
        return this.ints.containsReference(entity);
    }

    private static class FindLiterals
    implements OWLObjectVisitorEx<Boolean> {
        private final OWLLiteral value;

        public FindLiterals(OWLLiteral value) {
            this.value = value;
        }

        public <T> Boolean doDefault(T object) {
            if (object instanceof OWLObject) {
                return this.processStream(((OWLObject)object).components());
            }
            return Boolean.FALSE;
        }

        public Boolean visit(OWLAnnotation node) {
            if (node.getValue().equals((Object)this.value)) {
                return Boolean.TRUE;
            }
            return node.annotations().map(x -> (Boolean)x.accept((OWLObjectVisitorEx)this)).filter(Boolean.TRUE::equals).findAny().orElse(Boolean.FALSE);
        }

        protected Boolean processStream(Stream<?> s) {
            return s.map(o -> {
                if (o instanceof OWLObject) {
                    return (Boolean)((OWLObject)o).accept((OWLObjectVisitorEx)this);
                }
                if (o instanceof Stream) {
                    return this.processStream((Stream)o);
                }
                if (o instanceof Collection) {
                    return this.processStream(((Collection)o).stream());
                }
                return Boolean.FALSE;
            }).filter(Boolean.TRUE::equals).findAny().orElse(Boolean.FALSE);
        }

        public Boolean visit(OWLLiteral node) {
            return node.equals((Object)this.value);
        }
    }
}

