/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImpl;

public class OWLDataOneOfImpl
extends OWLObjectImpl
implements OWLDataOneOf {
    private final List<OWLLiteral> values;

    public OWLDataOneOfImpl(Stream<? extends OWLLiteral> values) {
        OWLAPIPreconditions.checkNotNull(values, (String)"values cannot be null");
        this.values = OWLAPIStreamUtils.sorted(OWLLiteral.class, values);
    }

    public OWLDataOneOfImpl(Collection<? extends OWLLiteral> values) {
        this(((Collection)OWLAPIPreconditions.checkNotNull(values, (String)"values cannot be null")).stream());
    }

    public OWLDataOneOfImpl(OWLLiteral value) {
        OWLAPIPreconditions.checkNotNull((Object)value, (String)"value cannot be null");
        this.values = Collections.singletonList(value);
    }

    public Stream<OWLLiteral> values() {
        return OWLAPIStreamUtils.streamFromSorted(this.values);
    }

    public Stream<OWLLiteral> operands() {
        return this.values();
    }

    public List<OWLLiteral> getOperandsAsList() {
        return this.values;
    }
}

