/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.maps.ObjectObjectHashMap;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import org.semanticweb.owlapi.util.SmallSet;
import uk.ac.manchester.cs.owl.owlapi.HPPCSet;
import uk.ac.manchester.cs.owl.owlapi.InitVisitorFactory;
import uk.ac.manchester.cs.owl.owlapi.Internals;

public class MapPointer<K, V extends OWLAxiom> {
    @Nullable
    private final AxiomType<?> type;
    @Nullable
    private final OWLAxiomVisitorEx<?> visitor;
    private boolean initialized;
    protected final Internals i;
    @Nullable
    private SoftReference<Set<IRI>> iris;
    private int size = 0;
    private final ObjectObjectHashMap<K, Collection<V>> map = new ObjectObjectHashMap(17, 0.75);
    private final Class<V> valueWithness;

    public MapPointer(@Nullable AxiomType<?> t, @Nullable OWLAxiomVisitorEx<?> v, boolean initialized, Internals i, Class<V> valueWithness) {
        this.type = t;
        this.visitor = v;
        this.initialized = initialized;
        this.i = (Internals)OWLAPIPreconditions.checkNotNull((Object)i, (String)"i cannot be null");
        this.valueWithness = valueWithness;
    }

    public void forEach(BiConsumer<K, V> consumer) {
        this.keySet().forEach((? super T k) -> this.forEach(k, v -> consumer.accept(k, v)));
    }

    public synchronized boolean containsReference(K e) {
        return this.map.containsKey(e);
    }

    public synchronized boolean containsReference(IRI e) {
        Set<IRI> set = null;
        if (this.iris != null) {
            set = this.iris.get();
        }
        if (set == null) {
            set = this.initSet();
        }
        return set.contains(e);
    }

    private Set<IRI> initSet() {
        Set set = CollectionFactory.createSet();
        ObjectProcedure consumer = k -> this.consumer(set, k);
        this.map.keys().forEach(consumer);
        this.iris = new SoftReference<Set>(set);
        return set;
    }

    protected void consumer(Set<IRI> set, K k) {
        if (k instanceof HasIRI) {
            set.add(((HasIRI)k).getIRI());
        } else if (k instanceof IRI) {
            set.add((IRI)k);
        }
    }

    public synchronized boolean isInitialized() {
        return this.initialized;
    }

    public synchronized MapPointer<K, V> init() {
        if (this.initialized) {
            return this;
        }
        this.initialized = true;
        if (this.visitor == null || this.type == null) {
            return this;
        }
        AxiomType<?> t = this.type;
        assert (t != null);
        if (this.visitor instanceof InitVisitorFactory.InitVisitor) {
            InitVisitorFactory.InitVisitor v = (InitVisitorFactory.InitVisitor)this.visitor;
            this.i.getAxiomsByType().forEach(t, ax -> this.putInternal(ax.accept((OWLAxiomVisitorEx)v), ax));
        } else if (this.visitor instanceof InitVisitorFactory.InitCollectionVisitor) {
            InitVisitorFactory.InitCollectionVisitor v = (InitVisitorFactory.InitCollectionVisitor)this.visitor;
            this.i.getAxiomsByType().forEach(t, ax -> ((Stream)ax.accept((OWLAxiomVisitorEx)v)).forEach((? super T key) -> this.putInternal(key, ax)));
        }
        return this;
    }

    public synchronized String toString() {
        return this.initialized + this.map.toString();
    }

    public synchronized Stream<K> keySet() {
        this.init();
        ArrayList l = new ArrayList();
        Consumer<ObjectCursor> p = c -> l.add(c.value);
        this.map.keys().forEach(p);
        return l.stream();
    }

    public synchronized Stream<V> getValues(K key) {
        this.init();
        Collection t = (Collection)this.map.get(key);
        if (t == null) {
            return Stream.empty();
        }
        if (t instanceof SmallSet) {
            return t.stream();
        }
        if (t instanceof HPPCSet) {
            return new ArrayList(t).stream();
        }
        return t.stream();
    }

    public synchronized void forEach(K key, Consumer<V> function) {
        this.init();
        this.get(key).forEach(function);
    }

    public synchronized boolean matchOnValues(K key, Predicate<V> function) {
        this.init();
        return this.get(key).anyMatch(function);
    }

    public synchronized Collection<V> getValuesAsCollection(K key) {
        this.init();
        Collection t = (Collection)this.map.get(key);
        if (t == null) {
            return Collections.emptyList();
        }
        if (t instanceof SmallSet) {
            return new ArrayList(t);
        }
        if (t instanceof HPPCSet) {
            return new ArrayList(t);
        }
        return t;
    }

    public synchronized int countValues(K key) {
        this.init();
        return this.count(key);
    }

    private int count(K k) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return 0;
        }
        return t.size();
    }

    public synchronized <O extends V> Stream<O> values(K key, Class<O> classType) {
        this.init();
        Collection t = (Collection)this.map.get(key);
        if (t == null) {
            return Stream.empty();
        }
        if (t instanceof SmallSet) {
            return t.stream();
        }
        if (t instanceof HPPCSet) {
            return new ArrayList(t).stream();
        }
        return t.stream();
    }

    public synchronized <T> Collection<OWLAxiom> filterAxioms(OWLAxiomSearchFilter filter, T key) {
        this.init();
        ArrayList<OWLAxiom> toReturn = new ArrayList<OWLAxiom>();
        for (AxiomType at : filter.getAxiomTypes()) {
            Collection collection = (Collection)this.map.get((Object)at);
            if (collection == null) continue;
            collection.stream().filter(x -> filter.pass(x, key)).forEach(toReturn::add);
        }
        return toReturn;
    }

    public synchronized boolean put(K key, V value) {
        if (!this.initialized) {
            return false;
        }
        this.iris = null;
        return this.putInternal(key, value);
    }

    public synchronized boolean remove(K key, V value) {
        if (!this.initialized) {
            return false;
        }
        this.iris = null;
        return this.removeInternal(key, value);
    }

    public synchronized boolean containsKey(K key) {
        this.init();
        return this.map.containsKey(key);
    }

    public synchronized boolean contains(K key, V value) {
        this.init();
        return this.containsEntry(key, value);
    }

    public synchronized Stream<V> getAllValues() {
        this.init();
        return this.values();
    }

    public synchronized int size() {
        this.init();
        return this.size;
    }

    public synchronized boolean isEmpty() {
        this.init();
        return this.size == 0;
    }

    private boolean putInternal(@Nullable K k, V v) {
        if (k == null) {
            return false;
        }
        Object set = (SmallSet)this.map.get(k);
        if (set == null) {
            set = Collections.singleton(v);
            this.map.put(k, set);
            ++this.size;
            return true;
        }
        if (set.size() == 1) {
            if (set.contains(v)) {
                return false;
            }
            set = new SmallSet(set);
            this.map.put(k, set);
        } else if (set.size() == 3) {
            if (set.contains(v)) {
                return false;
            }
            set = new HPPCSet<V>(set, v, this.valueWithness);
            this.map.put(k, set);
            ++this.size;
            return true;
        }
        boolean added = set.add(v);
        if (added) {
            ++this.size;
        }
        return added;
    }

    private boolean containsEntry(K k, V v) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return false;
        }
        return t.contains(v);
    }

    private boolean removeInternal(K k, V v) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return false;
        }
        if (t.size() == 1) {
            if (t.contains(v)) {
                this.map.remove(k);
                --this.size;
                return true;
            }
            return false;
        }
        boolean removed = t.remove(v);
        if (removed) {
            --this.size;
        }
        if (t.isEmpty()) {
            this.map.remove(k);
        }
        return removed;
    }

    private Stream<V> values() {
        ArrayList l = new ArrayList();
        Consumer<ObjectCursor> c = q -> l.addAll((Collection)q.value);
        this.map.values().forEach(c);
        return l.stream();
    }

    private Stream<V> get(K k) {
        Collection t = (Collection)this.map.get(k);
        if (t == null) {
            return Stream.empty();
        }
        return t.stream();
    }
}

