/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.ontology.impl;

import it.unibz.inf.ontop.model.vocabulary.OWL;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.impl.DataPropertyExpressionImpl;
import it.unibz.inf.ontop.spec.ontology.impl.ObjectSomeValuesFromImpl;
import org.apache.commons.rdf.api.IRI;

public class ObjectPropertyExpressionImpl
implements ObjectPropertyExpression {
    private final boolean isInverse;
    private final IRI iri;
    private final String string;
    private final ObjectPropertyExpressionImpl inverseProperty;
    private final ObjectSomeValuesFromImpl domain;
    private final boolean isTop;
    private final boolean isBottom;
    static final ObjectPropertyExpression owlTopObjectProperty = new ObjectPropertyExpressionImpl(OWL.TOP_OBJECT_PROPERTY);
    static final ObjectPropertyExpression owlBottomObjectProperty = new ObjectPropertyExpressionImpl(OWL.BOTTOM_OBJECT_PROPERTY);

    ObjectPropertyExpressionImpl(IRI iri) {
        this.iri = iri;
        this.isInverse = false;
        this.string = iri.getIRIString();
        this.isTop = iri.equals((Object)OWL.TOP_OBJECT_PROPERTY);
        this.isBottom = iri.equals((Object)OWL.BOTTOM_OBJECT_PROPERTY);
        this.inverseProperty = this.isTop || this.isBottom ? this : new ObjectPropertyExpressionImpl(iri, this);
        this.domain = new ObjectSomeValuesFromImpl(this);
    }

    private ObjectPropertyExpressionImpl(IRI iri, ObjectPropertyExpressionImpl inverseProperty) {
        this.iri = iri;
        this.isInverse = true;
        this.isTop = false;
        this.isBottom = false;
        this.inverseProperty = inverseProperty;
        this.string = iri.getIRIString() + "^-";
        this.domain = new ObjectSomeValuesFromImpl(this);
    }

    @Override
    public boolean isInverse() {
        return this.isInverse;
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public ObjectPropertyExpression getInverse() {
        return this.inverseProperty;
    }

    @Override
    public ObjectSomeValuesFrom getDomain() {
        return this.domain;
    }

    @Override
    public ObjectSomeValuesFrom getRange() {
        return this.inverseProperty.domain;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ObjectPropertyExpressionImpl) {
            ObjectPropertyExpressionImpl other = (ObjectPropertyExpressionImpl)obj;
            return this.isInverse == other.isInverse && this.iri.equals((Object)other.iri);
        }
        if (obj instanceof DataPropertyExpressionImpl) {
            DataPropertyExpressionImpl other = (DataPropertyExpressionImpl)obj;
            return !this.isInverse && this.iri.equals((Object)other.getIRI());
        }
        return false;
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public String toString() {
        return this.string;
    }

    @Override
    public boolean isBottom() {
        return this.isBottom;
    }

    @Override
    public boolean isTop() {
        return this.isTop;
    }
}

