/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.ontology.impl;

import it.unibz.inf.ontop.model.vocabulary.OWL;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.DataPropertyRangeExpression;
import it.unibz.inf.ontop.spec.ontology.DataSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.Datatype;
import it.unibz.inf.ontop.spec.ontology.impl.DataPropertyRangeExpressionImpl;
import it.unibz.inf.ontop.spec.ontology.impl.DataSomeValuesFromImpl;
import it.unibz.inf.ontop.spec.ontology.impl.DatatypeImpl;
import it.unibz.inf.ontop.spec.ontology.impl.ObjectPropertyExpressionImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.rdf.api.IRI;

public class DataPropertyExpressionImpl
implements DataPropertyExpression {
    private final IRI iri;
    private final boolean isTop;
    private final boolean isBottom;
    private final Map<Datatype, DataSomeValuesFrom> domains = new HashMap<Datatype, DataSomeValuesFrom>();
    private final DataPropertyRangeExpressionImpl range;
    public static final DataPropertyExpression owlTopDataProperty = new DataPropertyExpressionImpl(OWL.TOP_DATA_PROPERTY);
    public static final DataPropertyExpression owlBottomDataProperty = new DataPropertyExpressionImpl(OWL.BOTTOM_DATA_PROPERTY);

    DataPropertyExpressionImpl(IRI iri) {
        this.iri = iri;
        this.isTop = iri.equals((Object)OWL.TOP_DATA_PROPERTY);
        this.isBottom = iri.equals((Object)OWL.BOTTOM_DATA_PROPERTY);
        this.domains.put(DatatypeImpl.rdfsLiteral, new DataSomeValuesFromImpl(this, DatatypeImpl.rdfsLiteral));
        this.range = new DataPropertyRangeExpressionImpl(this);
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    @Override
    public DataSomeValuesFrom getDomainRestriction(Datatype datatype) {
        DataSomeValuesFrom domain = this.domains.get(datatype);
        if (domain == null) {
            domain = new DataSomeValuesFromImpl(this, datatype);
            this.domains.put(datatype, domain);
        }
        return domain;
    }

    @Override
    public Collection<DataSomeValuesFrom> getAllDomainRestrictions() {
        return this.domains.values();
    }

    @Override
    public DataPropertyRangeExpression getRange() {
        return this.range;
    }

    @Override
    public boolean isBottom() {
        return this.isBottom;
    }

    @Override
    public boolean isTop() {
        return this.isTop;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DataPropertyExpressionImpl) {
            DataPropertyExpressionImpl other = (DataPropertyExpressionImpl)obj;
            return this.iri.equals((Object)other.iri);
        }
        if (obj instanceof ObjectPropertyExpressionImpl) {
            ObjectPropertyExpressionImpl other = (ObjectPropertyExpressionImpl)obj;
            return !other.isInverse() && this.iri.equals((Object)other.getIRI());
        }
        return false;
    }

    public int hashCode() {
        return this.iri.hashCode();
    }

    public String toString() {
        return this.iri.getIRIString();
    }
}

