/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.ontology.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.spec.ontology.AnnotationProperty;
import it.unibz.inf.ontop.spec.ontology.BinaryAxiom;
import it.unibz.inf.ontop.spec.ontology.ClassExpression;
import it.unibz.inf.ontop.spec.ontology.ClassifiedTBox;
import it.unibz.inf.ontop.spec.ontology.DataPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.DataPropertyRangeExpression;
import it.unibz.inf.ontop.spec.ontology.DataRangeExpression;
import it.unibz.inf.ontop.spec.ontology.DataSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.Datatype;
import it.unibz.inf.ontop.spec.ontology.DescriptionBT;
import it.unibz.inf.ontop.spec.ontology.Equivalences;
import it.unibz.inf.ontop.spec.ontology.EquivalencesDAG;
import it.unibz.inf.ontop.spec.ontology.NaryAxiom;
import it.unibz.inf.ontop.spec.ontology.OClass;
import it.unibz.inf.ontop.spec.ontology.ObjectPropertyExpression;
import it.unibz.inf.ontop.spec.ontology.ObjectSomeValuesFrom;
import it.unibz.inf.ontop.spec.ontology.OntologyVocabularyCategory;
import it.unibz.inf.ontop.spec.ontology.impl.DatatypeImpl;
import it.unibz.inf.ontop.spec.ontology.impl.EquivalencesDAGImpl;
import it.unibz.inf.ontop.spec.ontology.impl.OntologyImpl;
import java.util.Collections;
import java.util.Comparator;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class ClassifiedTBoxImpl
implements ClassifiedTBox {
    private final OntologyVocabularyCategory<ObjectPropertyExpression> objectProperties;
    private final OntologyVocabularyCategory<DataPropertyExpression> dataProperties;
    private final OntologyVocabularyCategory<OClass> classes;
    private final OntologyVocabularyCategory<AnnotationProperty> annotationProperties;
    private final EquivalencesDAGImpl<ClassExpression> classDAG;
    private final EquivalencesDAGImpl<ObjectPropertyExpression> objectPropertyDAG;
    private final EquivalencesDAGImpl<DataPropertyExpression> dataPropertyDAG;
    private final EquivalencesDAGImpl<DataRangeExpression> dataRangeDAG;
    private final ImmutableList<NaryAxiom<ClassExpression>> classDisjointness;
    private final ImmutableList<NaryAxiom<ObjectPropertyExpression>> objectPropertyDisjointness;
    private final ImmutableList<NaryAxiom<DataPropertyExpression>> dataPropertyDisjointness;
    private final ImmutableSet<ObjectPropertyExpression> reflexiveObjectProperties;
    private final ImmutableSet<ObjectPropertyExpression> irreflexiveObjectProperties;
    private final ImmutableSet<ObjectPropertyExpression> functionalObjectProperties;
    private final ImmutableSet<DataPropertyExpression> functionalDataProperties;
    private static final Comparator<DataPropertyExpression> dataPropertyComparator = Comparator.comparing(o -> o.getIRI().getIRIString());
    private static final Comparator<ObjectPropertyExpression> objectPropertyComparator = (o1, o2) -> {
        int compared = o1.getIRI().getIRIString().compareTo(o2.getIRI().getIRIString());
        if (compared == 0) {
            if (o1.isInverse() == o2.isInverse()) {
                return 0;
            }
            if (o2.isInverse()) {
                return -1;
            }
            return 1;
        }
        return compared;
    };
    private static final Comparator<OClass> classComparator = Comparator.comparing(o -> o.getIRI().getIRIString());
    private static final Comparator<Datatype> datatypeComparator = Comparator.comparing(o -> o.getIRI().getIRIString());

    static ClassifiedTBox classify(OntologyImpl.UnclassifiedOntologyTBox onto) {
        DefaultDirectedGraph<ObjectPropertyExpression, DefaultEdge> objectPropertyGraph = ClassifiedTBoxImpl.getObjectPropertyGraph(onto);
        EquivalencesDAGImpl<ObjectPropertyExpression> objectPropertyDAG = EquivalencesDAGImpl.getEquivalencesDAG(objectPropertyGraph);
        DefaultDirectedGraph<DataPropertyExpression, DefaultEdge> dataPropertyGraph = ClassifiedTBoxImpl.getDataPropertyGraph(onto);
        EquivalencesDAGImpl<DataPropertyExpression> dataPropertyDAG = EquivalencesDAGImpl.getEquivalencesDAG(dataPropertyGraph);
        EquivalencesDAGImpl<ClassExpression> classDAG = EquivalencesDAGImpl.getEquivalencesDAG(ClassifiedTBoxImpl.getClassGraph(onto, objectPropertyGraph, dataPropertyGraph));
        EquivalencesDAGImpl<DataRangeExpression> dataRangeDAG = EquivalencesDAGImpl.getEquivalencesDAG(ClassifiedTBoxImpl.getDataRangeGraph(onto, dataPropertyGraph));
        ClassifiedTBoxImpl.chooseObjectPropertyRepresentatives(objectPropertyDAG);
        ClassifiedTBoxImpl.chooseDataPropertyRepresentatives(dataPropertyDAG);
        ClassifiedTBoxImpl.chooseClassRepresentatives(classDAG, objectPropertyDAG, dataPropertyDAG);
        ClassifiedTBoxImpl.chooseDataRangeRepresentatives(dataRangeDAG, dataPropertyDAG);
        return new ClassifiedTBoxImpl(onto.classes(), onto.objectProperties(), onto.dataProperties(), onto.annotationProperties(), classDAG, objectPropertyDAG, dataPropertyDAG, dataRangeDAG, onto.getDisjointClassesAxioms(), onto.getDisjointObjectPropertiesAxioms(), onto.getDisjointDataPropertiesAxioms(), onto.getReflexiveObjectPropertyAxioms(), onto.getIrreflexiveObjectPropertyAxioms(), onto.getFunctionalObjectProperties(), onto.getFunctionalDataProperties());
    }

    private ClassifiedTBoxImpl(OntologyVocabularyCategory<OClass> classes, OntologyVocabularyCategory<ObjectPropertyExpression> objectProperties, OntologyVocabularyCategory<DataPropertyExpression> dataProperties, OntologyVocabularyCategory<AnnotationProperty> annotationProperties, EquivalencesDAGImpl<ClassExpression> classDAG, EquivalencesDAGImpl<ObjectPropertyExpression> objectPropertyDAG, EquivalencesDAGImpl<DataPropertyExpression> dataPropertyDAG, EquivalencesDAGImpl<DataRangeExpression> dataRangeDAG, ImmutableList<NaryAxiom<ClassExpression>> classDisjointness, ImmutableList<NaryAxiom<ObjectPropertyExpression>> objectPropertyDisjointness, ImmutableList<NaryAxiom<DataPropertyExpression>> dataPropertyDisjointness, ImmutableSet<ObjectPropertyExpression> reflexiveObjectProperties, ImmutableSet<ObjectPropertyExpression> irreflexiveObjectProperties, ImmutableSet<ObjectPropertyExpression> functionalObjectProperties, ImmutableSet<DataPropertyExpression> functionalDataProperties) {
        this.classes = classes;
        this.objectProperties = objectProperties;
        this.dataProperties = dataProperties;
        this.annotationProperties = annotationProperties;
        this.classDAG = classDAG;
        this.objectPropertyDAG = objectPropertyDAG;
        this.dataPropertyDAG = dataPropertyDAG;
        this.dataRangeDAG = dataRangeDAG;
        this.classDisjointness = classDisjointness;
        this.objectPropertyDisjointness = objectPropertyDisjointness;
        this.dataPropertyDisjointness = dataPropertyDisjointness;
        this.reflexiveObjectProperties = reflexiveObjectProperties;
        this.irreflexiveObjectProperties = irreflexiveObjectProperties;
        this.functionalObjectProperties = functionalObjectProperties;
        this.functionalDataProperties = functionalDataProperties;
    }

    public String toString() {
        return this.objectPropertyDAG.toString() + "\n" + this.dataPropertyDAG.toString() + "\n" + this.classDAG.toString();
    }

    @Override
    public OntologyVocabularyCategory<ObjectPropertyExpression> objectProperties() {
        return this.objectProperties;
    }

    @Override
    public EquivalencesDAG<ObjectPropertyExpression> objectPropertiesDAG() {
        return this.objectPropertyDAG;
    }

    @Override
    public OntologyVocabularyCategory<DataPropertyExpression> dataProperties() {
        return this.dataProperties;
    }

    @Override
    public EquivalencesDAG<DataPropertyExpression> dataPropertiesDAG() {
        return this.dataPropertyDAG;
    }

    @Override
    public OntologyVocabularyCategory<OClass> classes() {
        return this.classes;
    }

    @Override
    public EquivalencesDAG<ClassExpression> classesDAG() {
        return this.classDAG;
    }

    @Override
    public EquivalencesDAG<DataRangeExpression> dataRangesDAG() {
        return this.dataRangeDAG;
    }

    @Override
    public ImmutableSet<ObjectPropertyExpression> functionalObjectProperties() {
        return this.functionalObjectProperties;
    }

    @Override
    public ImmutableSet<DataPropertyExpression> functionalDataProperties() {
        return this.functionalDataProperties;
    }

    @Override
    public ImmutableList<NaryAxiom<ClassExpression>> disjointClasses() {
        return this.classDisjointness;
    }

    @Override
    public ImmutableList<NaryAxiom<ObjectPropertyExpression>> disjointObjectProperties() {
        return this.objectPropertyDisjointness;
    }

    @Override
    public ImmutableList<NaryAxiom<DataPropertyExpression>> disjointDataProperties() {
        return this.dataPropertyDisjointness;
    }

    @Override
    public ImmutableSet<ObjectPropertyExpression> reflexiveObjectProperties() {
        return this.reflexiveObjectProperties;
    }

    @Override
    public ImmutableSet<ObjectPropertyExpression> irreflexiveObjectProperties() {
        return this.irreflexiveObjectProperties;
    }

    @Deprecated
    public DefaultDirectedGraph<ClassExpression, DefaultEdge> getClassGraph() {
        return this.classDAG.getGraph();
    }

    @Deprecated
    public DefaultDirectedGraph<DataRangeExpression, DefaultEdge> getDataRangeGraph() {
        return this.dataRangeDAG.getGraph();
    }

    @Deprecated
    public DefaultDirectedGraph<ObjectPropertyExpression, DefaultEdge> getObjectPropertyGraph() {
        return this.objectPropertyDAG.getGraph();
    }

    @Deprecated
    public DefaultDirectedGraph<DataPropertyExpression, DefaultEdge> getDataPropertyGraph() {
        return this.dataPropertyDAG.getGraph();
    }

    @Deprecated
    public int edgeSetSize() {
        return this.objectPropertyDAG.edgeSetSize() + this.dataPropertyDAG.edgeSetSize() + this.classDAG.edgeSetSize();
    }

    @Deprecated
    public int vertexSetSize() {
        return this.objectPropertyDAG.vertexSetSize() + this.dataPropertyDAG.vertexSetSize() + this.classDAG.vertexSetSize();
    }

    private static void chooseObjectPropertyRepresentatives(EquivalencesDAG<ObjectPropertyExpression> dag) {
        for (Equivalences equivalences : dag) {
            if (equivalences.getRepresentative() != null) continue;
            ObjectPropertyExpression rep = Collections.min(equivalences.getMembers(), objectPropertyComparator);
            ObjectPropertyExpression repInv = rep.getInverse();
            Equivalences<ObjectPropertyExpression> setInv = dag.getVertex(repInv);
            if (rep.isInverse()) {
                repInv = Collections.min(setInv.getMembers(), objectPropertyComparator);
                rep = repInv.getInverse();
                setInv.setIndexed();
            } else {
                equivalences.setIndexed();
            }
            equivalences.setRepresentative(rep);
            if (equivalences.contains(repInv)) continue;
            setInv.setRepresentative(repInv);
        }
    }

    private static void chooseDataPropertyRepresentatives(EquivalencesDAG<DataPropertyExpression> dag) {
        for (Equivalences equivalences : dag) {
            if (equivalences.getRepresentative() != null) continue;
            DataPropertyExpression rep = Collections.min(equivalences.getMembers(), dataPropertyComparator);
            equivalences.setIndexed();
            equivalences.setRepresentative(rep);
        }
    }

    private static void chooseClassRepresentatives(EquivalencesDAG<ClassExpression> dag, EquivalencesDAG<ObjectPropertyExpression> objectPropertyDAG, EquivalencesDAG<DataPropertyExpression> dataPropertyDAG) {
        for (Equivalences equivalences : dag) {
            ClassExpression representative;
            if (equivalences.size() <= 1) {
                representative = (ClassExpression)equivalences.iterator().next();
            } else {
                OClass namedRepresentative = null;
                for (ClassExpression e : equivalences) {
                    if (!(e instanceof OClass) || namedRepresentative != null && classComparator.compare((OClass)e, namedRepresentative) >= 0) continue;
                    namedRepresentative = (OClass)e;
                }
                if (namedRepresentative == null) {
                    DescriptionBT propRep;
                    DescriptionBT prop;
                    ClassExpression firstp;
                    ClassExpression first = (ClassExpression)equivalences.iterator().next();
                    if (first instanceof ObjectSomeValuesFrom) {
                        firstp = (ObjectSomeValuesFrom)first;
                        prop = firstp.getProperty();
                        propRep = objectPropertyDAG.getVertex((ObjectPropertyExpression)prop).getRepresentative();
                        representative = propRep.getDomain();
                    } else {
                        assert (first instanceof DataSomeValuesFrom);
                        firstp = (DataSomeValuesFrom)first;
                        prop = firstp.getProperty();
                        propRep = dataPropertyDAG.getVertex((DataPropertyExpression)prop).getRepresentative();
                        representative = propRep.getDomainRestriction(DatatypeImpl.rdfsLiteral);
                    }
                } else {
                    representative = namedRepresentative;
                }
            }
            equivalences.setRepresentative(representative);
            if (!(representative instanceof OClass)) continue;
            equivalences.setIndexed();
        }
    }

    private static void chooseDataRangeRepresentatives(EquivalencesDAG<DataRangeExpression> dag, EquivalencesDAG<DataPropertyExpression> dataPropertyDAG) {
        for (Equivalences equivalences : dag) {
            DataRangeExpression representative;
            if (equivalences.size() <= 1) {
                representative = (DataRangeExpression)equivalences.iterator().next();
            } else {
                Datatype namedRepresentative = null;
                for (DataRangeExpression e : equivalences) {
                    if (!(e instanceof Datatype) || namedRepresentative != null && datatypeComparator.compare((Datatype)e, namedRepresentative) >= 0) continue;
                    namedRepresentative = (Datatype)e;
                }
                if (namedRepresentative == null) {
                    DataRangeExpression first = (DataRangeExpression)equivalences.iterator().next();
                    assert (first instanceof DataPropertyRangeExpression);
                    DataPropertyRangeExpression firstp = (DataPropertyRangeExpression)first;
                    DataPropertyExpression prop = firstp.getProperty();
                    Equivalences<DataPropertyExpression> vertex = dataPropertyDAG.getVertex(prop);
                    if (vertex == null) {
                        throw new IllegalStateException("Unknown data property: " + prop);
                    }
                    DataPropertyExpression propRep = vertex.getRepresentative();
                    representative = propRep.getRange();
                } else {
                    representative = namedRepresentative;
                }
            }
            equivalences.setRepresentative(representative);
            if (!(representative instanceof OClass)) continue;
            equivalences.setIndexed();
        }
    }

    private static DefaultDirectedGraph<ObjectPropertyExpression, DefaultEdge> getObjectPropertyGraph(OntologyImpl.UnclassifiedOntologyTBox ontology) {
        DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
        for (ObjectPropertyExpression role : ontology.objectProperties()) {
            if (role.isBottom() || role.isTop()) continue;
            graph.addVertex((Object)role);
            graph.addVertex((Object)role.getInverse());
        }
        for (ObjectPropertyExpression role : ontology.getAuxiliaryObjectProperties()) {
            graph.addVertex((Object)role);
            graph.addVertex((Object)role.getInverse());
        }
        ObjectPropertyExpression top = null;
        for (BinaryAxiom roleIncl : ontology.getSubObjectPropertyAxioms()) {
            if (((ObjectPropertyExpression)roleIncl.getSub()).isBottom() || ((ObjectPropertyExpression)roleIncl.getSuper()).isTop()) continue;
            if (((ObjectPropertyExpression)roleIncl.getSuper()).isBottom()) {
                throw new RuntimeException("BOT cannot occur on the LHS - replaced by DISJ");
            }
            if (((ObjectPropertyExpression)roleIncl.getSub()).isTop()) {
                top = (ObjectPropertyExpression)roleIncl.getSub();
                graph.addVertex((Object)top);
            }
            graph.addEdge((Object)((ObjectPropertyExpression)roleIncl.getSub()), (Object)((ObjectPropertyExpression)roleIncl.getSuper()));
            graph.addEdge((Object)((ObjectPropertyExpression)roleIncl.getSub()).getInverse(), (Object)((ObjectPropertyExpression)roleIncl.getSuper()).getInverse());
        }
        if (top != null) {
            for (ObjectPropertyExpression ope : graph.vertexSet()) {
                graph.addEdge((Object)ope, top);
            }
        }
        return graph;
    }

    private static DefaultDirectedGraph<DataPropertyExpression, DefaultEdge> getDataPropertyGraph(OntologyImpl.UnclassifiedOntologyTBox ontology) {
        DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
        for (DataPropertyExpression role : ontology.dataProperties()) {
            if (role.isBottom() || role.isTop()) continue;
            graph.addVertex((Object)role);
        }
        DataPropertyExpression top = null;
        for (BinaryAxiom roleIncl : ontology.getSubDataPropertyAxioms()) {
            if (((DataPropertyExpression)roleIncl.getSub()).isBottom() || ((DataPropertyExpression)roleIncl.getSuper()).isTop()) continue;
            if (((DataPropertyExpression)roleIncl.getSuper()).isBottom()) {
                throw new RuntimeException("BOT cannot occur on the LHS - replaced by DISJ");
            }
            if (((DataPropertyExpression)roleIncl.getSub()).isTop()) {
                top = (DataPropertyExpression)roleIncl.getSub();
                graph.addVertex((Object)top);
            }
            graph.addEdge((Object)((DataPropertyExpression)roleIncl.getSub()), (Object)((DataPropertyExpression)roleIncl.getSuper()));
        }
        if (top != null) {
            for (DataPropertyExpression dpe : graph.vertexSet()) {
                graph.addEdge((Object)dpe, top);
            }
        }
        return graph;
    }

    private static DefaultDirectedGraph<ClassExpression, DefaultEdge> getClassGraph(OntologyImpl.UnclassifiedOntologyTBox ontology, DefaultDirectedGraph<ObjectPropertyExpression, DefaultEdge> objectPropertyGraph, DefaultDirectedGraph<DataPropertyExpression, DefaultEdge> dataPropertyGraph) {
        DescriptionBT parent;
        Object child;
        DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
        for (OClass concept : ontology.classes()) {
            if (concept.isBottom() || concept.isTop()) continue;
            graph.addVertex((Object)concept);
        }
        for (DescriptionBT role : objectPropertyGraph.vertexSet()) {
            graph.addVertex((Object)role.getDomain());
        }
        for (DefaultEdge edge : objectPropertyGraph.edgeSet()) {
            child = (ObjectPropertyExpression)objectPropertyGraph.getEdgeSource((Object)edge);
            parent = (ObjectPropertyExpression)objectPropertyGraph.getEdgeTarget((Object)edge);
            graph.addEdge((Object)child.getDomain(), (Object)parent.getDomain());
        }
        for (DescriptionBT role : dataPropertyGraph.vertexSet()) {
            for (DataSomeValuesFrom dom : role.getAllDomainRestrictions()) {
                graph.addVertex((Object)dom);
            }
        }
        for (DefaultEdge edge : dataPropertyGraph.edgeSet()) {
            child = (DataPropertyExpression)dataPropertyGraph.getEdgeSource((Object)edge);
            parent = (DataPropertyExpression)dataPropertyGraph.getEdgeTarget((Object)edge);
            graph.addEdge((Object)child.getDomainRestriction(DatatypeImpl.rdfsLiteral), (Object)parent.getDomainRestriction(DatatypeImpl.rdfsLiteral));
        }
        ClassExpression top = null;
        for (BinaryAxiom clsIncl : ontology.getSubClassAxioms()) {
            if (((ClassExpression)clsIncl.getSub()).isBottom() || ((ClassExpression)clsIncl.getSuper()).isTop()) continue;
            if (((ClassExpression)clsIncl.getSuper()).isBottom()) {
                throw new RuntimeException("BOT cannot occur on the LHS - replaced by DISJ");
            }
            if (((ClassExpression)clsIncl.getSub()).isTop()) {
                top = (ClassExpression)clsIncl.getSub();
                graph.addVertex((Object)top);
            }
            graph.addEdge((Object)((ClassExpression)clsIncl.getSub()), (Object)((ClassExpression)clsIncl.getSuper()));
        }
        if (top != null) {
            for (ClassExpression c : graph.vertexSet()) {
                graph.addEdge((Object)c, top);
            }
        }
        return graph;
    }

    private static DefaultDirectedGraph<DataRangeExpression, DefaultEdge> getDataRangeGraph(OntologyImpl.UnclassifiedOntologyTBox ontology, DefaultDirectedGraph<DataPropertyExpression, DefaultEdge> dataPropertyGraph) {
        DefaultDirectedGraph dataRangeGraph = new DefaultDirectedGraph(DefaultEdge.class);
        for (DataPropertyExpression role : dataPropertyGraph.vertexSet()) {
            dataRangeGraph.addVertex((Object)role.getRange());
        }
        for (DefaultEdge edge : dataPropertyGraph.edgeSet()) {
            DataPropertyExpression child = (DataPropertyExpression)dataPropertyGraph.getEdgeSource((Object)edge);
            DataPropertyExpression parent = (DataPropertyExpression)dataPropertyGraph.getEdgeTarget((Object)edge);
            dataRangeGraph.addEdge((Object)child.getRange(), (Object)parent.getRange());
        }
        for (BinaryAxiom clsIncl : ontology.getSubDataRangeAxioms()) {
            dataRangeGraph.addVertex((Object)((DataRangeExpression)clsIncl.getSuper()));
            dataRangeGraph.addEdge((Object)((DataRangeExpression)clsIncl.getSub()), (Object)((DataRangeExpression)clsIncl.getSuper()));
        }
        return dataRangeGraph;
    }
}

