/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.spec.mapping.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.model.atom.RDFAtomPredicate;
import it.unibz.inf.ontop.spec.mapping.Mapping;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.rdf.api.IRI;

public class MappingImpl
implements Mapping {
    private final ImmutableTable<RDFAtomPredicate, IRI, IQ> propertyDefinitions;
    private final ImmutableTable<RDFAtomPredicate, IRI, IQ> classDefinitions;

    public MappingImpl(ImmutableTable<RDFAtomPredicate, IRI, IQ> propertyTable, ImmutableTable<RDFAtomPredicate, IRI, IQ> classTable) {
        this.propertyDefinitions = propertyTable;
        this.classDefinitions = classTable;
    }

    @Override
    public Optional<IQ> getRDFPropertyDefinition(RDFAtomPredicate rdfAtomPredicate, IRI propertyIRI) {
        return Optional.ofNullable((IQ)this.propertyDefinitions.get((Object)rdfAtomPredicate, (Object)propertyIRI));
    }

    @Override
    public Optional<IQ> getRDFClassDefinition(RDFAtomPredicate rdfAtomPredicate, IRI classIRI) {
        return Optional.ofNullable((IQ)this.classDefinitions.get((Object)rdfAtomPredicate, (Object)classIRI));
    }

    @Override
    public ImmutableSet<IRI> getRDFProperties(RDFAtomPredicate rdfAtomPredicate) {
        return Optional.ofNullable((Map)this.propertyDefinitions.rowMap().get((Object)rdfAtomPredicate)).map(m -> ImmutableSet.copyOf(m.keySet())).orElseGet(ImmutableSet::of);
    }

    @Override
    public ImmutableSet<IRI> getRDFClasses(RDFAtomPredicate rdfAtomPredicate) {
        return Optional.ofNullable((Map)this.classDefinitions.rowMap().get((Object)rdfAtomPredicate)).map(m -> ImmutableSet.copyOf(m.keySet())).orElseGet(ImmutableSet::of);
    }

    @Override
    public ImmutableCollection<IQ> getQueries(RDFAtomPredicate rdfAtomPredicate) {
        return (ImmutableCollection)Stream.concat(this.classDefinitions.row((Object)rdfAtomPredicate).values().stream(), this.propertyDefinitions.row((Object)rdfAtomPredicate).values().stream()).collect(ImmutableCollectors.toList());
    }

    @Override
    public ImmutableSet<RDFAtomPredicate> getRDFAtomPredicates() {
        return Sets.union((Set)this.propertyDefinitions.rowKeySet(), (Set)this.classDefinitions.rowKeySet()).immutableCopy();
    }
}

