/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.yaml.exceptions.processing;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.MarkedYAMLException;
import org.yaml.snakeyaml.error.YAMLException;

class YamlExceptionParsingUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(YamlExceptionParsingUtil.class);

    private YamlExceptionParsingUtil() {
    }

    static String getUnexpectedChar(String excProblem) {
        return StringUtils.substringAfterLast((String)excProblem, (String)"but found ");
    }

    static String getLocationFromMark(Mark mark) {
        return mark.toString().replace("in 'string', ", "");
    }

    static String getLocation(YAMLException exception) {
        return YamlExceptionParsingUtil.getMarkLocation(exception, MarkedYAMLException::getProblemMark);
    }

    static String getContextLocation(YAMLException exception) {
        return YamlExceptionParsingUtil.getMarkLocation(exception, MarkedYAMLException::getContextMark);
    }

    private static String getMarkLocation(YAMLException exception, Function<MarkedYAMLException, Mark> markRetriever) {
        Mark mark = markRetriever.apply(YamlExceptionParsingUtil.getActualCause(exception));
        return YamlExceptionParsingUtil.getLocationFromMark(mark);
    }

    private static MarkedYAMLException getActualCause(Throwable exc) {
        if (exc.getCause() instanceof MarkedYAMLException) {
            return YamlExceptionParsingUtil.getActualCause(exc.getCause());
        }
        return (MarkedYAMLException)MarkedYAMLException.class.cast(exc);
    }

    static String extractInfo(Pattern pattern, String message) {
        Matcher matcher = pattern.matcher(message);
        return matcher.find() ? matcher.group() : "";
    }

    static String failedToProcess(YAMLException exc) {
        String message = exc.getMessage();
        LOGGER.warn("Failed to process {} message: {}", (Object)((Object)((Object)exc)).getClass().getSimpleName(), (Object)message);
        return message;
    }
}

