/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.yaml.exceptions.processing;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.yaml.exceptions.processing.YamlExceptionParsingUtil;
import com.ontotext.models.yaml.exceptions.processing.YamlExceptionProcessor;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.scanner.ScannerException;

public class ScannerExceptionProcessor
implements YamlExceptionProcessor<ScannerException> {
    private static final Pattern UNEXPECTED_IDENTATION_CHAR_MATCHER = Pattern.compile("(?<=found character )(.*)(?= that cannot start any token)");

    @Override
    public Class<ScannerException> processes() {
        return ScannerException.class;
    }

    @Override
    public String process(ScannerException yamlException) {
        Object userMessage = null;
        String exceptionCtx = Objects.toString(yamlException.getContext(), yamlException.getProblem());
        if (exceptionCtx.contains("simple key")) {
            userMessage = this.buildMappingKeyScanningErrorMessage(yamlException);
        } else if (yamlException.getProblem().contains("sequence entries are not allowed here")) {
            userMessage = ErrorMessages.get("yaml.syntax.array.elements.not.allowed.here", YamlExceptionParsingUtil.getLocation((YAMLException)yamlException));
        } else if (exceptionCtx.contains("next token")) {
            userMessage = this.buildTokenScanningErrorMessage(yamlException);
        } else if (exceptionCtx.contains("scalar")) {
            userMessage = this.buildScalarErrorMessage(yamlException);
        } else if (exceptionCtx.contains("mapping values are not allowed")) {
            userMessage = exceptionCtx + YamlExceptionParsingUtil.getLocation((YAMLException)yamlException);
        }
        return (String)ObjectsUtil.getOrDefaultGet((Object)userMessage, () -> YamlExceptionParsingUtil.failedToProcess((YAMLException)yamlException));
    }

    private String buildMappingKeyScanningErrorMessage(ScannerException exc) {
        if (exc.getProblem().contains("expected ':'")) {
            String location = YamlExceptionParsingUtil.getLocation((YAMLException)exc);
            return ErrorMessages.get("yaml.syntax.mapping.key.scanning.expected.colon", location);
        }
        return null;
    }

    private String buildTokenScanningErrorMessage(ScannerException exc) {
        String problem = exc.getProblem();
        if (problem.contains("that cannot start any token")) {
            String character = YamlExceptionParsingUtil.extractInfo(UNEXPECTED_IDENTATION_CHAR_MATCHER, problem);
            String location = YamlExceptionParsingUtil.getLocation((YAMLException)exc);
            return ErrorMessages.get("yaml.syntax.found.wrong.identation.charachter", character, character, location);
        }
        return null;
    }

    private String buildScalarErrorMessage(ScannerException exc) {
        String exceptionCtx = exc.getContext();
        if (exceptionCtx.contains("block scalar")) {
            return ScannerExceptionProcessor.buildBlockScalarErrorMessage(exc);
        }
        if (exceptionCtx.contains("quoted scalar")) {
            return this.buildQuitedScalarErrorMessage(exc);
        }
        return null;
    }

    private static String buildBlockScalarErrorMessage(ScannerException exc) {
        String problem = exc.getProblem();
        if (problem.contains("expected a comment or a line break")) {
            return ScannerExceptionProcessor.buildUnexpectedCharMessage("yaml.syntax.scalar.scanning.expected.new.line.or.comment", exc);
        }
        if (problem.contains("expected chomping or indentation indicators")) {
            return ScannerExceptionProcessor.buildUnexpectedCharMessage("yaml.syntax.scalar.scanning.expected.chomping.or.indentation", exc);
        }
        if (problem.contains("indentation indicator in the range 1-9")) {
            return ScannerExceptionProcessor.buildUnexpectedCharMessage("yaml.syntax.scalar.scanning.expected.indentation.indicator", exc);
        }
        return null;
    }

    private static String buildUnexpectedCharMessage(String messageKey, ScannerException exc) {
        String unexpectedChar = YamlExceptionParsingUtil.getUnexpectedChar(exc.getProblem());
        String location = YamlExceptionParsingUtil.getLocation((YAMLException)exc);
        return ErrorMessages.get(messageKey, unexpectedChar, location);
    }

    private String buildQuitedScalarErrorMessage(ScannerException exc) {
        String excProblem = exc.getProblem();
        if (exc.getContext().contains("double-quoted scalar") && excProblem.contains("")) {
            String unexpectedChar = StringUtils.substringAfter((String)excProblem, (String)"unknown escape character ");
            return ErrorMessages.get("yaml.syntax.double.quoted.scalar.scanning.unexpected.escape.char", unexpectedChar, YamlExceptionParsingUtil.getLocation((YAMLException)exc));
        }
        if (excProblem.contains("unexpected end of stream")) {
            return ErrorMessages.get("yaml.syntax.quoted.scalar.scanning.unexpected.eos", YamlExceptionParsingUtil.getLocation((YAMLException)exc));
        }
        return null;
    }
}

