/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.yaml;

import com.ontotext.models.yaml.YamlParseException;
import com.ontotext.models.yaml.exceptions.processing.YamlExceptionProcessors;
import java.io.InputStream;
import java.io.Reader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlProcessor {
    private YamlExceptionProcessors exceptionProcessors = new YamlExceptionProcessors();
    private final Yaml yaml;

    YamlProcessor(Yaml yaml) {
        this.yaml = yaml;
    }

    public <T> T read(InputStream stream) throws YamlParseException {
        return (T)this.callLoader(stream, arg_0 -> ((Yaml)this.yaml).load(arg_0));
    }

    public <T> T read(Reader reader) throws YamlParseException {
        return (T)this.callLoader(reader, arg_0 -> ((Yaml)this.yaml).load(arg_0));
    }

    public <T> T read(String input) throws YamlParseException {
        return (T)this.callLoader(input, arg_0 -> ((Yaml)this.yaml).load(arg_0));
    }

    private <T, R> R callLoader(T resource, YamlLoader<T, R> loader) {
        try {
            return loader.load(resource);
        }
        catch (YAMLException yamlExc) {
            throw new YamlParseException(this.exceptionProcessors.process(yamlExc), yamlExc);
        }
    }

    @FunctionalInterface
    private static interface YamlLoader<T, R> {
        public R load(T var1) throws YAMLException;
    }
}

