/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.yaml;

import com.ontotext.models.yaml.YamlRepresentable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class YamlPrinter {
    private static final String INDENT = "  ";
    private final Configuration configuration;
    private StringBuilder builder;
    private static final Pattern WS_PATTERN = Pattern.compile("\\s");
    private static final Pattern UNESCAPED_SLASH_PATTERN = Pattern.compile("\\\\(?!\")");
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("([+\\-])?[0-9]+");

    public YamlPrinter() {
        this.configuration = Configuration.createDefault();
        this.builder = new StringBuilder(2048);
    }

    public YamlPrinter(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration, "configuration argument is required");
        this.builder = new StringBuilder(2048);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public YamlPrinter newLine() {
        this.builder.append("\n");
        return this;
    }

    private void printIndent(int level) {
        int indentLevel = this.configuration.getBaseIndentLevel() + level;
        this.builder.append(StringUtils.repeat((String)INDENT, (int)(indentLevel - 1)));
    }

    public YamlPrinter addString(String name, Object obj) {
        return this.addString(name, obj, 1);
    }

    public YamlPrinter addString(String name, Object obj, int level) {
        return this.addString(name, obj, level, object -> true);
    }

    public YamlPrinter addString(String name, Object obj, int level, Predicate<String> filter) {
        if (obj != null && (this.configuration.isFullPrintEnabled() || filter.test(name))) {
            this.printIndent(level);
            this.builder.append(this.addName(name)).append(this.getValueAsString(obj));
            this.newLine();
        }
        return this;
    }

    public YamlPrinter addField(String name, int level) {
        this.printIndent(level);
        this.builder.append(this.addName(name));
        this.newLine();
        return this;
    }

    public YamlPrinter addArray(String name, Collection<?> collection, int level) {
        return this.addArray(name, collection, level, array -> true);
    }

    public YamlPrinter addArray(String name, Collection<?> collection, int level, Predicate<String> filter) {
        if (collection != null && (this.configuration.isFullPrintEnabled() || filter.test(name))) {
            this.printIndent(level);
            this.builder.append(this.addName(name)).append("[");
            if (!collection.isEmpty()) {
                String arrayAsString = collection.stream().map(this::getValueAsString).collect(Collectors.joining(", "));
                this.builder.append(arrayAsString);
            }
            this.builder.append("]");
            this.newLine();
        }
        return this;
    }

    private String addName(String name) {
        return String.format("%s: ", name);
    }

    public YamlPrinter addYaml(YamlRepresentable obj) {
        if (obj != null) {
            this.builder.append(obj.toYaml(this.configuration));
        }
        return this;
    }

    public YamlPrinter addYaml(String field, YamlRepresentable representable) {
        if (representable != null) {
            String yaml = representable.toYaml(this.configuration);
            if (yaml.isEmpty()) {
                return this;
            }
            this.builder.append(this.addName(field));
            this.builder.append(yaml);
        }
        return this;
    }

    public YamlPrinter addYaml(String name, YamlRepresentable obj, int level) {
        if (obj != null) {
            String yaml = obj.toYaml(this.configuration);
            if (yaml.isEmpty()) {
                return this;
            }
            this.addField(name, level);
            this.printIndent(level + 1);
            this.builder.append(yaml);
        }
        return this;
    }

    public YamlPrinter addYaml(String name, YamlRepresentable obj, int level, Predicate<String> filter) {
        if (obj != null && filter.test(name)) {
            String yaml = obj.toYaml(this.configuration);
            if (yaml.isEmpty()) {
                return this;
            }
            if (level >= 0) {
                this.printIndent(level);
            }
            this.builder.append(this.addName(name));
            this.builder.append(yaml);
            this.newLine();
        }
        return this;
    }

    public <V> YamlPrinter addMap(String name, Map<String, V> map, Predicate<String> filter) {
        if (map != null && !map.isEmpty() && this.hasAnyMatchingKeys(map, filter)) {
            this.addMapPropName(name);
            this.addEntries(map, filter);
        }
        return this;
    }

    private <V> boolean hasAnyMatchingKeys(Map<String, V> map, Predicate<String> filter) {
        return this.applyFilterIfNeeded(map.keySet().stream(), filter).findAny().isPresent();
    }

    private <V> boolean hasAnyMatchingValues(Map<String, V> map, Predicate<V> filter) {
        return this.applyFilterIfNeeded(map.values().stream(), filter).findAny().isPresent();
    }

    private void addMapPropName(String name) {
        this.builder.append("\n").append(this.addName(name)).append("\n");
    }

    private <V> void addEntries(Map<String, V> map, Predicate<String> filter) {
        this.applyFilterIfNeeded(map.entrySet().stream(), entry -> filter.test((String)entry.getKey())).forEach(entry -> this.builder.append(INDENT).append(this.addName((String)entry.getKey())).append(this.getValueAsString(entry.getValue())).append("\n"));
    }

    private <V> Stream<V> applyFilterIfNeeded(Stream<V> stream, Predicate<V> filter) {
        return this.configuration.isFullPrintEnabled() ? stream : stream.filter(filter);
    }

    public static String getValueAsString(Object obj, Configuration configuration) {
        if (obj instanceof YamlRepresentable) {
            return ((YamlRepresentable)obj).toYaml(configuration);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).stream().map(item -> YamlPrinter.getValueAsString(item, configuration)).collect(Collectors.joining(", ", "[", "]"));
        }
        if (obj instanceof Map) {
            return ((Map)obj).entrySet().stream().map(entry -> (String)entry.getKey() + ": " + YamlPrinter.getValueAsString(entry.getValue(), configuration)).collect(Collectors.joining(", ", "{", "}"));
        }
        String value = Objects.toString(obj);
        if (obj instanceof String) {
            return YamlPrinter.escapeAndFormatIfRequired(value);
        }
        if (obj instanceof Number) {
            try {
                Long.parseLong(obj.toString());
            }
            catch (NumberFormatException nfe) {
                return "\"" + obj.toString() + "\"";
            }
        }
        return value;
    }

    private String getValueAsString(Object obj) {
        return YamlPrinter.getValueAsString(obj, this.configuration);
    }

    public static String escapeAndFormatIfRequired(String value) {
        Object escaped = value;
        if (((String)escaped).contains("\"") && !((String)escaped).startsWith("\"")) {
            escaped = value.replace("\"", "\\\"");
        }
        if (((String)escaped).contains("?") || ((String)escaped).contains("[") || ((String)escaped).contains("'") || !YamlPrinter.isUri((String)escaped)) {
            escaped = YamlPrinter.wrapIfMissing((String)escaped, "\"");
        }
        if (((String)escaped).startsWith("\"") && UNESCAPED_SLASH_PATTERN.matcher((CharSequence)escaped).find()) {
            escaped = UNESCAPED_SLASH_PATTERN.matcher((CharSequence)escaped).replaceAll("\\\\\\\\");
        }
        if (((String)escaped).contains("\n")) {
            escaped = ((String)escaped).replace("\n", "\\n");
        }
        if (((String)escaped).contains("\r")) {
            escaped = ((String)escaped).replace("\r", "\\r");
        }
        if (NUMERIC_PATTERN.matcher((CharSequence)escaped).matches()) {
            try {
                String copy = String.valueOf(Long.parseLong((String)escaped));
                escaped = !copy.equals(value) ? "\"" + (String)escaped + "\"" : copy;
            }
            catch (NumberFormatException nfe) {
                escaped = "\"" + (String)escaped + "\"";
            }
        }
        return escaped;
    }

    private static boolean isUri(String str) {
        int index = str.indexOf(58);
        if (index <= 0) {
            return false;
        }
        if (index + 2 < str.length() && str.substring(index + 1, index + 3).equals("//")) {
            String leading = str.substring(0, index);
            return !WS_PATTERN.matcher(leading).find();
        }
        return false;
    }

    private static String wrapIfMissing(String str, String wrapWith) {
        if (StringUtils.isEmpty((CharSequence)str) || StringUtils.isEmpty((CharSequence)wrapWith)) {
            return str;
        }
        if (str.startsWith(wrapWith) && str.endsWith(wrapWith)) {
            return str;
        }
        return StringUtils.wrap((String)str, (String)wrapWith);
    }

    public <V> YamlPrinter addMapValues(String name, Map<String, V> map, Predicate<V> filter) {
        if (map != null && !map.isEmpty() && this.hasAnyMatchingValues(map, filter)) {
            this.addMapPropName(name);
            this.applyFilterIfNeeded(map.values().stream(), filter).forEach(value -> this.builder.append(INDENT).append(this.getValueAsString(value)).append("\n"));
        }
        return this;
    }

    public <V> YamlPrinter addMapValues(Map<String, V> map, Predicate<V> filter) {
        if (map != null && !map.isEmpty() && this.hasAnyMatchingValues(map, filter)) {
            this.applyFilterIfNeeded(map.values().stream(), filter).forEach(value -> this.builder.append(this.getValueAsString(value)).append("\n"));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YamlPrinter addWithIndent(int baseIndentLevel, Consumer<YamlPrinter> block) {
        int originalIdentLevel = this.getConfiguration().getBaseIndentLevel();
        try {
            this.configuration.setBaseIndentLevel(baseIndentLevel);
            block.accept(this);
        }
        finally {
            this.configuration.setBaseIndentLevel(originalIdentLevel);
        }
        return this;
    }

    public String asString() {
        return this.builder.toString();
    }

    public YamlPrinter beginMap() {
        this.builder.append('{');
        return this;
    }

    public YamlPrinter addMapEntry(String name, Object obj, Predicate<String> filter, boolean hasMore) {
        if (obj != null && (this.configuration.isFullPrintEnabled() || filter.test(name))) {
            this.builder.append(this.addName(name)).append(this.getValueAsString(obj));
            if (hasMore) {
                this.builder.append(", ");
            }
        }
        return this;
    }

    public YamlPrinter endMap() {
        this.builder.append('}');
        return this;
    }

    public static class Configuration {
        private boolean fullPrint = false;
        private int baseIndentLevel;

        private Configuration(int baseIndentLevel) {
            this.baseIndentLevel = baseIndentLevel;
        }

        public static Configuration createDefault() {
            return new Configuration(0);
        }

        public static Configuration create(int baseIndentLevel) {
            return new Configuration(baseIndentLevel);
        }

        public boolean isFullPrintEnabled() {
            return this.fullPrint;
        }

        public Configuration enableFullPrint() {
            this.fullPrint = true;
            return this;
        }

        public Configuration disableFullPrint() {
            this.fullPrint = false;
            return this;
        }

        private void setBaseIndentLevel(int baseIndentLevel) {
            this.baseIndentLevel = baseIndentLevel;
        }

        public int getBaseIndentLevel() {
            return this.baseIndentLevel;
        }
    }
}

