/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.templates;

import com.ontotext.models.templates.PropertyRef;
import com.ontotext.models.templates.Template;
import com.ontotext.models.templates.TemplateArgs;
import com.ontotext.soaas.common.SparqlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;

public class BasicTemplate
implements Template {
    private final String name;
    private final String template;
    private List<Template> subTemplates;
    private Template parentTemplate;
    private Set<PropertyRef> extProperties;

    public BasicTemplate(String name, String template) {
        this.name = name;
        this.template = template;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String get() {
        return this.template;
    }

    @Override
    public Map<String, TemplateArgs> getKeys() {
        return Collections.emptyMap();
    }

    @Override
    public Set<PropertyRef> getExternalPropertyBindings() {
        if (this.template == null) {
            return Collections.emptySet();
        }
        if (this.extProperties == null) {
            Matcher matcher = SparqlUtil.VAR_PATTERN_WITH_PATH.matcher(this.template);
            LinkedHashSet<PropertyRef> properties = new LinkedHashSet<PropertyRef>();
            int idx = 0;
            while (matcher.find(idx)) {
                String var = matcher.group(1);
                if (!var.equals("_value") && !var.equals("_subject") && var.startsWith("_")) {
                    if (var.startsWith("_value.") || var.startsWith("_subject.")) {
                        properties.add(new PropertyRef(var));
                    } else {
                        properties.add(new PropertyRef(var.replaceFirst("^_", "")));
                    }
                }
                idx = matcher.end();
            }
            this.extProperties = properties;
        }
        return this.extProperties;
    }

    @Override
    public String apply(Object context) {
        return this.template;
    }

    @Override
    public Template getParentTemplate() {
        return this.parentTemplate;
    }

    @Override
    public void setParentTemplate(Template parentTemplate) {
        this.parentTemplate = parentTemplate;
    }

    @Override
    public List<Template> getSubTemplates() {
        if (this.subTemplates == null) {
            return Collections.emptyList();
        }
        return this.subTemplates;
    }

    @Override
    public void addSubTemplate(Template template) {
        if (template == null) {
            return;
        }
        if (this.subTemplates == null) {
            this.subTemplates = new ArrayList<Template>();
        }
        this.subTemplates.add(template);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BasicTemplate)) {
            return false;
        }
        BasicTemplate that = (BasicTemplate)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.template, that.template);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.template);
    }
}

