/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.shacl;

import com.ontotext.models.shacl.ConstraintContext;
import com.ontotext.models.shacl.ShaclConstraint;
import com.ontotext.models.shacl.ShaclNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class LangIn
implements ShaclNode {
    private List<String> value = new ArrayList<String>();

    public LangIn(ConstraintContext context) {
        Object languages = context.getConstraintValue();
        if (languages instanceof String) {
            this.value.add(this.normalizeLanguageToRdf((String)languages));
        } else if (languages instanceof Collection) {
            ArrayList<String> wrappedLangs = new ArrayList<String>();
            ((Collection)languages).forEach(singleLang -> wrappedLangs.add(this.normalizeLanguageToRdf((String)singleLang)));
            this.value = wrappedLangs;
        } else {
            throw new IllegalArgumentException(String.format("The value for this LangIn, %s, is neither a single language, nor a language list!", languages));
        }
    }

    private String normalizeLanguageToRdf(String value) {
        return StringUtils.wrapIfMissing((String)StringUtils.stripEnd((String)value, (String)"~"), (char)'\"');
    }

    @Override
    public String getName() {
        return ShaclConstraint.LANG_IN.getLocalName();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void addValues(Object values) {
        if (values instanceof String) {
            this.value.add(this.normalizeLanguageToRdf((String)values));
        } else if (values instanceof Collection) {
            ArrayList wrappedLangs = new ArrayList();
            ((Collection)values).forEach(singleLang -> wrappedLangs.add(this.normalizeLanguageToRdf((String)singleLang)));
            this.value.addAll(wrappedLangs);
        } else {
            throw new IllegalArgumentException(String.format("Trying to add the value %s to a LangIn node, but it is neither a single language, nor a language list!", values));
        }
    }

    @Override
    public String toTurtle() {
        return "sh:" + this.getName() + " " + this.value.stream().collect(Collectors.joining(" ", "(", ")")) + " ; ";
    }
}

