/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.security;

import com.ontotext.models.Constraint;
import com.ontotext.models.Constraints;
import com.ontotext.models.Shape;
import java.util.Collections;
import java.util.Set;

public class RbacResult {
    private static final RbacResult FORBIDDEN_RESULT = new RbacResult(false, Collections.emptySet());
    private static final RbacResult ALLOWED_RESULT = new RbacResult(true, Collections.emptySet());
    private static final RbacResult NOT_CALCULATED = new RbacResult(false, Collections.singleton(Constraint.DUMMY));
    private final boolean allowed;
    private final Set<Constraint> constraints;

    private RbacResult(boolean allowed, Set<Constraint> constraints) {
        this.allowed = allowed;
        this.constraints = constraints;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public boolean isConstrained() {
        return this.constraints != null && !this.constraints.isEmpty();
    }

    public boolean isFilterOnlyConstrainedAgainst(Shape shape) {
        if (!this.isConstrained()) {
            return false;
        }
        return Constraints.constrainOnlyByFilters(this.constraints, shape);
    }

    public boolean isCalculated() {
        return !NOT_CALCULATED.equals(this);
    }

    public Set<Constraint> getConstraints() {
        return this.constraints;
    }

    public static RbacResult forbidden() {
        return FORBIDDEN_RESULT;
    }

    public static RbacResult allowed() {
        return ALLOWED_RESULT;
    }

    public static RbacResult notCalculated() {
        return NOT_CALCULATED;
    }

    public static RbacResult constrained(Set<Constraint> constraints) {
        return new RbacResult(true, constraints);
    }

    public String toString() {
        return "RbacResult{allowed=" + this.allowed + ", constraints=" + String.valueOf(this.constraints) + "}";
    }
}

