/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.search;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BuiltInAnalyzers {
    private static final Map<String, String> LANGUAGE_ANALYZERS = ImmutableMap.builder().put((Object)"ar", (Object)"arabic").put((Object)"hy", (Object)"armenian").put((Object)"euq", (Object)"basque").put((Object)"bn", (Object)"bengali").put((Object)"bzs", (Object)"brazilian").put((Object)"bg", (Object)"bulgarian").put((Object)"ca", (Object)"catalan").put((Object)"cjk", (Object)"cjk").put((Object)"cs", (Object)"czech").put((Object)"cse", (Object)"czech").put((Object)"da", (Object)"danish").put((Object)"dsl", (Object)"danish").put((Object)"nl", (Object)"dutch").put((Object)"en", (Object)"english").put((Object)"et", (Object)"estonian").put((Object)"ekk", (Object)"estonian").put((Object)"eso", (Object)"estonian").put((Object)"fi", (Object)"finnish").put((Object)"fr", (Object)"french").put((Object)"gl", (Object)"galician").put((Object)"de", (Object)"german").put((Object)"grk", (Object)"greek").put((Object)"hi", (Object)"hindi").put((Object)"hu", (Object)"hungarian").put((Object)"id", (Object)"indonesian").put((Object)"ga", (Object)"irish").put((Object)"it", (Object)"italian").put((Object)"lv", (Object)"latvian").put((Object)"lt", (Object)"lithuanian").put((Object)"no", (Object)"norwegian").put((Object)"fa", (Object)"persian").put((Object)"pt", (Object)"portuguese").put((Object)"ro", (Object)"romanian").put((Object)"ru", (Object)"russian").put((Object)"es", (Object)"spanish").put((Object)"sv", (Object)"swedish").put((Object)"tr", (Object)"turkish").put((Object)"th", (Object)"thai").build();
    private static final Set<String> BUILT_IN_ANALYZERS = Stream.concat(Stream.of("standard", "simple", "whitespace", "stop", "keyword", "pattern", "fingerprint"), LANGUAGE_ANALYZERS.values().stream()).collect(Collectors.toSet());

    private BuiltInAnalyzers() {
    }

    public static Optional<String> analyzerForLang(String lang) {
        return Optional.ofNullable(LANGUAGE_ANALYZERS.get(lang));
    }

    public static boolean exists(String analyzer) {
        return BUILT_IN_ANALYZERS.contains(analyzer);
    }
}

