/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.sanitizing;

import com.ontotext.models.Prefixes;
import com.ontotext.models.extensions.OperationResponse;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public interface Sanitizable {
    public void sanitize(Context var1);

    public static void sanitize(Context context, Sanitizable sanitizable) {
        if (sanitizable != null) {
            sanitizable.sanitize(context);
        }
    }

    public static void sanitize(Context context, Sanitizable ... sanitizables) {
        for (Sanitizable sanitizable : sanitizables) {
            sanitizable.sanitize(context);
        }
    }

    public static class Context {
        private OperationResponse operationReport = new OperationResponse();
        private Prefixes prefixes;
        private Map<String, String> sanitizedPrefixNamespaces = Collections.emptyMap();
        private Map<String, String> sanitizedObjectIds = Collections.emptyMap();
        private Map<String, String> sanitizedPropertiesNames;

        public OperationResponse getOperationReport() {
            return this.operationReport;
        }

        public Prefixes getPrefixes() {
            return this.prefixes;
        }

        public void setPrefixes(Prefixes prefixes) {
            this.prefixes = prefixes;
        }

        public Map<String, String> getSanitizedPrefixNamespaces() {
            return this.sanitizedPrefixNamespaces;
        }

        public void setSanitizedPrefixNamespaces(Map<String, String> sanitizedPrefixNamespaces) {
            this.sanitizedPrefixNamespaces = sanitizedPrefixNamespaces;
        }

        public Map<String, String> getSanitizedObjectIds() {
            return this.sanitizedObjectIds;
        }

        public void setSanitizedObjectIds(Map<String, String> sanitizedObjectIds) {
            this.sanitizedObjectIds = sanitizedObjectIds;
        }

        public Map<String, String> getOrCreateSanitizedPropertiesNames() {
            if (this.sanitizedPropertiesNames == null) {
                this.sanitizedPropertiesNames = new HashMap<String, String>();
            }
            return this.sanitizedPropertiesNames;
        }

        public boolean isSanitizingApplied() {
            return !this.sanitizedPrefixNamespaces.isEmpty() || !this.sanitizedObjectIds.isEmpty() || !this.getOrCreateSanitizedPropertiesNames().isEmpty();
        }
    }
}

