/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Order {
    private final List<String> objectReferenceChain;
    private final String property;
    private final String rawValue;
    private final boolean ascending;
    public static final String TYPENAME_ALIAS = "_typename";

    public Order(List<String> objectReferenceChain, String property) {
        this(objectReferenceChain, property, null);
    }

    public Order(List<String> objectReferenceChain, String property, String rawValue) {
        this(objectReferenceChain, property, !"DESC".equalsIgnoreCase(rawValue), rawValue);
    }

    public Order(List<String> objectReferenceChain, String property, boolean ascending, String rawValue) {
        this.objectReferenceChain = objectReferenceChain == null ? Collections.emptyList() : Collections.unmodifiableList(objectReferenceChain);
        this.rawValue = Objects.toString(rawValue, ascending ? "ASC" : "DESC");
        this.property = TYPENAME_ALIAS.equals(property) ? "__typename" : property;
        this.ascending = ascending;
    }

    public static Order asc(List<String> objectReferenceChain, String property) {
        return new Order(objectReferenceChain, property, "ASC");
    }

    public static Order desc(List<String> objectReferenceChain, String property) {
        return new Order(objectReferenceChain, property, "DESC");
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Order)) {
            return false;
        }
        Order order = (Order)obj;
        return Objects.equals(this.property, order.property) && Objects.equals(this.rawValue, order.rawValue);
    }

    public int hashCode() {
        return Objects.hash(this.property, this.rawValue);
    }

    public List<String> getObjectReferenceChain() {
        return this.objectReferenceChain;
    }

    public List<String> getOrderPathWithTypes() {
        ArrayList<String> orderPath = new ArrayList<String>(this.objectReferenceChain.size() + 1);
        orderPath.addAll(this.getObjectReferenceChain());
        if (this.getProperty() != null) {
            orderPath.add(this.getProperty());
        }
        return orderPath;
    }

    public List<String> getOrderPath() {
        List<String> orderPath = this.getOrderPathWithTypes();
        orderPath.removeIf(step -> step.startsWith("_if"));
        return orderPath;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String toString() {
        String path = String.join((CharSequence)"/", this.getOrderPath());
        return (String)(path.isEmpty() ? "" : path + "/") + this.rawValue;
    }
}

