/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.query;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.query.All;
import com.ontotext.models.query.AllExists;
import com.ontotext.models.query.And;
import com.ontotext.models.query.CaseInsensitiveRegex;
import com.ontotext.models.query.CaseInsensitiveRegexMismatch;
import com.ontotext.models.query.Equals;
import com.ontotext.models.query.Exists;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.GreaterThan;
import com.ontotext.models.query.GreaterThanEquals;
import com.ontotext.models.query.In;
import com.ontotext.models.query.LessThan;
import com.ontotext.models.query.LessThanEquals;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.Not;
import com.ontotext.models.query.NotEquals;
import com.ontotext.models.query.NotIn;
import com.ontotext.models.query.Or;
import com.ontotext.models.query.Regex;
import com.ontotext.models.query.RegexMismatch;
import com.ontotext.models.query.StringContains;
import com.ontotext.models.query.StringEndsWith;
import com.ontotext.models.query.StringStartWith;
import com.ontotext.models.query.UniqueLang;
import com.ontotext.models.query.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class ExpressionsFactory {
    private static final Map<String, Function<Object, ExpressionTerm>> TERMS = new LinkedHashMap<String, Function<Object, ExpressionTerm>>();
    private static final Map<String, Supplier<Expression>> EXPRESSIONS = new LinkedHashMap<String, Supplier<Expression>>();

    private static List<Object> toList(Object value) {
        Object wrapped;
        if (value instanceof Value && (wrapped = ((Value)value).getValue()) instanceof Collection) {
            return ((Collection)wrapped).stream().map(Value::new).collect(Collectors.toList());
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Collection) {
            return new ArrayList<Object>((Collection)value);
        }
        return Collections.singletonList(value);
    }

    private ExpressionsFactory() {
    }

    public static boolean isTerm(String name) {
        return TERMS.containsKey(name);
    }

    public static boolean isExpression(String name) {
        return EXPRESSIONS.containsKey(name);
    }

    public static boolean isNode(String name) {
        return !ExpressionsFactory.isTerm(name) && !ExpressionsFactory.isExpression(name);
    }

    public static Node node(String name, Shape shape, PropertyShape propertyShape) {
        return new Node(name, shape, propertyShape, false, ExpressionsFactory.and());
    }

    public static Node subNode(String name, Shape shape, PropertyShape propertyShape) {
        return new Node(name, shape, propertyShape, ExpressionsFactory.and());
    }

    public static ExpressionTerm term(String name, Object value) {
        return TERMS.getOrDefault(name, ExpressionsFactory.throwUndefinedTerm(name)).apply(ExpressionsFactory.createValue(value));
    }

    public static <V> ExpressionValue<V> createValue(V value) {
        if (value == null) {
            return Value.NULL_VALUE;
        }
        if (value instanceof Value) {
            return ((Value)value).deepCopy();
        }
        return new Value<V>(value);
    }

    public static Expression expression(String name) {
        return EXPRESSIONS.getOrDefault(name, ExpressionsFactory.throwUndefinedExpression(name)).get();
    }

    public static Expression exists() {
        return ExpressionsFactory.expression("EXISTS");
    }

    public static Expression not() {
        return ExpressionsFactory.expression("NOT");
    }

    public static Expression and() {
        return ExpressionsFactory.expression("AND");
    }

    public static Expression or() {
        return ExpressionsFactory.expression("OR");
    }

    public static Expression all() {
        return ExpressionsFactory.expression("ALL");
    }

    public static Expression allExists() {
        return ExpressionsFactory.expression("ALL_EXISTS");
    }

    private static Supplier<Expression> throwUndefinedExpression(String name) {
        return () -> {
            throw new IllegalArgumentException("Unknown expression " + name);
        };
    }

    private static Function<Object, ExpressionTerm> throwUndefinedTerm(String name) {
        return value -> {
            throw new IllegalArgumentException("Unknown expression " + name + " used on value " + String.valueOf(value));
        };
    }

    static {
        EXPRESSIONS.put("ALL", All::new);
        EXPRESSIONS.put("ALL_EXISTS", AllExists::new);
        EXPRESSIONS.put("AND", And::new);
        EXPRESSIONS.put("NOT", Not::new);
        EXPRESSIONS.put("OR", Or::new);
        EXPRESSIONS.put("EXISTS", Exists::new);
        EXPRESSIONS.put("UNIQ_LANG", UniqueLang::new);
        TERMS.put("IRE", CaseInsensitiveRegex::new);
        TERMS.put("NIRE", CaseInsensitiveRegexMismatch::new);
        TERMS.put("EQ", Equals::new);
        TERMS.put("GT", GreaterThan::new);
        TERMS.put("GTE", GreaterThanEquals::new);
        TERMS.put("IN", value -> new In(ExpressionsFactory.toList(value)));
        TERMS.put("LT", LessThan::new);
        TERMS.put("LTE", LessThanEquals::new);
        TERMS.put("NEQ", NotEquals::new);
        TERMS.put("NIN", value -> new NotIn(ExpressionsFactory.toList(value)));
        TERMS.put("RE", Regex::new);
        TERMS.put("NRE", RegexMismatch::new);
        TERMS.put("STRSTARTS", StringStartWith::new);
        TERMS.put("STRENDS", StringEndsWith::new);
        TERMS.put("CONTAINS", StringContains::new);
    }
}

