/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.mutation.data.generation;

import com.ontotext.models.Operation;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.ValidationResult;
import com.ontotext.models.mutation.data.generation.DataGenerationContext;
import com.ontotext.models.mutation.data.generation.DataGenerator;
import com.ontotext.soaas.plugin.PluginsManager;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGenerators {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataGenerators.class);
    private List<DataGenerator> generators;

    public OperationResponse generate(Operation operation, DataGenerationContext ctx) {
        return this.getGenerators().stream().map(generator -> generator.generate(operation, ctx)).filter(Objects::nonNull).reduce(new OperationResponse(), OperationResponse::addAll);
    }

    public void generate(List<Operation> operations, DataGenerationContext ctx, ValidationResult validationResult) {
        if (operations.isEmpty()) {
            return;
        }
        this.invoke(operations, op -> this.generate((Operation)op, ctx), validationResult::addErrorResponse);
    }

    private void invoke(List<Operation> operations, Function<Operation, OperationResponse> toInvoke, Consumer<Serializable> messageCollector) {
        operations.stream().map(toInvoke).filter(response -> !response.isValid()).flatMap(this.getFailureMessages()).forEach(messageCollector);
    }

    private Function<OperationResponse, Stream<Serializable>> getFailureMessages() {
        return response -> response.getMessages().stream().filter(OperationResponse.OperationMessage::isFailureMessage).map(OperationResponse.OperationMessage::serialize);
    }

    private List<DataGenerator> getGenerators() {
        if (this.generators == null) {
            List extensions = PluginsManager.loadPlugins(DataGenerator.class);
            LOGGER.trace("Loaded {} extensions are: {}", (Object)DataGenerator.class.getName(), (Object)extensions);
            this.generators = Collections.unmodifiableList(extensions);
        }
        return this.generators;
    }
}

