/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.mutation;

import com.ontotext.models.query.AbstractExpressionVisitor;
import com.ontotext.models.query.Equals;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionTraverserContext;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.FilterExpressionTraverser;
import com.ontotext.models.query.In;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.Not;
import com.ontotext.models.query.Or;
import com.ontotext.models.query.TraversalControl;
import com.ontotext.soaas.common.CollectionsUtil;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class IdSelector
extends AbstractExpressionVisitor<TraversalControl, ExpressionTraverserContext> {
    private final boolean removeSelected;
    private List<String> ids = new LinkedList<String>();

    IdSelector(boolean removeSelected) {
        this.removeSelected = removeSelected;
    }

    public static List<String> collectIds(ExpressionValue<?> expression) {
        if (expression == null) {
            return Collections.emptyList();
        }
        IdSelector idSelector = new IdSelector(false);
        FilterExpressionTraverser.traversePreOrder(expression, idSelector);
        return idSelector.getIds();
    }

    public static List<String> extractAndRemoveIds(ExpressionValue<?> expression) {
        if (expression == null) {
            return Collections.emptyList();
        }
        IdSelector idSelector = new IdSelector(true);
        FilterExpressionTraverser.traversePreOrder(expression, idSelector);
        return idSelector.getIds();
    }

    @Override
    public TraversalControl visit(In target, ExpressionTraverserContext context) {
        long depth = IdSelector.getNodeDepth(context);
        if (depth == 1L && IdSelector.isIdNode(context)) {
            ((List)target.getValue()).stream().map(id -> Objects.toString(id, null)).filter(Objects::nonNull).forEach(this.ids::add);
            if (this.removeSelected) {
                IdSelector.removeNodeValue(context);
            }
        }
        return TraversalControl.QUIT;
    }

    @Override
    public TraversalControl visit(Equals target, ExpressionTraverserContext context) {
        long depth = IdSelector.getNodeDepth(context);
        if (depth == 1L && IdSelector.isIdNode(context)) {
            String value = Objects.toString(target.getValue(), null);
            CollectionsUtil.addIfNotNull(this.ids, (Object)value);
            if (this.removeSelected) {
                IdSelector.removeNodeValue(context);
            }
        }
        return TraversalControl.QUIT;
    }

    @Override
    public TraversalControl visit(Not target, ExpressionTraverserContext context) {
        return TraversalControl.QUIT;
    }

    @Override
    public TraversalControl visit(Or target, ExpressionTraverserContext context) {
        return TraversalControl.QUIT;
    }

    private static long getNodeDepth(ExpressionTraverserContext context) {
        return context.getPath().filter(Node.class::isInstance).count();
    }

    private static boolean isIdNode(ExpressionTraverserContext context) {
        return context.getPath().filter(Node.class::isInstance).anyMatch(node -> "id".equals(((Node)node).getName()));
    }

    private static void removeNodeValue(ExpressionTraverserContext context) {
        context.getPath().filter(Node.class::isInstance).map(Node.class::cast).findFirst().ifPresent(node -> node.setValue(new ExpressionCollection()));
    }

    public List<String> getIds() {
        return this.ids;
    }
}

