/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.mutation;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.IdSelector;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.FilteredSelection;
import java.util.List;
import java.util.Objects;

public class ChangePreconditions {
    private final Change parentChange;
    private final PropertyShape incomingRelation;
    private final FilteredSelection precondition;
    private final String actualChangeId;
    private final List<String> idSelection;

    public ChangePreconditions(Change parentChange, PropertyShape incomingRelation, ExpressionValue<?> precondition, String actualChangeId) {
        this.parentChange = parentChange;
        this.incomingRelation = incomingRelation;
        this.precondition = new FilteredSelection(precondition);
        this.actualChangeId = actualChangeId;
        this.idSelection = IdSelector.collectIds(precondition);
    }

    public ChangePreconditions(Change parentChange, ChangePreconditions preconditions) {
        this.parentChange = parentChange;
        this.incomingRelation = preconditions.incomingRelation;
        this.precondition = preconditions.precondition;
        this.actualChangeId = preconditions.actualChangeId;
        this.idSelection = preconditions.idSelection;
    }

    public Change getParentChange() {
        return this.parentChange;
    }

    public PropertyShape getIncomingRelation() {
        return this.incomingRelation;
    }

    public ExpressionValue getPrecondition() {
        return this.precondition.getExpression();
    }

    public String getActualChangeId() {
        return this.actualChangeId;
    }

    public boolean hasPreconditions() {
        return Objects.nonNull(this.parentChange) || Objects.nonNull(this.incomingRelation) || Objects.nonNull(this.precondition.getExpression()) || Objects.nonNull(this.actualChangeId);
    }

    public boolean isSubCreate() {
        return this.getPrecondition() == null && this.getActualChangeId() == null;
    }

    public boolean isNestedChange() {
        return Objects.nonNull(this.parentChange);
    }

    public List<String> getIdSelection() {
        return this.idSelection;
    }

    public FilteredSelection getPreconditionSelection() {
        return this.precondition;
    }
}

