/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.QueryValidationMessage;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ValidationResult {
    private List<OperationResponse> results = new LinkedList<OperationResponse>();

    public void addResponse(OperationResponse operationResponse) {
        this.results.add(operationResponse);
    }

    public void addErrorResponse(Serializable errorMessage) {
        OperationResponse response = new OperationResponse();
        response.addErrorMessage(errorMessage);
        this.addResponse(response);
    }

    public void addResponses(List<OperationResponse> operationResponses) {
        this.results.addAll(operationResponses);
    }

    public List<Serializable> getErrors() {
        return this.results.stream().filter(response -> !response.isValid()).flatMap(response -> response.getMessages().stream().filter(OperationResponse.OperationMessage::isFailureMessage).map(message -> {
            if (message instanceof QueryValidationMessage) {
                return message.serialize();
            }
            return message.getMessage();
        })).collect(Collectors.toList());
    }

    public List<Serializable> getWarnings() {
        return this.results.stream().filter(OperationResponse::hasWarnings).flatMap(response -> response.getMessages().stream().filter(OperationResponse.OperationMessage::isWarning).map(OperationResponse.OperationMessage::serialize)).collect(Collectors.toList());
    }

    public boolean shouldBreakOperation() {
        return this.hasErrors();
    }

    public boolean hasErrors() {
        return !this.results.stream().allMatch(OperationResponse::isValid);
    }

    public boolean hasWarnings() {
        return this.results.stream().anyMatch(OperationResponse::hasWarnings);
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }
}

