/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.Properties;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.soaas.plugin.Order;

@Order(value=10000)
public class SetInheritedPropertyCardinality
implements SchemaExtension {
    @Override
    public void process(SomlSchema somlSchema) {
        for (Shape shape : somlSchema.getObjects().values()) {
            Properties properties = shape.getAllProperties();
            if (properties == null) continue;
            for (PropertyShape property : properties.values()) {
                shape.getParents().forEach(parent -> this.setInheritedCardinality(shape, property, (Shape)parent));
            }
        }
    }

    private void setInheritedCardinality(Shape shape, PropertyShape property, Shape parent) {
        PropertyShape parentProp = (PropertyShape)parent.getAllProperties().get(property.getName());
        Properties shapeProps = shape.getProps();
        if (this.shouldSetMax(property, shapeProps, parentProp)) {
            property.setMax(String.valueOf(parentProp.getMaxValue()));
        }
        if (this.shouldSetMin(property, shapeProps, parentProp)) {
            property.setMin(parentProp.getMin());
        }
    }

    private boolean shouldSetMax(PropertyShape property, Properties shapeProps, PropertyShape parentProp) {
        return parentProp != null && parentProp.getMaxValue() != null && parentProp.getMaxValue() < property.getMaxValue() && (shapeProps == null || shapeProps.get(property.getName()) == null || !((PropertyShape)shapeProps.get(property.getName())).isTracked("max"));
    }

    private boolean shouldSetMin(PropertyShape property, Properties shapeProps, PropertyShape parentProp) {
        return parentProp != null && parentProp.getMin() != null && parentProp.getMin() > property.getMin() && (shapeProps == null || shapeProps.get(property.getName()) == null || !((PropertyShape)shapeProps.get(property.getName())).isTracked("min"));
    }
}

