/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.Severity;
import com.ontotext.models.query.SourceLocation;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class QueryValidationMessage
extends OperationResponse.OperationMessage {
    private final transient Collection<SourceLocation> sourceLocations;
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final TypeReference<LinkedHashMap<String, Object>> typeRef = new TypeReference<LinkedHashMap<String, Object>>(){};

    public QueryValidationMessage(Severity severity, String message, Collection<SourceLocation> sourceLocations) {
        super(severity, (Serializable)((Object)message));
        this.sourceLocations = sourceLocations;
    }

    public static QueryValidationMessage error(SourceLocation sourceLocation, String template, Object ... args) {
        return QueryValidationMessage.addMessage(Severity.ERROR, Collections.singleton(sourceLocation), template, args);
    }

    public static QueryValidationMessage error(Collection<SourceLocation> sourceLocations, String template, Object ... args) {
        return QueryValidationMessage.addMessage(Severity.ERROR, sourceLocations, template, args);
    }

    public static QueryValidationMessage fatal(SourceLocation sourceLocation, String template, Object ... args) {
        return QueryValidationMessage.addMessage(Severity.FATAL, Collections.singleton(sourceLocation), template, args);
    }

    public static QueryValidationMessage fatal(Collection<SourceLocation> sourceLocations, String template, Object ... args) {
        return QueryValidationMessage.addMessage(Severity.FATAL, sourceLocations, template, args);
    }

    public static QueryValidationMessage addMessage(Severity severity, Collection<SourceLocation> locations, String template, Object ... args) {
        return new QueryValidationMessage(severity, ErrorMessages.get(template, args), locations);
    }

    @Override
    public Serializable serialize() {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>(4);
        response.put("message", super.toString());
        response.put("locations", this.getLocations());
        return response;
    }

    public String toSerializedString() {
        try {
            return mapper.writer().writeValueAsString((Object)this.serialize());
        }
        catch (JsonProcessingException jpe) {
            return this.serialize().toString();
        }
    }

    public static Serializable serializeFromSerializedString(String serialized) throws IOException {
        return (Serializable)mapper.readValue(serialized, typeRef);
    }

    private List<Map<String, Object>> getLocations() {
        return this.sourceLocations.stream().filter(Objects::nonNull).map(SourceLocation::toMap).collect(Collectors.toList());
    }

    public int hashCode() {
        return Objects.hash(this.serialize());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QueryValidationMessage other = (QueryValidationMessage)obj;
        return Objects.equals(this.serialize(), other.serialize());
    }
}

