/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.MessageProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public abstract class PropertiesMessageProvider
implements MessageProvider {
    private final String path;

    public PropertiesMessageProvider(String path) {
        this.path = path;
    }

    @Override
    public Map<String, String> provide() {
        Properties properties = new Properties();
        try (InputStream stream = this.resolveStream();){
            properties.load(stream);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not load properties file from " + this.path, ioe);
        }
        LinkedHashMap<String, String> messages = new LinkedHashMap<String, String>(properties.size());
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> messages.put(key.toString(), value.toString())));
        return messages;
    }

    private InputStream resolveStream() throws FileNotFoundException {
        InputStream resourceAsStream = this.getClass().getClassLoader().getResourceAsStream(this.path);
        if (resourceAsStream == null) {
            File file = new File(this.path);
            if (file.exists() && file.isFile()) {
                resourceAsStream = new FileInputStream(file);
            } else {
                throw new IllegalArgumentException("Could not load properties file from " + this.path);
            }
        }
        return resourceAsStream;
    }
}

