/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.models.sanitizing.SchemaSanitizerUtils;
import com.ontotext.soaas.common.StringManipulation;
import com.ontotext.soaas.plugin.Order;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Order(value=51)
public class GenerateSubscriptionResponseTypes
implements SchemaExtension {
    private static final Set<String> SYSTEM_SHAPES = Shapes.SYSTEM_SHAPES.stream().filter(Predicate.isEqual("HealthCheck").negate()).collect(Collectors.toSet());
    public static final String SUBSCRIPTION_SUFFIX = "_Subscription";

    @Override
    public boolean canHandle(SomlSchema somlSchema) {
        return !Boolean.TRUE.equals(somlSchema.getInternal()) && somlSchema.getSpecialPrefixes().getVocabPrefix().isPresent();
    }

    @Override
    public void process(SomlSchema somlSchema) {
        Shapes objects = somlSchema.getObjects();
        LinkedHashMap<String, Shape> typesCopy = new LinkedHashMap<String, Shape>(objects);
        typesCopy.keySet().removeAll(SYSTEM_SHAPES);
        typesCopy.values().removeIf(Shape::isSynthetic);
        typesCopy.values().removeIf(Shape::isUnion);
        Shape template = (Shape)objects.get("SubscriptionResponse");
        typesCopy.forEach((name, shape) -> objects.computeIfAbsent(name + SUBSCRIPTION_SUFFIX, newName -> this.createSubscriptionFor((String)newName, (Shape)shape, template)));
        somlSchema.expandSchema();
    }

    private Shape createSubscriptionFor(String newName, Shape base, Shape template) {
        Shape shape = new Shape(true);
        shape.setId(newName);
        shape.setDescr("System generated type used for subscription response for " + SchemaSanitizerUtils.sanitizeValue(base.getId()));
        shape.setInherits("SubscriptionResponse");
        shape.setSynthetic(Boolean.TRUE);
        PropertyShape typeProperty = this.createTypeProperty(base);
        if (template.getProperty(typeProperty.getName()).isPresent()) {
            throw new InvalidSchemaException(ErrorMessages.get("subscription.property.collision", base.getId(), typeProperty.getName()));
        }
        return shape.addProperty(typeProperty);
    }

    private PropertyShape createTypeProperty(Shape base) {
        String shapeId = StringManipulation.replaceColonWithUnderscore((String)base.getId());
        String typeName = StringUtils.uncapitalize((String)shapeId);
        PropertyShape typeProperty = PropertyShape.create(typeName, base.getId(), null, "1");
        typeProperty.setDescr("Contains references to all affected " + SchemaSanitizerUtils.sanitizeValue(shapeId) + " objects");
        return typeProperty;
    }
}

