/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models.extensions;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.SchemaExtension;
import com.ontotext.soaas.plugin.Order;
import java.util.Collections;

@Order(value=40)
public class GenerateDefaultTypeProperty
implements SchemaExtension {
    @Override
    public boolean canHandle(SomlSchema somlSchema) {
        return somlSchema.getSpecialPrefixes().getVocabPrefix().isPresent();
    }

    @Override
    public void process(SomlSchema somlSchema) {
        Prefixes prefixes = somlSchema.getPrefixes();
        Shapes objects = somlSchema.getObjects();
        for (Shape object : objects.values()) {
            if (object.isAbstract() || object.isUnion() || object.getType() != null && !object.getTypeAsList().isEmpty()) continue;
            try {
                object.setType(prefixes.toShortIri(object.getProps().simplifyName(object.getId())));
            }
            catch (InvalidSchemaException ise) {
                object.setType(Collections.emptyList());
            }
        }
    }
}

