/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ExtensionOptions;
import com.ontotext.models.ServiceExtensionOptions;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.Collections;
import java.util.Map;

public interface ValidatorOptions
extends ServiceExtensionOptions<Options> {
    default public boolean isAsyncValidationEnabled() {
        return true;
    }

    default public int getMaxConcurrentValidationsPerRequest() {
        return 4;
    }

    default public long getAsyncValidationTimeoutSeconds() {
        return 60L;
    }

    public static ValidatorOptions emptyOptions() {
        return NoOptions.EMPTY;
    }

    @Override
    default public Options getDefaultOptions() {
        return Options.DEFAULT;
    }

    default public boolean isValidatorEnabled(String validatorName) {
        return ((Map)ObjectsUtil.getOrDefault(this.getOptions(), Collections.emptyMap())).getOrDefault(validatorName, Options.DEFAULT).isEnabled();
    }

    default public ValidationFailureMode getValidationFailureMode() {
        return ValidationFailureMode.DEFAULT;
    }

    public static class NoOptions
    implements ValidatorOptions {
        private static final ValidatorOptions EMPTY = new NoOptions();

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void setEnabled(boolean enable) {
        }

        @Override
        public Map<String, Options> getOptions() {
            return Collections.emptyMap();
        }
    }

    public static class Options
    extends ExtensionOptions {
        private static final Options DEFAULT = new Options();

        static {
            DEFAULT.setEnabled(true);
        }
    }

    public static enum ValidationFailureMode {
        DEFAULT,
        IGNORE,
        WARN,
        ERROR,
        FAIL;

    }
}

