/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.ShaclConstraintViolation;
import com.ontotext.models.ShaclSchema;
import com.ontotext.models.shacl.ShaclConstraint;
import com.ontotext.soaas.common.ErrorCode;
import com.ontotext.soaas.common.exceptions.ShaclBindException;
import com.ontotext.soaas.common.rdf.EntityPoolFactory;
import com.ontotext.soaas.common.rdf.RdfData;
import com.ontotext.soaas.common.rdf.Triple;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.common.exception.ValidationException;
import org.eclipse.rdf4j.common.text.ASCIIUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationReportParser {
    public static final String SHACL_FAILED_VALIDATION = "Failed SHACL validation";
    private static final String GENID_PREFIX = "genid";
    private final ValueFactory vf = SimpleValueFactory.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidationReportParser.class);

    public List<ShaclConstraintViolation> parse(String raw, ShaclSchema shacl) {
        Model rawReport = this.parseShaclReport(raw, shacl);
        return this.parse(rawReport, shacl);
    }

    public List<ShaclConstraintViolation> parse(ValidationException model, ShaclSchema shacl) {
        return this.parse(model.validationReportAsModel(), shacl);
    }

    public List<ShaclConstraintViolation> parse(Model model, ShaclSchema shacl) {
        RdfData rawReport = this.rdf4jModelToRdfData(model);
        if (this.conforms(rawReport)) {
            return Collections.emptyList();
        }
        return rawReport.getTriples(null, RDF.TYPE.stringValue(), (Object)SHACL.VALIDATION_RESULT).stream().map(Triple::getSubject).flatMap(subject -> this.processSingleViolation((String)subject, shacl, rawReport)).collect(Collectors.toList());
    }

    public Model parseShaclReport(String raw, ShaclSchema shacl) {
        return this.extractRdfFromTurtle(raw, shacl.getSpecialPrefixes().getBaseIri().orElse(null));
    }

    private Stream<ShaclConstraintViolation> processSingleViolation(String subject, ShaclSchema shacl, RdfData rawReport) {
        Prefixes prefixes = shacl.getPrefixes();
        IRI constraint = this.getSourceConstraint(subject, rawReport);
        ShaclConstraint constraintType = this.getShaclConstraintType(subject, constraint, rawReport, prefixes);
        if (null == constraintType) {
            return Stream.empty();
        }
        Collection sourceShapeIdSet = rawReport.get(subject, SHACL.SOURCE_SHAPE.stringValue());
        ValidationReportParser.checkConstraintValidationSize(subject, sourceShapeIdSet, "shapes");
        Collection propIriSet = rawReport.get(subject, SHACL.RESULT_PATH.stringValue());
        ValidationReportParser.checkConstraintValidationSize(subject, propIriSet, "SOML properties");
        IRI propIri = propIriSet.stream().findFirst().orElse(null);
        String propName = null;
        if (propIri != null) {
            propName = prefixes.toName(propIri.stringValue());
        }
        Collection valueSet = rawReport.get(subject, SHACL.VALUE.stringValue());
        ValidationReportParser.checkConstraintValidationSize(subject, valueSet, "values");
        Collection nodeSet = rawReport.get(subject, SHACL.FOCUS_NODE.stringValue());
        ValidationReportParser.checkConstraintValidationSize(subject, nodeSet, "focused nodes");
        IRI node = (IRI)nodeSet.stream().findFirst().orElseThrow(ValidationReportParser.blankNodeInsert());
        String nodeName = node.stringValue();
        try {
            nodeName = prefixes.toShortIri(nodeName);
        }
        catch (InvalidSchemaException invalidSchemaException) {
            // empty catch block
        }
        Object sourceShapeId = sourceShapeIdSet.stream().findFirst().orElseThrow(IllegalArgumentException::new);
        Object value = valueSet.stream().findFirst().orElse(null);
        ShaclConstraintViolation violation = new ShaclConstraintViolation(constraintType, nodeName, sourceShapeId, propName, value);
        violation.parseTargetValue(shacl);
        return Stream.of(violation);
    }

    private static Supplier<IllegalArgumentException> blankNodeInsert() {
        return () -> new IllegalArgumentException("Trying to insert a blank node triple!");
    }

    private ShaclConstraint getShaclConstraintType(String subject, IRI constraint, RdfData rawReport, Prefixes prefixes) {
        Collection hasValueInSet;
        Resource subConstraint;
        Map listConstraintDetails;
        ShaclConstraint constraintType = constraint.equals((Object)SHACL.HAS_VALUE_CONSTRAINT_COMPONENT) ? ((listConstraintDetails = rawReport.get((subConstraint = (Resource)(hasValueInSet = rawReport.get(subject, SHACL.SOURCE_SHAPE.toString())).stream().findFirst().orElseThrow(ValidationReportParser.missingListConstrainedComponent())).stringValue())).containsKey(DASH.hasValueIn.stringValue()) ? ShaclConstraint.forReport(DASH.HasValueInConstraintComponent.getLocalName()) : ShaclConstraint.forReport(prefixes.toName(constraint.getLocalName()))) : ShaclConstraint.forReport(prefixes.toName(constraint.getLocalName()));
        return constraintType;
    }

    private static Supplier<IllegalArgumentException> missingListConstrainedComponent() {
        return () -> new IllegalArgumentException("Each list constraint must have a constraint component!");
    }

    private boolean conforms(RdfData rawReport) {
        Collection conformityTriple = rawReport.getTriples(null, SHACL.CONFORMS.stringValue(), null);
        if (conformityTriple.isEmpty()) {
            LOGGER.info("The SHACL sail returned an error response, but the data is valid!");
            return true;
        }
        Object conformityValue = ((Triple)conformityTriple.iterator().next()).getObject();
        if (conformityValue instanceof Literal) {
            return ((Literal)conformityValue).booleanValue();
        }
        LOGGER.info("The SHACL sail returned an error response, but {} value is unrecognized!", (Object)SHACL.CONFORMS);
        return false;
    }

    private IRI getSourceConstraint(String subject, RdfData rawReport) {
        Collection constraintSet = rawReport.get(subject, SHACL.SOURCE_CONSTRAINT_COMPONENT.stringValue());
        ValidationReportParser.checkConstraintValidationSize(subject, constraintSet, "constraints");
        return (IRI)constraintSet.stream().findFirst().orElseThrow(ValidationReportParser.missingConstrainedComponent());
    }

    private static Supplier<IllegalArgumentException> missingConstrainedComponent() {
        return () -> new IllegalArgumentException("Each validation must have a constraint component!");
    }

    public static void checkConstraintValidationSize(String subject, Collection<Object> valueSet, String message) {
        if (valueSet.size() > 1) {
            throw new IllegalArgumentException(String.format("SHACL violation '%s' matches multiple %s: '%s'", message, subject, valueSet));
        }
    }

    private Model extractRdfFromTurtle(String raw, String baseIri) {
        if (raw.contains(SHACL_FAILED_VALIDATION)) {
            raw = raw.substring(raw.indexOf(10) + 1);
        }
        if (StringUtils.isBlank((CharSequence)raw)) {
            return new LinkedHashModel();
        }
        LinkedHashModel model = new LinkedHashModel();
        try {
            RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.TURTLE);
            rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)model));
            rdfParser.getParserConfig().set((RioSetting)BasicParserSettings.PRESERVE_BNODE_IDS, (Object)true);
            rdfParser.parse((Reader)new StringReader(raw), Objects.toString(baseIri, ""));
        }
        catch (IOException exception) {
            throw new ShaclBindException("SHACL validation report parsing issue.", ErrorCode.COULD_NOT_PARSE_SHACL_VALIDATION_REPORT);
        }
        return model;
    }

    private RdfData rdf4jModelToRdfData(Model model) {
        RdfData data = EntityPoolFactory.defaultPool().emptyData();
        model.getStatements(null, null, null, new Resource[0]).forEach(arg_0 -> ((RdfData)data).add(arg_0));
        return data;
    }

    public void processClusterMismatches(List<ShaclConstraintViolation> errors, List<ShaclConstraintViolation> mismatches, ShaclSchema shacl) {
        boolean shouldWarnAboutClusterErrors = false;
        for (ShaclConstraintViolation constraint : mismatches) {
            Optional<ShaclConstraintViolation> parsedError = errors.stream().filter(otherC -> otherC.hasDuplicatesForNode(constraint)).findFirst();
            if (parsedError.isPresent()) {
                try {
                    constraint.setSemanticObject((String)parsedError.get().getSemanticObject());
                    constraint.parseTargetValue(shacl);
                }
                catch (IllegalArgumentException iae) {
                    if (!Boolean.TRUE.equals(shacl.isOperatingInCluster())) {
                        throw iae;
                    }
                    shouldWarnAboutClusterErrors = true;
                }
                continue;
            }
            shouldWarnAboutClusterErrors = true;
        }
        if (shouldWarnAboutClusterErrors) {
            LOGGER.warn("Cannot obtain full information about SHACL error due to cluster synchronization issues!");
        }
    }

    public Function<ShaclConstraintViolation, Resource> createShaclTypeResolver(List<Statement> shaclProperties) {
        if (shaclProperties.isEmpty()) {
            return constraint -> null;
        }
        LinkedHashMap typeMapping = new LinkedHashMap();
        return constraint -> {
            if (typeMapping.isEmpty()) {
                boolean encodeBnodes = this.isEncodedBnode(constraint.getSemanticObject());
                shaclProperties.stream().flatMap(this.checkForNquads(encodeBnodes)).forEach(statement -> typeMapping.put(statement.getObject(), statement.getSubject()));
            }
            if (constraint.getSemanticObject() instanceof Value) {
                return (Resource)typeMapping.get(constraint.getSemanticObject());
            }
            LOGGER.warn("SHACL model id is not of the correct type. Probably you are using incompatible GraphDB/Rdf4j/SHACL version");
            return null;
        };
    }

    private Function<Statement, Stream<Statement>> checkForNquads(boolean encodeBnodes) {
        if (encodeBnodes) {
            return statement -> {
                Resource subject = statement.getSubject();
                Value object = statement.getObject();
                boolean rewritten = false;
                if (!this.isEncodedBnode(subject)) {
                    subject = this.convertBnode((BNode)subject);
                    rewritten = true;
                }
                if (!this.isEncodedBnode(object)) {
                    object = this.convertBnode((BNode)object);
                    rewritten = true;
                }
                if (rewritten) {
                    return Stream.of(statement, this.vf.createStatement(subject, statement.getPredicate(), object, statement.getContext()));
                }
                return Stream.of(statement);
            };
        }
        return Stream::of;
    }

    private boolean isEncodedBnode(Object value) {
        if (value instanceof BNode) {
            String id = ((BNode)value).getID();
            for (int i = 0; i < id.length(); ++i) {
                if (Character.isLetterOrDigit(id.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    private BNode convertBnode(BNode bnode) {
        String nextId = bnode.getID();
        StringBuilder writer = new StringBuilder();
        if (nextId.isEmpty()) {
            writer.append(GENID_PREFIX);
            writer.append(Integer.toHexString(bnode.hashCode()));
        } else {
            if (!ASCIIUtil.isLetter((int)nextId.charAt(0))) {
                writer.append(GENID_PREFIX);
                writer.append(Integer.toHexString(nextId.charAt(0)));
            }
            for (int i = 0; i < nextId.length(); ++i) {
                if (ASCIIUtil.isLetterOrNumber((int)nextId.charAt(i))) {
                    writer.append(nextId.charAt(i));
                    continue;
                }
                writer.append(Integer.toHexString(nextId.charAt(i)));
            }
        }
        return SimpleValueFactory.getInstance().createBNode(writer.toString());
    }

    static {
        if (System.getProperty(BasicParserSettings.PRESERVE_BNODE_IDS.getKey()) == null) {
            System.setProperty(BasicParserSettings.PRESERVE_BNODE_IDS.getKey(), "true");
        }
    }
}

