/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ModelTracker;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.sanitizing.Sanitizable;
import com.ontotext.models.sanitizing.SchemaSanitizerUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpecialPrefixes
extends LinkedHashMap<String, String>
implements TrackedModel,
Sanitizable {
    public static final String BASE_IRI = "base_iri";
    public static final String ONTOLOGY_IRI = "ontology_iri";
    public static final String VOCAB_IRI = "vocab_iri";
    public static final String VOCAB_PREFIX = "vocab_prefix";
    public static final String SHAPE_IRI = "shape_iri";
    public static final String SHAPE_PREFIX = "shape_prefix";
    public static final Set<String> ALL = Collections.unmodifiableSet(Stream.of("base_iri", "ontology_iri", "vocab_prefix", "vocab_iri", "shape_iri", "shape_prefix").collect(Collectors.toSet()));
    private transient ModelTracker tracker = ModelTracker.notTracked();

    public SpecialPrefixes() {
        this.tracker = ModelTracker.tracked();
    }

    public SpecialPrefixes(boolean flag) {
    }

    public Optional<String> getBaseIri() {
        return Optional.ofNullable((String)this.get(BASE_IRI));
    }

    public Optional<String> getOntologyIri() {
        return Optional.ofNullable((String)this.get(ONTOLOGY_IRI));
    }

    public Optional<String> getVocabIri() {
        return Optional.ofNullable((String)this.get(VOCAB_IRI));
    }

    public Optional<String> getVocabPrefix() {
        return Optional.ofNullable((String)this.get(VOCAB_PREFIX));
    }

    public Optional<String> getShapeIri() {
        return Optional.ofNullable((String)this.get(SHAPE_IRI));
    }

    public Optional<String> getShapePrefix() {
        return Optional.ofNullable((String)this.get(SHAPE_PREFIX));
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SpecialPrefixes)) {
            return false;
        }
        SpecialPrefixes that = (SpecialPrefixes)obj;
        return Objects.equals(this.getBaseIri(), that.getBaseIri()) && Objects.equals(this.getOntologyIri(), that.getOntologyIri()) && Objects.equals(this.getVocabIri(), that.getVocabIri()) && Objects.equals(this.getVocabPrefix(), that.getVocabPrefix()) && Objects.equals(this.getShapeIri(), that.getShapeIri()) && Objects.equals(this.getShapePrefix(), that.getShapePrefix());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getBaseIri(), this.getOntologyIri(), this.getVocabIri(), this.getShapeIri());
    }

    void merge(SpecialPrefixes specialPrefixes) {
        this.putAll(specialPrefixes);
        specialPrefixes.keySet().forEach(this.tracker::trackModelEntry);
    }

    @Override
    public String put(String key, String value) {
        this.tracker.trackValue(key, value);
        return super.put(key, value);
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
    }

    @Override
    public void sanitize(Sanitizable.Context context) {
        Map<String, String> sanitizeSpecialPrefixes = SchemaSanitizerUtils.sanitizeMap(this, context.getOperationReport());
        sanitizeSpecialPrefixes.forEach(this.tracker::updateKey);
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId);
    }

    String toTurtle() {
        LinkedHashMap specialPfxMap = new LinkedHashMap();
        this.getBaseIri().ifPresent(base -> specialPfxMap.put("", base));
        this.getVocabPrefix().ifPresent(voc -> specialPfxMap.put(voc, this.getVocabIri().orElseThrow(() -> new IllegalArgumentException("Vocab prefix set, but vocab IRI is null!"))));
        this.getShapePrefix().ifPresent(vocsh -> specialPfxMap.put(vocsh, this.getShapeIri().orElseThrow(() -> new IllegalArgumentException("Shape prefix set, but shape IRI is null!"))));
        StringBuilder builder = new StringBuilder();
        for (Map.Entry prefixPair : specialPfxMap.entrySet()) {
            builder.append("@prefix ").append((String)prefixPair.getKey()).append(": <").append((String)prefixPair.getValue()).append("> .\n");
        }
        return builder.toString();
    }
}

