/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.Configs;
import com.ontotext.models.Prefixes;
import com.ontotext.models.Properties;
import com.ontotext.models.Queries;
import com.ontotext.models.Rbac;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.Shapes;
import com.ontotext.models.SpecialPrefixes;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.sanitizing.Sanitizable;
import com.ontotext.models.yaml.YamlPrinter;
import java.time.LocalDate;
import java.util.Objects;

public class SomlSchema
implements TrackedModel,
Sanitizable {
    private String id;
    private String label;
    private String license;
    private LocalDate created;
    private LocalDate updated;
    private String creator;
    private String versionInfo;
    private Boolean internal = Boolean.FALSE;
    private Configs config;
    private SpecialPrefixes specialPrefixes;
    private Prefixes prefixes;
    private Queries queries;
    private Properties properties;
    private Shapes objects;
    private ScalarTypes types;
    private Rbac rbac;
    private boolean sanitized = false;
    private String description;
    private boolean hasUserDefinedRbac;
    private boolean hasFederatedService;

    public void expandSchema() {
        this.setDefaults();
        if (!Boolean.TRUE.equals(this.internal)) {
            this.stopTracking();
        }
        this.prefixes.expand(this, this.specialPrefixes);
        this.types.expand();
        this.properties.expand(new Properties(true), this.types, null, this.specialPrefixes.getVocabPrefix().orElse(null));
        this.properties.setDefaults();
        this.properties.expand(new Properties(true), this.types, null, this.specialPrefixes.getVocabPrefix().orElse(null));
        this.objects.expand(this, this.properties, this.types);
        this.rbac.expand(this);
    }

    private void setDefaults() {
        if (this.config == null) {
            this.config = new Configs();
        }
        if (this.specialPrefixes == null) {
            this.specialPrefixes = new SpecialPrefixes(true);
        }
        if (this.prefixes == null) {
            this.prefixes = new Prefixes(true);
        }
        if (this.properties == null) {
            this.properties = new Properties(true);
        }
        if (this.objects == null) {
            this.objects = new Shapes(true);
        }
        if (this.types == null) {
            this.types = new ScalarTypes(true);
        }
        if (this.rbac == null) {
            this.rbac = new Rbac();
        }
        this.types.setContainedIn(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public LocalDate getCreated() {
        return this.created;
    }

    public void setCreated(LocalDate created) {
        this.created = created;
    }

    public LocalDate getUpdated() {
        return this.updated;
    }

    public void setUpdated(LocalDate updated) {
        this.updated = updated;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getVersionInfo() {
        return this.versionInfo;
    }

    public void setVersionInfo(String versionInfo) {
        this.versionInfo = versionInfo;
    }

    public Prefixes getPrefixes() {
        return this.prefixes;
    }

    public void setPrefixes(Prefixes prefixes) {
        this.prefixes = prefixes;
    }

    public Shapes getObjects() {
        return this.objects;
    }

    public void setObjects(Shapes objects) {
        this.objects = objects;
    }

    public ScalarTypes getTypes() {
        return this.types;
    }

    public void setTypes(ScalarTypes types) {
        this.types = types;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SomlSchema)) {
            return false;
        }
        SomlSchema that = (SomlSchema)obj;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getLabel(), that.getLabel()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getLicense(), that.getLicense()) && Objects.equals(this.getCreated(), that.getCreated()) && Objects.equals(this.getUpdated(), that.getUpdated()) && Objects.equals(this.getCreator(), that.getCreator()) && Objects.equals(this.getVersionInfo(), that.getVersionInfo()) && Objects.equals(this.getSpecialPrefixes(), that.getSpecialPrefixes()) && Objects.equals(this.getPrefixes(), that.getPrefixes()) && Objects.equals(this.getProperties(), that.getProperties()) && Objects.equals(this.getObjects(), that.getObjects()) && Objects.equals(this.getTypes(), that.getTypes()) && Objects.equals(this.getRbac(), that.getRbac());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getLabel(), this.getDescription(), this.getLicense(), this.getCreated(), this.getUpdated(), this.getCreator(), this.getVersionInfo(), this.getSpecialPrefixes(), this.getPrefixes(), this.getProperties(), this.getObjects(), this.getTypes(), this.getRbac());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public SpecialPrefixes getSpecialPrefixes() {
        return this.specialPrefixes;
    }

    public void setSpecialPrefixes(SpecialPrefixes specialPrefixes) {
        this.specialPrefixes = specialPrefixes;
    }

    public Queries getQueries() {
        return this.queries;
    }

    public void setQueries(Queries queries) {
        this.queries = queries;
    }

    public Rbac getRbac() {
        return this.rbac;
    }

    public void setRbac(Rbac rbac) {
        this.rbac = rbac;
    }

    public String toString() {
        return "SomlSchema [id=" + this.id + ", label=" + this.label + ", description=" + this.description + ", license=" + this.license + ", created=" + this.created + ", updated=" + this.updated + ", creator=" + this.creator + ", versionInfo=" + this.versionInfo + ", internal=" + this.internal + ", specialPrefixes=" + this.specialPrefixes + ", prefixes=" + this.prefixes + ", queries=" + this.queries + ", properties=" + this.properties + ", objects=" + this.objects + ", types=" + this.types + ", rbac=" + this.rbac + "]";
    }

    public String toYaml() {
        return this.getSchemaAsYaml(new YamlPrinter());
    }

    public String toFullYaml() {
        return this.getSchemaAsYaml(new YamlPrinter(YamlPrinter.Configuration.createDefault().enableFullPrint()));
    }

    private String getSchemaAsYaml(YamlPrinter printer) {
        return printer.addString("id", this.id).addString("label", this.label).addString("description", this.description).addString("license", this.license).addString("created", this.created).addString("updated", this.updated).addString("creator", this.creator).addString("versionInfo", this.versionInfo).addMap("config", this.config, this.config::isTracked).addMap("prefixes", this.prefixes, this.prefixes::isTracked).addMap("specialPrefixes", this.specialPrefixes, this.specialPrefixes::isTracked).addYaml("properties", this.properties, 0).addYaml(this.types).addYaml(this.objects).addYaml(this.rbac).asString();
    }

    public Boolean getInternal() {
        return this.internal;
    }

    public void setInternal(Boolean internal) {
        this.internal = internal;
    }

    @Override
    public void startTracking() {
        this.types.startTracking();
        this.prefixes.startTracking();
        this.specialPrefixes.startTracking();
        this.properties.startTracking();
        this.objects.startTracking();
        this.config.startTracking();
        if (this.rbac.getRoles() != null) {
            this.rbac.getRoles().startTracking();
        }
    }

    @Override
    public void stopTracking() {
        this.types.stopTracking();
        this.prefixes.stopTracking();
        this.specialPrefixes.stopTracking();
        this.properties.stopTracking();
        this.objects.stopTracking();
        this.config.stopTracking();
        if (this.rbac.getRoles() != null) {
            this.rbac.getRoles().stopTracking();
        }
    }

    @Override
    public void clearTrackedInformation() {
        this.types.clearTrackedInformation();
        this.prefixes.clearTrackedInformation();
        this.specialPrefixes.clearTrackedInformation();
        this.properties.clearTrackedInformation();
        this.objects.clearTrackedInformation();
        this.config.clearTrackedInformation();
        if (this.rbac.getRoles() != null) {
            this.rbac.getRoles().clearTrackedInformation();
        }
    }

    @Override
    public boolean isTracked(String modelId) {
        return false;
    }

    public Configs getConfig() {
        return this.config;
    }

    public void setConfig(Configs config) {
        this.config = config;
    }

    @Override
    public void sanitize(Sanitizable.Context context) {
        Sanitizable.sanitize(context, this.prefixes, this.specialPrefixes, this.properties, this.objects, this.rbac);
    }

    public void setSanitized() {
        this.sanitized = true;
    }

    public boolean isSanitized() {
        return this.sanitized;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hasUserDefinedRbac() {
        return this.hasUserDefinedRbac;
    }

    public void setHasUserDefinedRbac(boolean hasUserDefinedRbac) {
        this.hasUserDefinedRbac = hasUserDefinedRbac;
    }

    public boolean hasFederatedService() {
        return this.hasFederatedService;
    }

    public void setHasFederatedService(boolean hasFederatedService) {
        this.hasFederatedService = hasFederatedService;
    }
}

