/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.Prefixes;
import com.ontotext.models.ShaclTargetNode;
import com.ontotext.models.SpecialPrefixes;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.ArrayList;
import java.util.List;

public class ShaclSchema {
    private final String id;
    private final String label;
    private Prefixes prefixes;
    private SpecialPrefixes specialPrefixes;
    private List<ShaclTargetNode> shaclTargetNodes = new ArrayList<ShaclTargetNode>();
    private Boolean enabledAtTransactionLevel;
    private Boolean operatingInCluster;
    public static final ShaclSchema EMPTY_SHACL_SCHEMA = new ShaclSchema("empty", "empty");

    public ShaclSchema(String id, String label) {
        this.id = id;
        this.label = label;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public Prefixes getPrefixes() {
        return this.prefixes;
    }

    public void setPrefixes(Prefixes prefixes) {
        this.prefixes = prefixes;
    }

    public SpecialPrefixes getSpecialPrefixes() {
        return this.specialPrefixes;
    }

    public void setSpecialPrefixes(SpecialPrefixes specialPrefixes) {
        this.specialPrefixes = specialPrefixes;
    }

    public List<ShaclTargetNode> getShaclTargetNodes() {
        return this.shaclTargetNodes;
    }

    public ShaclTargetNode getShaclTargetNode(String name) {
        String normalized = ShaclSchema.dropLeadingUnderscore(name);
        return this.shaclTargetNodes.stream().filter(node -> node.getTargetShape().getId().equals(normalized)).findFirst().orElseThrow(() -> new IllegalArgumentException("Empty mapping of SOML object to SHACL!"));
    }

    public void setShaclTargetNodes(List<ShaclTargetNode> shaclTargetNodes) {
        this.shaclTargetNodes = shaclTargetNodes;
    }

    public void addShaclNode(ShaclTargetNode shaclTargetNode) {
        this.shaclTargetNodes.add(shaclTargetNode);
    }

    public String toTurtle() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.specialPrefixes.toTurtle());
        builder.append(this.prefixes.toTurtle()).append("\n");
        for (ShaclTargetNode node : this.shaclTargetNodes) {
            builder.append(node.toTurtle());
        }
        return builder.toString();
    }

    public static String dropLeadingUnderscore(String name) {
        if (name.startsWith("_")) {
            return name.substring(1);
        }
        return name;
    }

    public Boolean isEnabledAtTransactionLevel() {
        return this.enabledAtTransactionLevel;
    }

    public void setEnabledAtTransactionLevel(Boolean enabledAtTransactionLevel) {
        this.enabledAtTransactionLevel = enabledAtTransactionLevel;
    }

    public void setOperatingInCluster(Boolean operatingInCluster) {
        this.operatingInCluster = operatingInCluster;
    }

    public Boolean isOperatingInCluster() {
        return (Boolean)ObjectsUtil.getOrDefault((Object)this.operatingInCluster, (Object)Boolean.TRUE);
    }
}

