/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.ShaclTargetNode;
import com.ontotext.models.shacl.ConstraintContext;
import com.ontotext.models.shacl.Or;
import com.ontotext.models.shacl.Path;
import com.ontotext.models.shacl.ShaclConstraint;
import com.ontotext.models.shacl.ShaclNode;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ShaclProperty {
    private final ShaclTargetNode containedIn;
    private final PropertyShape targetProp;
    private final List<ShaclNode> constraints = new LinkedList<ShaclNode>();
    private final Map<String, Or> unionConstraints = new HashMap<String, Or>();
    private Path path;

    public ShaclProperty(ShaclTargetNode containedIn, PropertyShape targetProp) {
        this.containedIn = containedIn;
        this.targetProp = targetProp;
        containedIn.addPropertyShape(this);
    }

    public ShaclTargetNode getContainedIn() {
        return this.containedIn;
    }

    public PropertyShape getTargetProp() {
        return this.targetProp;
    }

    public ShaclNode getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = new Path(path);
    }

    public List<ShaclNode> getConstraints() {
        return this.constraints;
    }

    public ShaclNode getConstraint(String name) {
        return this.constraints.stream().filter(constraint -> constraint.getName().equals(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("SHACL constraint for non-existent name!"));
    }

    public void addConstraint(ShaclConstraint constraint, ConstraintContext context) {
        ShaclNode newNode = constraint.getBuilder().apply(context);
        if (null == newNode) {
            return;
        }
        Optional<ShaclNode> oldNode = this.constraints.stream().filter(old -> old.getName().equals(newNode.getName())).findFirst();
        if (oldNode.isPresent() || this.unionConstraints.containsKey(newNode.getName())) {
            this.unionConstraints.computeIfAbsent(newNode.getName(), val -> new Or((ShaclNode)oldNode.orElseThrow(IllegalArgumentException::new))).appendToNodes(newNode);
            this.constraints.removeIf(oldConst -> oldConst.getName().equals(newNode.getName()));
        } else {
            this.constraints.add(constraint.getBuilder().apply(context));
        }
    }

    public String toTurtle() {
        StringBuilder builder = new StringBuilder();
        builder.append("\tsh:property [\n");
        builder.append("\t\t").append(this.path.toTurtle()).append("\n");
        for (ShaclNode constraint2 : this.constraints) {
            if (constraint2 == null || constraint2.getValue() == null) continue;
            builder.append("\t\t").append(constraint2.toTurtle()).append("\n");
        }
        this.unionConstraints.values().stream().filter(constraint -> constraint.getValue() != null).forEach(constraint -> builder.append("\t\t").append(constraint.toTurtle()).append("\n"));
        builder.append("\t]");
        return builder.toString();
    }
}

