/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.Constraint;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class SelectableConstraints {
    private final Set<Constraint> fragmentConstraints = new LinkedHashSet<Constraint>();
    private final Set<Constraint> typeConstraints = new LinkedHashSet<Constraint>();

    public boolean hasFragmentConstraints() {
        return !this.fragmentConstraints.isEmpty();
    }

    public boolean hasTypeConstraints() {
        return !this.typeConstraints.isEmpty();
    }

    public boolean isEmpty() {
        return !this.hasFragmentConstraints() && !this.hasTypeConstraints();
    }

    public Set<Constraint> getFragmentConstraints() {
        return this.fragmentConstraints;
    }

    public Set<Constraint> getTypeConstraints() {
        return this.typeConstraints;
    }

    public void addFragmentConstraints(Collection<Constraint> fragmentConstraints) {
        this.fragmentConstraints.addAll(fragmentConstraints);
    }

    public void addTypeConstraints(Collection<Constraint> typeConstraints) {
        this.typeConstraints.addAll(typeConstraints);
    }

    public SelectableConstraints deepCopy() {
        SelectableConstraints copy = new SelectableConstraints();
        copy.addFragmentConstraints(this.getFragmentConstraints());
        copy.addTypeConstraints(this.getTypeConstraints());
        return copy;
    }
}

