/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.Constraint;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationType;
import com.ontotext.models.OperationVisitor;
import com.ontotext.models.OperationVisitorContext;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.SelectableConstraints;
import com.ontotext.models.Shape;
import com.ontotext.models.query.Arguments;
import com.ontotext.models.query.SourceLocation;
import com.ontotext.models.query.Variables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public interface Selectable {
    public String getName();

    default public String getNameIri() {
        Shape shape = Objects.requireNonNull(this.getDefinedInType(), "DefinedInType not initialized");
        Prefixes prefixes = shape.getContainedIn().getContainedIn().getPrefixes();
        return prefixes.toIri(prefixes.nameToShortIri(this.getName()));
    }

    default public String getNameShortIri() {
        Shape shape = Objects.requireNonNull(this.getDefinedInType(), "DefinedInType not initialized");
        Prefixes prefixes = shape.getContainedIn().getContainedIn().getPrefixes();
        return prefixes.nameToShortIri(this.getName());
    }

    public String getAlias();

    default public String getResponseName() {
        return Objects.toString(this.getAlias(), this.getName());
    }

    default public String getResponseNameIri() {
        Shape shape = Objects.requireNonNull(this.getDefinedInType(), "DefinedInType not initialized");
        Prefixes prefixes = shape.getContainedIn().getContainedIn().getPrefixes();
        return prefixes.toIri(prefixes.nameToShortIri(this.getResponseName()));
    }

    public String getType();

    public SelectableConstraints getConstraints();

    public void setConstraints(SelectableConstraints var1);

    default public boolean hasConstraints() {
        return this.getConstraints() != null && !this.getConstraints().isEmpty();
    }

    default public void addFragmentConstraints(Collection<Constraint> constraints) {
        if (!this.hasConstraints()) {
            this.setConstraints(new SelectableConstraints());
        }
        this.getConstraints().addFragmentConstraints(constraints);
    }

    default public void addTypeConstraints(Collection<Constraint> constraints) {
        if (!this.hasConstraints()) {
            this.setConstraints(new SelectableConstraints());
        }
        this.getConstraints().addTypeConstraints(constraints);
    }

    public String getDefinedIn();

    public Shape getDefinedInType();

    public List<Shape> getDomainConstraints();

    default public boolean hasDomainConstraints() {
        return !this.getDomainConstraints().isEmpty();
    }

    public Optional<PropertyShape> getProperty();

    public Optional<Shape> getShapeType();

    public boolean isCollection();

    public boolean isNonNullable();

    public boolean isNonNullableElements();

    default public boolean isRestrictive() {
        return this.getProperty().filter(PropertyShape::isRestrictive).isPresent();
    }

    public <E extends Selectable> List<E> getSelections();

    public <E extends Selectable> List<E> getWhereSelections();

    public Selectable getParent();

    public Arguments getArguments();

    default public Variables getVariables() {
        Selectable current = this;
        while (current.getParent() != null) {
            current = current.getParent();
        }
        if (current == this) {
            return new Variables();
        }
        return current.getVariables();
    }

    public boolean isComplexType();

    default public boolean isSelectionConsideredSingleValued() {
        if (this.isComplexType()) {
            if ("name".equals(this.getName()) && this.getParent().getShapeType().filter(shape -> shape.getNameIri() != null).map(shape -> shape.getProperty(shape.getNameIri()).filter(PropertyShape::isLiteral)).isPresent()) {
                return false;
            }
            if (this.getProperty().filter(PropertyShape::isLiteral).isPresent()) {
                return false;
            }
            return !this.isCollection() && this.getSelections().stream().allMatch(sel -> sel.isSelectionConsideredSingleValued() && !sel.hasConstraints());
        }
        return !this.isCollection();
    }

    public SourceLocation getLocation();

    public boolean isRangeCheck();

    public boolean isRequestedByUser();

    default public boolean isIgnored() {
        return false;
    }

    default public boolean isQueryable() {
        return true;
    }

    default public boolean isTreeQueryable() {
        if (this.getSelections().isEmpty()) {
            return this.isQueryable();
        }
        return this.isQueryable() || this.getSelections().stream().anyMatch(Selectable::isTreeQueryable);
    }

    default public boolean isPassThrough() {
        return false;
    }

    default public boolean isSubscription() {
        Selectable root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        if (root instanceof Operation) {
            return ((Operation)root).getOperationType() == OperationType.SUBSCRIPTION;
        }
        return false;
    }

    default public boolean isCountSelection() {
        return this.getName().endsWith("_count") && !this.getName().equals("affected_count") && this.getProperty().filter(PropertyShape::isGenerated).isPresent();
    }

    default public Optional<Selectable> getCountedSelection() {
        if (this.getParent() != null && this.isCountSelection()) {
            String property = this.getName().substring(0, this.getName().length() - "_count".length());
            return this.getParent().getSelections().stream().filter(Selectable.byName(property)).filter(selectable -> !selectable.isRequestedByUser()).findFirst().or(() -> this.getParent().getSelections().stream().filter(Selectable.byName(property)).findFirst());
        }
        return Optional.empty();
    }

    default public String getPath() {
        return this.getPath("/");
    }

    default public String getPath(String separator) {
        if (this.getParent() == null) {
            return this.getResponseName();
        }
        return this.getParent().getPath() + separator + this.getResponseName();
    }

    public boolean isInFragment();

    default public String getService() {
        return null;
    }

    public <R, Q extends OperationVisitorContext> R accept(OperationVisitor<R, Q> var1, Q var2);

    public static Predicate<Selectable> byName(String otherName) {
        return selectable -> selectable.getName().equals(otherName);
    }

    public static Predicate<Selectable> byNameOrAlias(String otherName) {
        return selectable -> selectable.getName().equals(otherName) || Objects.equals(selectable.getAlias(), otherName);
    }

    public static Predicate<Selectable> byNameAndParentType(String name, String type) {
        return selectable -> {
            if (selectable.getDefinedInType() == null) {
                return Objects.equals(selectable.getName(), name);
            }
            return Objects.equals(selectable.getName(), name) && Objects.equals(selectable.getDefinedInType().getId(), type);
        };
    }
}

