/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ContainedIn;
import com.ontotext.models.EnumValueDef;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.ModelTracker;
import com.ontotext.models.Prefixes;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import com.ontotext.soaas.common.CollectionsUtil;
import com.ontotext.soaas.common.StringManipulation;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ScalarType
implements TrackedModel,
YamlRepresentable,
ContainedIn<ScalarTypes> {
    public static final String UNION_FIELD = "union";
    public static final String DESCR_FIELD = "descr";
    public static final String GRAPHQL_EXTENSION_FIELD = "graphqlExtension";
    public static final String GRAPHQL_FIELD = "graphql";
    public static final String RDF_FIELD = "rdf";
    public static final String SCOPE_NOTE_FIELD = "scopeNote";
    public static final String VALUES_FIELD = "values";
    private String name;
    private String rdf;
    private String graphql;
    private List<String> union;
    private List<ScalarType> unionTypes;
    private String descr;
    private Boolean graphqlExtension;
    private String scopeNote;
    private ScalarTypes containedIn;
    private List<EnumValueDef> values;
    private ModelTracker tracker = ModelTracker.notTracked();

    public ScalarType() {
        this.tracker = ModelTracker.tracked();
    }

    public ScalarType(boolean flag) {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isUnionType() {
        return !this.unionTypes.isEmpty();
    }

    public List<String> getUnion() {
        return this.union;
    }

    public void setUnion(List<String> union) {
        this.union = union;
        this.tracker.trackValue(UNION_FIELD, union);
    }

    public List<ScalarType> getUnionTypes() {
        return this.unionTypes;
    }

    public String getDescr() {
        return this.descr;
    }

    public void setDescr(String descr) {
        this.descr = descr;
        this.tracker.trackValue(DESCR_FIELD, descr);
    }

    public Boolean isGraphqlExtension() {
        return this.graphqlExtension;
    }

    public void setGraphqlExtension(Boolean graphqlExtension) {
        this.graphqlExtension = graphqlExtension;
        this.tracker.trackValue(GRAPHQL_EXTENSION_FIELD, graphqlExtension);
    }

    public String getGraphql() {
        return this.graphql;
    }

    public void setGraphql(String graphql) {
        this.graphql = graphql;
        this.tracker.trackValue(GRAPHQL_FIELD, graphql);
    }

    public String getRdf() {
        return this.rdf;
    }

    public void setRdf(String rdf) {
        this.rdf = rdf;
        this.tracker.trackValue(RDF_FIELD, rdf);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ScalarType)) {
            return false;
        }
        ScalarType that = (ScalarType)obj;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getRdf(), that.getRdf()) && Objects.equals(this.getGraphql(), that.getGraphql()) && Objects.equals(this.isGraphqlExtension(), that.isGraphqlExtension()) && Objects.equals(this.getUnion(), that.getUnion()) && Objects.equals(this.getDescr(), that.getDescr()) && Objects.equals(this.getScopeNote(), that.getScopeNote()) && Objects.equals(this.getValues(), that.getValues());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getRdf(), this.getGraphql(), this.getUnion(), this.getDescr(), this.isGraphqlExtension(), this.getScopeNote(), this.getValues());
    }

    public String toString() {
        return "ScalarType [name=" + this.name + ", rdf=" + this.rdf + ", graphql=" + this.graphql + ", union=" + this.union + ", descr=" + this.descr + ", graphqlExtension=" + this.graphqlExtension + ", scopeNote=" + this.scopeNote + ", values=" + this.values + "]";
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        int printLevel = 3;
        return new YamlPrinter(configuration).newLine().addString(RDF_FIELD, this.rdf, 3, this.tracker::isTracked).addString(GRAPHQL_FIELD, this.graphql, 3, this.tracker::isTracked).addArray(UNION_FIELD, this.union, 3, this.tracker::isTracked).addString(DESCR_FIELD, this.descr, 3, this.tracker::isTracked).addString(GRAPHQL_EXTENSION_FIELD, this.graphqlExtension, 3, this.tracker::isTracked).addString(SCOPE_NOTE_FIELD, this.scopeNote, 3, this.tracker::isTracked).addArray(VALUES_FIELD, this.values, 3, this.tracker::isTracked).asString();
    }

    public String getScopeNote() {
        return this.scopeNote;
    }

    public void setScopeNote(String scopeNote) {
        this.scopeNote = scopeNote;
        this.tracker.trackValue(SCOPE_NOTE_FIELD, scopeNote);
    }

    public boolean is(String typename) {
        return Objects.equals(this.getName(), typename);
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
        if (this.values != null) {
            this.values.forEach(TrackedModel::startTracking);
        }
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
        if (this.values != null) {
            this.values.forEach(TrackedModel::stopTracking);
        }
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
        if (this.values != null) {
            this.values.forEach(TrackedModel::clearTrackedInformation);
        }
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId);
    }

    public void setContainedIn(ScalarTypes containedIn) {
        this.containedIn = containedIn;
    }

    @Override
    public ScalarTypes getContainedIn() {
        return this.containedIn;
    }

    public void expand() {
        this.unionTypes = this.union != null && !this.union.isEmpty() ? Collections.unmodifiableList(this.union.stream().map(this.getContainedIn()::get).filter(Objects::nonNull).collect(Collectors.toList())) : Collections.emptyList();
        if (this.isEnum()) {
            int idx = 0;
            for (EnumValueDef value : this.getValues()) {
                value.expand(this, idx++);
            }
            if (this.getRdf() == null) {
                this.resolveRdfEnumType();
            }
            if (this.getGraphql() == null) {
                this.setGraphql(StringUtils.capitalize((String)StringManipulation.replaceColonWithUnderscore((String)this.name)));
            }
        }
    }

    private void resolveRdfEnumType() {
        List<Object> enumValues = this.getValues().stream().filter(def -> def.isTracked("value")).map(EnumValueDef::getValue).collect(Collectors.toList());
        if (enumValues.isEmpty()) {
            this.setRdf("xsd:string");
            return;
        }
        Set valueTypes = enumValues.stream().map(Object::getClass).collect(Collectors.toSet());
        if (valueTypes.size() == 1) {
            if (valueTypes.contains(Integer.class)) {
                this.setRdf("xsd:int");
                return;
            }
            if (valueTypes.contains(String.class)) {
                this.checkStringEnumValues(enumValues);
                return;
            }
        } else {
            for (EnumValueDef valueDef : this.getValues()) {
                if (valueDef.getValue() == null) continue;
                valueDef.setValue(Objects.toString(valueDef.getValue()));
            }
        }
        this.setRdf("xsd:string");
    }

    private void checkStringEnumValues(List<Object> enumValues) {
        Prefixes prefixes = this.getContainedIn().getContainedIn().getPrefixes();
        try {
            for (Object value : enumValues) {
                prefixes.toIri(value.toString());
            }
            this.setRdf("rdfs:Resource");
            this.expand();
        }
        catch (InvalidSchemaException ise) {
            this.setRdf("xsd:string");
        }
    }

    public boolean treatedAsString() {
        return this.is("string") || this.isLangStringSupported() || this.is("iri");
    }

    public boolean isLangStringSupported() {
        return this.isLangStringExclusive() || this.isUnionType() && this.getUnionTypes().stream().map(ScalarType::getRdf).anyMatch(Predicate.isEqual("rdf:langString"));
    }

    public boolean isLangStringExclusive() {
        return "rdf:langString".equals(this.getRdf());
    }

    public List<EnumValueDef> getValues() {
        return this.values;
    }

    public void setValues(List<EnumValueDef> values) {
        this.tracker.trackValue(VALUES_FIELD, values);
        this.values = values;
    }

    public boolean isEnum() {
        return CollectionsUtil.isNotNullOrEmpty(this.getValues());
    }
}

