/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ContainedIn;
import com.ontotext.models.ModelTracker;
import com.ontotext.models.Rbac;
import com.ontotext.models.Role;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;

public class Roles
extends TreeMap<String, Role>
implements ContainedIn<Rbac>,
TrackedModel,
YamlRepresentable {
    public static final String ROLES_FIELD = "roles";
    private transient Rbac rbac;
    private transient ModelTracker tracker = ModelTracker.notTracked();

    public Roles() {
        this.tracker = ModelTracker.tracked();
    }

    public Roles(boolean flag) {
    }

    public void setContainedIn(Rbac rbac) {
        this.rbac = rbac;
    }

    @Override
    public Role put(String key, Role value) {
        key = Objects.toString(key);
        this.tracker.trackModelEntry(key);
        return super.put(key, value);
    }

    @Override
    public Role putIfAbsent(String key, Role value) {
        key = Objects.toString(key);
        this.tracker.trackModelEntry(key);
        return super.putIfAbsent(key, value);
    }

    @Override
    public Role computeIfAbsent(String key, Function<? super String, ? extends Role> mappingFunction) {
        key = Objects.toString(key);
        this.tracker.trackModelEntry(key);
        return super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    public Rbac getContainedIn() {
        return this.rbac;
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        YamlPrinter printer = new YamlPrinter(configuration).addField(ROLES_FIELD, 2);
        this.forEach((key, role) -> {
            if (this.isTracked((String)key)) {
                printer.addField((String)key, 3);
                printer.addYaml((YamlRepresentable)role);
            }
        });
        return printer.asString();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof Roles && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
    }

    @Override
    public boolean isTracked(String role) {
        return this.tracker.isTracked(role);
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
    }

    public Optional<Role> getDefaultRole() {
        if (this.rbac == null) {
            return Optional.ofNullable((Role)this.get("Default"));
        }
        return this.rbac.getContainedIn().getConfig().getDefaultRole().map(this::get).or(() -> Optional.ofNullable((Role)this.get("Default")));
    }
}

