/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ContainedIn;
import com.ontotext.models.RoleAction;
import com.ontotext.models.Roles;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Role
implements ContainedIn<Roles>,
YamlRepresentable {
    public static final String DESCRIPTION_FIELD = "description";
    public static final String ACTIONS_FIELD = "actions";
    public static final String NOT_ACTIONS_FIELD = "notActions";
    private String name;
    private String description;
    private List<RoleAction> actions;
    private List<RoleAction> notActions;
    private final boolean synthetic;
    private Roles roles;

    public Role() {
        this(false);
    }

    public Role(boolean synthetic) {
        this.synthetic = synthetic;
    }

    public void expand(Roles roles) {
        this.roles = roles;
        if (this.actions == null) {
            this.actions = new ArrayList<RoleAction>();
        }
        if (this.notActions == null) {
            this.notActions = new ArrayList<RoleAction>();
        }
        this.actions.forEach(action -> action.setContainedIn(this));
        this.notActions.forEach(action -> action.setContainedIn(this));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<RoleAction> getActions() {
        return this.actions;
    }

    public void setActions(List<RoleAction> actions) {
        this.actions = actions;
    }

    public List<RoleAction> getNotActions() {
        return this.notActions;
    }

    public void setNotActions(List<RoleAction> notActions) {
        this.notActions = notActions;
    }

    public boolean isSynthetic() {
        return this.synthetic;
    }

    @Override
    public Roles getContainedIn() {
        return this.roles;
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        return new YamlPrinter(configuration).addString(DESCRIPTION_FIELD, this.description, 4).addArray(ACTIONS_FIELD, this.actions, 4).addArray(NOT_ACTIONS_FIELD, this.notActions, 4).asString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Role role = (Role)obj;
        return Objects.equals(this.name, role.name) && Objects.equals(this.description, role.description) && Objects.equals(this.actions, role.actions) && Objects.equals(this.notActions, role.notActions);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.actions, this.notActions);
    }

    public String toString() {
        return "Role{" + "name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", actions=" + this.actions + ", notActions=" + this.notActions + '}';
    }
}

