/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ContainedIn;
import com.ontotext.models.RoleAction;
import com.ontotext.models.Roles;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.sanitizing.Sanitizable;
import com.ontotext.models.sanitizing.SchemaSanitizerUtils;
import com.ontotext.models.security.RbacRestrictions;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Rbac
implements ContainedIn<SomlSchema>,
YamlRepresentable,
Sanitizable {
    public static final String SCHEMA_ID = "/soml/soml-rbac";
    public static final String SCHEMA_RBAC_ADMIN_ROLE = "SchemaRBACAdmin";
    public static final String DEFAULT_ROLE = "Default";
    public static final String RBAC_FIELD = "rbac";
    private Roles roles;
    private RbacRestrictions restrictions = new RbacRestrictions();
    private SomlSchema somlSchema;

    public Roles getRoles() {
        return this.roles;
    }

    public void setRoles(Roles roles) {
        this.roles = roles;
    }

    public RbacRestrictions getRestrictions() {
        return this.restrictions;
    }

    void expand(SomlSchema somlSchema) {
        this.somlSchema = somlSchema;
        if (this.roles == null) {
            this.roles = new Roles(true);
        }
        this.roles.setContainedIn(this);
        this.getRoles().forEach((roleName, role) -> {
            if (role != null) {
                role.setName((String)roleName);
                role.expand(this.roles);
            }
        });
    }

    @Override
    public SomlSchema getContainedIn() {
        return this.somlSchema;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Rbac rbac = (Rbac)obj;
        return Objects.equals(this.roles, rbac.roles);
    }

    public int hashCode() {
        return Objects.hash(this.roles);
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        if (this.roles == null || this.roles.isEmpty()) {
            return "";
        }
        return new YamlPrinter(configuration).newLine().addField(RBAC_FIELD, 1).addYaml(this.roles).asString();
    }

    public String toString() {
        return "RBAC{" + "roles=" + this.roles + '}';
    }

    @Override
    public void sanitize(Sanitizable.Context context) {
        Map<String, String> propertiesNames = this.remapProperties(context.getOrCreateSanitizedPropertiesNames());
        this.roles.values().stream().filter(Objects::nonNull).forEach(role -> {
            this.replaceIfNotNull(role.getActions(), propertiesNames);
            this.replaceIfNotNull(role.getNotActions(), propertiesNames);
        });
    }

    private Map<String, String> remapProperties(Map<String, String> sanitizedPropertiesMap) {
        HashMap<String, String> remapped = new HashMap<String, String>(sanitizedPropertiesMap.size());
        sanitizedPropertiesMap.forEach((key, value) -> remapped.put(key + ":", value + ":"));
        return remapped;
    }

    private void replaceIfNotNull(List<RoleAction> actions, Map<String, String> propertiesNames) {
        if (actions == null) {
            return;
        }
        actions.replaceAll(action -> {
            String sanitizedAction;
            String actionStr = action.getAction();
            if (StringUtils.isNotBlank((CharSequence)actionStr) && !actionStr.equals(sanitizedAction = this.sanitizeAction(actionStr, propertiesNames))) {
                return new RoleAction(sanitizedAction);
            }
            return action;
        });
    }

    private String sanitizeAction(String actionStr, Map<String, String> propertiesNames) {
        String[] actionParts = actionStr.split("/", 4);
        if (!actionStr.contains("where:")) {
            if (actionParts.length == 4) {
                return actionStr;
            }
            return SchemaSanitizerUtils.sanitizeValue(actionStr);
        }
        if (actionParts.length != 4) {
            return actionStr;
        }
        String objectId = actionParts[0];
        String property = actionParts[1];
        String action = actionParts[2];
        String filter = actionParts[3];
        return String.join((CharSequence)"/", SchemaSanitizerUtils.sanitizeValue(objectId), SchemaSanitizerUtils.sanitizeValue(property), action, this.sanitizeFilter(filter, propertiesNames));
    }

    private String sanitizeFilter(String filter, Map<String, String> propertiesNames) {
        String newFilter = filter;
        for (Map.Entry<String, String> entry : propertiesNames.entrySet()) {
            String property = entry.getKey();
            if (!filter.contains(property)) continue;
            newFilter = newFilter.replaceAll(property, entry.getValue());
        }
        return newFilter;
    }
}

