/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ContainedIn;
import com.ontotext.models.LangConfig;
import com.ontotext.models.ModelTracker;
import com.ontotext.models.Properties;
import com.ontotext.models.PropertiesDefaultValues;
import com.ontotext.models.ScalarType;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.sanitizing.Sanitizable;
import com.ontotext.models.sanitizing.SchemaSanitizerUtils;
import com.ontotext.models.search.SearchConfig;
import com.ontotext.models.templates.Template;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import com.ontotext.soaas.common.ObjectsUtil;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.soaas.common.StringManipulation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class PropertyShape
implements ContainedIn<Properties>,
TrackedModel,
YamlRepresentable,
Sanitizable {
    public static final String LABEL_FIELD = "label";
    public static final String INVERSE_OF_FIELD = "inverseOf";
    public static final String INVERSE_ALIAS_FIELD = "inverseAlias";
    public static final String PREFIX_FIELD = "prefix";
    public static final String REGEX_FIELD = "regex";
    public static final String PATTERN_FIELD = "pattern";
    public static final String DESCR_FIELD = "descr";
    public static final String NAME_FIELD = "name";
    public static final String RANGE_FIELD = "range";
    public static final String RANGE_CHECK_FIELD = "rangeCheck";
    public static final String SYMMETRIC_FIELD = "symmetric";
    public static final String MAX_FIELD = "max";
    public static final String MIN_FIELD = "min";
    public static final String TYPE_CAST_FIELD = "typeCast";
    public static final String KIND_FIELD = "kind";
    public static final String RDF_PROP_FIELD = "rdfProp";
    public static final String GEN_FIELD = "gen";
    public static final String EXTERNAL_FIELD = "external";
    public static final String LANG_FIELD = "lang";
    public static final String MAX_LENGTH_FIELD = "maxLength";
    public static final String MIN_LENGTH_FIELD = "minLength";
    public static final String MAX_INCLUSIVE_FIELD = "maxInclusive";
    public static final String MIN_INCLUSIVE_FIELD = "minInclusive";
    public static final String MAX_EXCLUSIVE_FIELD = "maxExclusive";
    public static final String MIN_EXCLUSIVE_FIELD = "minExclusive";
    public static final String VALUES_IN_FIELD = "valuesIn";
    public static final String VALUES_LIST_EXCLUSIVE = "valuesListExclusive";
    public static final String EQUALS_FIELD = "equals";
    public static final String VALIDATION_IGNORED_FIELD = "validationIgnored";
    public static final String NON_NULLABLE = "nonNullable";
    public static final String NON_NULLABLE_ELEMENTS = "nonNullableElements";
    public static final String READ_ONLY_FIELD = "readOnly";
    public static final String FILTERED_FIELD = "filtered";
    public static final String ORDERED_FIELD = "ordered";
    public static final String SEARCH_FIELD = "search";
    public static final String SCALE_FACTOR_FIELD = "scaleFactor";
    public static final String RESTRICTIVE_FIELD = "restrictive";
    public static final String META_FIELD = "meta";
    private String name;
    private String label;
    private String gen;
    private String kind;
    private String range;
    private Boolean rangeCheck;
    private Boolean typeCast;
    private Integer min;
    private String max;
    private Integer maxValue;
    private String inverseOf;
    private String inverseAlias;
    private Boolean symmetric;
    private String prefix;
    private String regex;
    private Object pattern;
    private String descr;
    private String rdfProp;
    private boolean absoluteRdfPropValue;
    private String inverseProperty;
    private Boolean hasCovariant;
    private Boolean external;
    private LangConfig lang;
    private Integer maxLength;
    private Integer minLength;
    private Object minInclusive;
    private Object maxInclusive;
    private Object minExclusive;
    private Object maxExclusive;
    private List<Object> valuesIn;
    private Boolean valuesListExclusive;
    private String equals;
    private Boolean validationIgnored;
    private Boolean readOnly;
    private Boolean filtered;
    private Boolean ordered;
    private Boolean nonNullable;
    private Boolean nonNullableElements;
    private SearchConfig search;
    private Double scaleFactor;
    private Map<String, Object> meta = Collections.emptyMap();
    private ScalarType scalarType;
    private Properties containedIn;
    private ModelTracker tracker = ModelTracker.notTracked();
    private Template template;
    private Boolean restrictive;
    private String graphqlId;
    private boolean generated;

    public PropertyShape() {
        this.tracker = ModelTracker.tracked();
    }

    public PropertyShape(boolean flag) {
    }

    public static PropertyShape create(String name, String range, Integer min, String max) {
        PropertyShape property = new PropertyShape(true);
        property.setName(name);
        property.setRange(range);
        property.setMin(min);
        property.setMax(max);
        property.setDefaults();
        return property;
    }

    public PropertyShape copy() {
        PropertyShape clone = new PropertyShape();
        clone.name = this.name;
        clone.label = this.label;
        clone.gen = this.gen;
        clone.kind = this.kind;
        clone.range = this.range;
        clone.rangeCheck = this.rangeCheck;
        clone.typeCast = this.typeCast;
        clone.min = this.min;
        clone.max = this.max;
        clone.maxValue = this.maxValue;
        clone.inverseOf = this.inverseOf;
        clone.inverseAlias = this.inverseAlias;
        clone.symmetric = this.symmetric;
        clone.prefix = this.prefix;
        clone.regex = this.regex;
        clone.pattern = this.pattern;
        clone.descr = this.descr;
        clone.rdfProp = this.rdfProp;
        clone.absoluteRdfPropValue = this.absoluteRdfPropValue;
        clone.template = this.template;
        clone.inverseProperty = this.inverseProperty;
        clone.hasCovariant = this.hasCovariant;
        clone.scalarType = this.scalarType;
        clone.containedIn = this.containedIn;
        clone.external = this.external;
        clone.tracker = this.tracker;
        clone.lang = LangConfig.parse(this.lang);
        clone.lang = this.lang;
        clone.maxLength = this.maxLength;
        clone.minLength = this.minLength;
        clone.minInclusive = this.minInclusive;
        clone.maxInclusive = this.maxInclusive;
        clone.minExclusive = this.minExclusive;
        clone.maxExclusive = this.maxExclusive;
        clone.valuesIn = this.valuesIn;
        clone.valuesListExclusive = this.valuesListExclusive;
        clone.equals = this.equals;
        clone.validationIgnored = this.validationIgnored;
        clone.nonNullable = this.nonNullable;
        clone.nonNullableElements = this.nonNullableElements;
        clone.restrictive = this.restrictive;
        clone.readOnly = this.readOnly;
        clone.filtered = this.filtered;
        clone.generated = this.generated;
        clone.ordered = this.ordered;
        if (this.search != null) {
            clone.search = new SearchConfig(this.search);
        }
        clone.scaleFactor = this.scaleFactor;
        if (this.meta != null) {
            clone.meta = new HashMap<String, Object>(this.meta);
        }
        return clone;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
        this.tracker.trackValue(LABEL_FIELD, label);
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
        this.tracker.trackValue(KIND_FIELD, kind);
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
        this.tracker.trackValue(MIN_FIELD, min);
    }

    public String getMax() {
        return this.max;
    }

    public boolean isUnbounded() {
        return "inf".equalsIgnoreCase(this.getMax());
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMax(String max) {
        this.max = max;
        this.tracker.trackValue(MAX_FIELD, max);
        if (max != null) {
            if (this.isUnbounded()) {
                this.maxValue = Integer.MAX_VALUE;
            } else {
                try {
                    this.maxValue = Integer.parseInt(this.getMax());
                }
                catch (NumberFormatException nfe) {
                    this.maxValue = null;
                }
            }
        } else {
            this.maxValue = null;
        }
    }

    public String getInverseOf() {
        return this.inverseOf;
    }

    public void setInverseOf(String inverseOf) {
        this.inverseOf = inverseOf;
        this.tracker.trackValue(INVERSE_OF_FIELD, inverseOf);
    }

    public String getInverseAlias() {
        return this.inverseAlias;
    }

    public void setInverseAlias(String inverseAlias) {
        this.inverseAlias = inverseAlias;
        this.tracker.trackValue(INVERSE_ALIAS_FIELD, inverseAlias);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this.tracker.trackValue(PREFIX_FIELD, prefix);
    }

    public Object getPattern() {
        return this.pattern;
    }

    @Nullable
    public String getPatternString() {
        if (this.pattern instanceof List && !((List)this.pattern).isEmpty()) {
            return (String)((List)this.pattern).get(0);
        }
        if (!(this.pattern instanceof List) && null != this.pattern) {
            return (String)this.pattern;
        }
        return this.regex;
    }

    public Object getPatternAndFlags() {
        if (this.pattern instanceof List && ((List)this.pattern).size() == 1) {
            return ((List)this.pattern).get(0);
        }
        if (null != this.pattern) {
            if (this.pattern instanceof List && !((List)this.pattern).isEmpty()) {
                return this.pattern;
            }
            return this.regex;
        }
        return this.regex;
    }

    public void setPattern(Object pattern) {
        if (pattern instanceof List) {
            this.pattern = pattern;
        } else if (pattern instanceof String) {
            this.pattern = Collections.singletonList((String)pattern);
        } else if (null == pattern) {
            this.pattern = Collections.emptyList();
        } else {
            throw new IllegalArgumentException(String.format("The type of property %s is an illegal value: %s", PATTERN_FIELD, pattern));
        }
        this.tracker.trackValue(PATTERN_FIELD, pattern);
    }

    public String getDescr() {
        return this.descr;
    }

    public void setDescr(String descr) {
        this.descr = descr;
        this.tracker.trackValue(DESCR_FIELD, descr);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String asGraphQl() {
        if (this.graphqlId == null) {
            this.graphqlId = StringManipulation.toGraphQlModelName((String)this.getContainedIn().getContainedIn().getContainedIn().getContainedIn().getPrefixes().toName(this.getName()));
        }
        return this.graphqlId;
    }

    public void setAsGenerated() {
        this.generated = true;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public String getRange() {
        return this.range;
    }

    public Shape getRangeShape() {
        if (!this.isObjectType()) {
            return null;
        }
        Shapes shapes = this.getContainedIn().getContainedIn().getContainedIn();
        return (Shape)shapes.get(shapes.getContainedIn().getPrefixes().nameToShortIri(this.getRange()));
    }

    public void setRange(String range) {
        this.range = range;
        this.tracker.trackValue(RANGE_FIELD, range);
    }

    public Boolean getRangeCheck() {
        return this.rangeCheck;
    }

    public void setRangeCheck(Boolean rangeCheck) {
        this.rangeCheck = rangeCheck;
        this.tracker.trackValue(RANGE_CHECK_FIELD, rangeCheck);
    }

    public boolean isScalarType() {
        return this.scalarType != null;
    }

    public boolean isObjectType() {
        return this.scalarType == null;
    }

    public boolean isLiteral() {
        return this.isScalarType() && "Literal".equals(this.getScalarType().getGraphql()) || "Literal".equals(this.getRange());
    }

    public ScalarType getScalarType() {
        return this.scalarType;
    }

    public void setScalarType(ScalarType scalarType) {
        this.scalarType = scalarType;
    }

    public Boolean getSymmetric() {
        return this.symmetric;
    }

    public void setSymmetric(Boolean symmetric) {
        this.symmetric = symmetric;
        this.tracker.trackValue(SYMMETRIC_FIELD, symmetric);
    }

    public boolean isRequired() {
        return this.min != null && this.min == 1;
    }

    public boolean isSingleValued() {
        return this.getMaxValue() == null || this.getMaxValue() == 1;
    }

    public boolean isMultivalued() {
        return this.getMaxValue() != null && this.getMaxValue() > 1;
    }

    public String getGen() {
        return this.gen;
    }

    public void setGen(String gen) {
        this.gen = gen;
        this.tracker.trackValue(GEN_FIELD, gen);
    }

    public Boolean hasCovariant() {
        return this.hasCovariant;
    }

    public void setHasCovariant(Boolean hasCovariant) {
        this.hasCovariant = hasCovariant;
    }

    public Boolean getTypeCast() {
        return this.typeCast;
    }

    public void setTypeCast(Boolean typeCast) {
        this.typeCast = typeCast;
        this.tracker.trackValue(TYPE_CAST_FIELD, typeCast);
    }

    public Boolean getExternal() {
        return this.external;
    }

    public void setExternal(Boolean external) {
        this.external = external;
        this.tracker.trackValue(EXTERNAL_FIELD, external);
    }

    public String getRdfProp() {
        return this.rdfProp;
    }

    public String getAsAbsoluteRdfProp() {
        if (this.isAbsoluteRdfPropValue()) {
            return "<" + this.rdfProp + ">";
        }
        return this.rdfProp;
    }

    public void setRdfProp(String rdfProp) {
        if (rdfProp != null && rdfProp.startsWith("<") && rdfProp.endsWith(">")) {
            this.absoluteRdfPropValue = true;
            rdfProp = rdfProp.substring(1, rdfProp.length() - 1);
        }
        this.rdfProp = rdfProp;
        this.tracker.trackValue(RDF_PROP_FIELD, rdfProp);
    }

    public boolean isSparqlTemplate() {
        return SparqlUtil.isSparqlTemplate((String)this.rdfProp);
    }

    public boolean isAbsoluteRdfPropValue() {
        return this.absoluteRdfPropValue;
    }

    public boolean isTripleSelection() {
        return !this.isSparqlTemplate();
    }

    public LangConfig getLangConfig() {
        return this.lang;
    }

    public boolean isUniqueLang() {
        return this.lang != null && this.lang.getValidate() != null && this.lang.getValidate().contains("UNIQ");
    }

    public void setLang(Object lang) {
        this.lang = LangConfig.parse(lang);
        this.tracker.trackValue(LANG_FIELD, lang);
    }

    void copyLangConfigFrom(LangConfig copyFrom) {
        if (this.getLangConfig() == null) {
            this.setLang(copyFrom);
        } else {
            this.getLangConfig().merge(copyFrom);
        }
    }

    void mergeSearchConfig(SearchConfig other) {
        if (this.getSearch() == null) {
            this.setSearch(other);
        } else {
            this.getSearch().merge(other);
        }
    }

    public String getRdfProperty() {
        if (this.isSparqlTemplate()) {
            return this.getRdfProp();
        }
        if (this.isAbsoluteRdfPropValue()) {
            return this.getAsAbsoluteRdfProp();
        }
        return this.getContainedIn().getResolvedRdfProp(this.getContainedIn().getContainedIn(), this).orElse(this.getRdfPropertyInternal());
    }

    private String getRdfPropertyInternal() {
        if (this.containedIn == null || this.containedIn.getContainedIn() == null || this.containedIn.getContainedIn().getContainedIn() == null) {
            return this.getRdfProp();
        }
        SomlSchema schema = this.containedIn.getContainedIn().getContainedIn().getContainedIn();
        String rdfProperty = Objects.requireNonNull(Objects.toString(this.getRdfProp(), this.getName()), "Undefined name and prop");
        if (SparqlUtil.isSparqlTemplate((String)rdfProperty)) {
            return rdfProperty;
        }
        return schema.getPrefixes().toShortIri(rdfProperty);
    }

    public Optional<String> getInverseAliasProperty() {
        if (this.getInverseAlias() == null || this.isScalarType()) {
            return Optional.empty();
        }
        SomlSchema schema = this.containedIn.getContainedIn().getContainedIn().getContainedIn();
        Shape inverseRange = (Shape)schema.getObjects().get(this.getRange());
        if (inverseRange == null) {
            return Optional.empty();
        }
        PropertyShape inversePropertyShape = inverseRange.getProperty(this.getInverseAlias()).orElse(null);
        if (inversePropertyShape == null) {
            return Optional.empty();
        }
        String inverseRdf = inversePropertyShape.getRdfProperty();
        this.inverseProperty = SparqlUtil.isSparqlTemplate((String)inverseRdf) ? inverseRdf : schema.getPrefixes().toShortIri(inverseRdf);
        return Optional.of(this.inverseProperty);
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
        this.tracker.trackValue(META_FIELD, meta);
    }

    @Override
    public Properties getContainedIn() {
        return this.containedIn;
    }

    public void setContainedIn(Properties containedIn) {
        this.containedIn = containedIn;
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
        if (this.lang != null) {
            this.lang.startTracking();
        }
        if (this.search != null) {
            this.search.startTracking();
        }
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
        if (this.lang != null) {
            this.lang.stopTracking();
        }
        if (this.search != null) {
            this.search.stopTracking();
        }
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
        if (this.lang != null) {
            this.lang.clearTrackedInformation();
        }
        if (this.search != null) {
            this.search.clearTrackedInformation();
        }
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId);
    }

    public Set<String> getTrackedEntities() {
        return this.tracker.getTrackedEntities();
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        int propertyPrintLevel = 2;
        int characteristicsPrintLevel = 3;
        return new YamlPrinter(configuration).addField(this.getName(), 2).addString(LABEL_FIELD, this.label, 3, this.tracker::isTracked).addString(KIND_FIELD, this.kind, 3, this.tracker::isTracked).addString(GEN_FIELD, this.gen, 3, this.tracker::isTracked).addString(RANGE_FIELD, this.range, 3, this.tracker::isTracked).addString(RANGE_CHECK_FIELD, this.rangeCheck, 3, this.tracker::isTracked).addString(TYPE_CAST_FIELD, this.typeCast, 3, this.tracker::isTracked).addString(MIN_FIELD, this.min, 3, this.tracker::isTracked).addString(MAX_FIELD, this.max, 3, this.tracker::isTracked).addString(INVERSE_OF_FIELD, this.inverseOf, 3, this.tracker::isTracked).addString(INVERSE_ALIAS_FIELD, this.inverseAlias, 3, this.tracker::isTracked).addString(SYMMETRIC_FIELD, this.symmetric, 3, this.tracker::isTracked).addString(PREFIX_FIELD, this.prefix, 3, this.tracker::isTracked).addString(REGEX_FIELD, this.regex, 3, this.tracker::isTracked).addArray(PATTERN_FIELD, (Collection)this.pattern, 3, this.tracker::isTracked).addString(DESCR_FIELD, this.descr, 3, this.tracker::isTracked).addString(RDF_PROP_FIELD, this.getAsAbsoluteRdfProp(), 3, this.tracker::isTracked).addString(EXTERNAL_FIELD, this.external, 3, this.tracker::isTracked).addYaml(LANG_FIELD, this.lang, 3, this.tracker::isTracked).addString(MAX_LENGTH_FIELD, this.maxLength, 3, this.tracker::isTracked).addString(MIN_LENGTH_FIELD, this.minLength, 3, this.tracker::isTracked).addString(MIN_INCLUSIVE_FIELD, this.minInclusive, 3, this.tracker::isTracked).addString(MAX_INCLUSIVE_FIELD, this.maxInclusive, 3, this.tracker::isTracked).addString(MIN_EXCLUSIVE_FIELD, this.minExclusive, 3, this.tracker::isTracked).addString(MAX_EXCLUSIVE_FIELD, this.maxExclusive, 3, this.tracker::isTracked).addString(VALUES_IN_FIELD, this.valuesIn, 3, this.tracker::isTracked).addString(VALUES_LIST_EXCLUSIVE, this.valuesListExclusive, 3, this.tracker::isTracked).addString(EQUALS_FIELD, this.equals, 3, this.tracker::isTracked).addString(VALIDATION_IGNORED_FIELD, this.validationIgnored, 3, this.tracker::isTracked).addString(READ_ONLY_FIELD, this.readOnly, 3, this.tracker::isTracked).addString(FILTERED_FIELD, this.filtered, 3, this.tracker::isTracked).addString(ORDERED_FIELD, this.ordered, 3, this.tracker::isTracked).addString(NON_NULLABLE, this.nonNullable, 3, this.tracker::isTracked).addString(NON_NULLABLE_ELEMENTS, this.nonNullableElements, 3, this.tracker::isTracked).addString(RESTRICTIVE_FIELD, this.restrictive, 3, this.tracker::isTracked).addString(SEARCH_FIELD, this.search, 3, this.tracker::isTracked).addString(SCALE_FACTOR_FIELD, this.scaleFactor, 3, this.tracker::isTracked).addString(META_FIELD, this.meta, 3, this.tracker::isTracked).asString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyShape)) {
            return false;
        }
        PropertyShape that = (PropertyShape)obj;
        return Objects.equals(this.getMin(), that.getMin()) && Objects.equals(this.getSymmetric(), that.getSymmetric()) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getGen(), that.getGen()) && Objects.equals(this.getLabel(), that.getLabel()) && Objects.equals(this.getKind(), that.getKind()) && Objects.equals(this.getRange(), that.getRange()) && Objects.equals(this.getRangeCheck(), that.getRangeCheck()) && Objects.equals(this.getTypeCast(), that.getTypeCast()) && Objects.equals(this.getMax(), that.getMax()) && Objects.equals(this.getInverseOf(), that.getInverseOf()) && Objects.equals(this.getInverseAlias(), that.getInverseAlias()) && Objects.equals(this.getPrefix(), that.getPrefix()) && Objects.equals(this.getPattern(), that.getPattern()) && Objects.equals(this.getRdfProp(), that.getRdfProp()) && Objects.equals(this.getLangConfig(), that.getLangConfig()) && Objects.equals(this.getMaxLength(), that.getMaxLength()) && Objects.equals(this.getMinLength(), that.getMinLength()) && Objects.equals(this.getMinInclusive(), that.getMinInclusive()) && Objects.equals(this.getMaxInclusive(), that.getMaxInclusive()) && Objects.equals(this.getMinExclusive(), that.getMinExclusive()) && Objects.equals(this.getMaxExclusive(), that.getMaxExclusive()) && Objects.equals(this.getEquals(), that.getEquals()) && Objects.equals(this.getValuesIn(), that.getValuesIn()) && Objects.equals(this.isValuesListExclusive(), that.isValuesListExclusive()) && Objects.equals(this.getValidationIgnored(), that.getValidationIgnored()) && Objects.equals(this.isReadOnly(), that.isReadOnly()) && Objects.equals(this.getExternal(), that.getExternal()) && Objects.equals(this.isNonNullable(), that.isNonNullable()) && Objects.equals(this.isNonNullableElements(), that.isNonNullableElements()) && Objects.equals(this.isRestrictive(), that.isRestrictive()) && Objects.equals(this.getSearch(), that.getSearch()) && Objects.equals(this.getScaleFactor(), that.getScaleFactor()) && Objects.equals(this.getMeta(), that.getMeta());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getLabel(), this.getKind(), this.getGen(), this.getRange(), this.getRangeCheck(), this.getTypeCast(), this.getMin(), this.getMax(), this.getInverseOf(), this.getInverseAlias(), this.getSymmetric(), this.getPrefix(), this.getPattern(), this.getDescr(), this.getRdfProp(), this.getExternal(), this.getLangConfig(), this.getMaxLength(), this.getMinLength(), this.getMinInclusive(), this.getMaxInclusive(), this.getMinExclusive(), this.getMaxExclusive(), this.getValuesIn(), this.isValuesListExclusive(), this.getEquals(), this.isReadOnly(), this.getValidationIgnored(), this.isNonNullable(), this.isNonNullableElements(), this.isRestrictive(), this.getSearch(), this.getMeta());
    }

    public String toString() {
        return "PropertyShape [name=" + this.name + ", label=" + this.label + ", kind=" + this.kind + ", gen=" + this.gen + ", range=" + this.range + ", rangeCheck=" + this.rangeCheck + ", typeCast=" + this.typeCast + ", min=" + this.min + ", max=" + this.max + ", maxValue=" + this.maxValue + ", inverseOf=" + this.inverseOf + ", inverseAlias=" + this.inverseAlias + ", symmetric=" + this.symmetric + ", prefix=" + this.prefix + ", pattern=" + this.pattern + ", descr=" + this.descr + ", rdfProp=" + this.rdfProp + ", absoluteRdfPropValue=" + this.absoluteRdfPropValue + ", inverseProperty=" + this.inverseProperty + ", scalarType=" + this.scalarType + ", lang=" + this.lang + ", maxLength=" + this.maxLength + ", minLength=" + this.minLength + ", minInclusive=" + this.minInclusive + ", maxInclusive=" + this.maxInclusive + ", minExclusive=" + this.minExclusive + ", maxExclusive=" + this.maxExclusive + ", valuesIn=" + this.valuesIn + ", valuesListExclusive=" + this.valuesListExclusive + ", equals=" + this.equals + ", validationIgnored=" + this.validationIgnored + ", readOnly=" + this.readOnly + ", filtered=" + this.filtered + ", ordered=" + this.ordered + ", external=" + this.external + ", nonNullable=" + this.nonNullable + ", nonNullableElements=" + this.nonNullableElements + ", restrictive=" + this.restrictive + ", search=" + this.search + ", scaleFactor=" + this.scaleFactor + ", meta=" + this.meta + "]";
    }

    @Override
    public void sanitize(Sanitizable.Context context) {
        Map<String, String> propertiesNames = context.getOrCreateSanitizedPropertiesNames();
        String sanitizedName = propertiesNames.get(this.getName());
        if (this.getName() != null && this.getName().equals(this.getLabel())) {
            ObjectsUtil.setIfNotNull(() -> sanitizedName, this::setLabel);
        }
        ObjectsUtil.setIfNotNull(() -> sanitizedName, this::setName);
        Map<String, String> namespaces = context.getSanitizedPrefixNamespaces();
        Map<String, String> objectIds = context.getSanitizedObjectIds();
        ObjectsUtil.setIfNotNull(() -> SchemaSanitizerUtils.resolveIfPrefixed(this.getRange(), namespaces, objectIds), this::setRange);
        if (!this.isSparqlTemplate()) {
            ObjectsUtil.setIfNotNull(() -> SchemaSanitizerUtils.resolveIfPrefixed(this.getRdfProp(), namespaces, Collections.emptyMap()), this::setRdfProp);
        }
        this.sanitizeInverseCharacteristics(context, propertiesNames);
    }

    private void sanitizeInverseCharacteristics(Sanitizable.Context context, Map<String, String> propertiesNames) {
        Map<String, String> namespaces = context.getSanitizedPrefixNamespaces();
        String inverseOfValue = SchemaSanitizerUtils.resolveIfPrefixed(this.getInverseOf(), namespaces, propertiesNames);
        String inverseAliasValue = SchemaSanitizerUtils.resolveIfPrefixed(this.getInverseAlias(), namespaces, propertiesNames);
        Optional<String> vocabPrefix = context.getPrefixes().getVocabPrefix();
        if (vocabPrefix.isPresent()) {
            String vocab = vocabPrefix.get();
            this.setInverseOf(Properties.simplifyName(vocab, inverseOfValue));
            this.setInverseAlias(Properties.simplifyName(vocab, inverseAliasValue));
        } else {
            this.setInverseOf(inverseOfValue);
            this.setInverseAlias(inverseAliasValue);
        }
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
        this.tracker.trackValue(MAX_LENGTH_FIELD, maxLength);
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
        this.tracker.trackValue(MIN_LENGTH_FIELD, minLength);
    }

    public Object getMinInclusive() {
        return this.minInclusive;
    }

    public void setMinInclusive(Object minInclusive) {
        this.minInclusive = minInclusive;
        this.tracker.trackValue(MIN_INCLUSIVE_FIELD, minInclusive);
    }

    public Object getMaxInclusive() {
        return this.maxInclusive;
    }

    public void setMaxInclusive(Object maxInclusive) {
        this.maxInclusive = maxInclusive;
        this.tracker.trackValue(MAX_INCLUSIVE_FIELD, maxInclusive);
    }

    public Object getMinExclusive() {
        return this.minExclusive;
    }

    public void setMinExclusive(Object minExclusive) {
        this.minExclusive = minExclusive;
        this.tracker.trackValue(MIN_EXCLUSIVE_FIELD, minExclusive);
    }

    public Object getMaxExclusive() {
        return this.maxExclusive;
    }

    public void setMaxExclusive(Object maxExclusive) {
        this.maxExclusive = maxExclusive;
        this.tracker.trackValue(MAX_EXCLUSIVE_FIELD, maxExclusive);
    }

    public List<Object> getValuesIn() {
        return this.valuesIn;
    }

    public void setValuesIn(List<Object> valuesIn) {
        this.valuesIn = valuesIn;
        this.tracker.trackValue(VALUES_IN_FIELD, valuesIn);
    }

    public Boolean isValuesListExclusive() {
        return this.valuesListExclusive;
    }

    public void setValuesListExclusive(Boolean valuesListExclusive) {
        this.valuesListExclusive = valuesListExclusive;
        this.tracker.trackValue(VALUES_LIST_EXCLUSIVE, valuesListExclusive);
    }

    public String getEquals() {
        return this.equals;
    }

    public void setEquals(String equals) {
        this.equals = equals;
        this.tracker.trackValue(EQUALS_FIELD, equals);
    }

    public Boolean getValidationIgnored() {
        return null != this.validationIgnored && this.validationIgnored != false;
    }

    public void setValidationIgnored(Boolean validationIgnored) {
        this.validationIgnored = validationIgnored;
        this.tracker.trackValue(VALIDATION_IGNORED_FIELD, validationIgnored);
    }

    @Deprecated
    public String getRegex() {
        if (null != this.pattern) {
            return this.getPatternString();
        }
        return this.regex;
    }

    @Deprecated
    public void setRegex(String regex) {
        this.regex = regex;
        this.tracker.trackValue(REGEX_FIELD, regex);
        this.tracker.trackValue(PATTERN_FIELD, regex);
    }

    public void setNonNullable(Boolean nonNullable) {
        this.nonNullable = nonNullable;
        this.tracker.trackValue(NON_NULLABLE, nonNullable);
    }

    public Boolean isNonNullable() {
        return this.nonNullable;
    }

    public Boolean isReadOnly() {
        return (Boolean)ObjectsUtil.getOrDefault((Object)this.readOnly, (Object)Boolean.FALSE);
    }

    public boolean isMutable() {
        return this.isReadOnly() == false && this.isTripleSelection();
    }

    public boolean isRangeMutable() {
        return !this.isRangeImmutable();
    }

    private boolean isRangeImmutable() {
        return this.isObjectType() && !((Shape)this.getContainedIn().getContainedIn().getContainedIn().get(this.getRange())).isMutable();
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        this.tracker.trackValue(READ_ONLY_FIELD, readOnly);
    }

    public boolean isAllowedForFiltering() {
        return (Boolean)ObjectsUtil.getOrDefault((Object)this.filtered, (Object)Boolean.TRUE);
    }

    public Boolean getFiltered() {
        return this.filtered;
    }

    public void setFiltered(Boolean filtered) {
        this.filtered = filtered;
        this.tracker.trackValue(FILTERED_FIELD, filtered);
    }

    public boolean isAllowedForOrdering() {
        return (Boolean)ObjectsUtil.getOrDefault((Object)this.ordered, (Object)Boolean.TRUE);
    }

    public Boolean getOrdered() {
        return this.ordered;
    }

    public void setOrdered(Boolean ordered) {
        this.ordered = ordered;
        this.tracker.trackValue(ORDERED_FIELD, ordered);
    }

    public boolean isSearchable() {
        return this.search != null && this.search.isSearchable();
    }

    public void setSearch(SearchConfig search) {
        this.search = search;
        this.tracker.trackValue(SEARCH_FIELD, search);
    }

    public SearchConfig getSearch() {
        return this.search;
    }

    public SearchConfig getSearchSafe() {
        return this.search != null ? this.search : SearchConfig.DEFAULT;
    }

    public void setScaleFactor(Double scaleFactor) {
        this.scaleFactor = scaleFactor;
        this.tracker.trackValue(SCALE_FACTOR_FIELD, scaleFactor);
    }

    public Double getScaleFactor() {
        return this.scaleFactor;
    }

    public Boolean isNonNullableElements() {
        return this.nonNullableElements;
    }

    public void setNonNullableElements(Boolean nonNullableElements) {
        this.nonNullableElements = nonNullableElements;
        this.tracker.trackValue(NON_NULLABLE_ELEMENTS, nonNullableElements);
    }

    public void setDefaults() {
        PropertyShape.merge(this::setRange, this.getRange(), "object".equalsIgnoreCase(this.getKind()) ? "iri" : "string");
        PropertyShape.merge(this::setTypeCast, this.getTypeCast(), Boolean.FALSE);
        PropertyShape.merge(this::setLabel, this.getLabel(), SchemaSanitizerUtils.keyToDisplayLabel(this.getName()));
        PropertyShape.merge(this::setMax, this.getMax(), "1");
        PropertyShape.merge(this::setMin, this.getMin(), 0);
        PropertyShape.merge(this::setSymmetric, this.getSymmetric(), Boolean.FALSE);
        PropertyShape.merge(this::setExternal, this.getExternal(), Boolean.FALSE);
        PropertyShape.merge(this::setNonNullable, this.isNonNullable(), Boolean.FALSE);
        PropertyShape.merge(this::setNonNullableElements, this.isNonNullableElements(), Boolean.FALSE);
        PropertyShape.merge(this::setReadOnly, this.getReadOnly(), Boolean.FALSE);
        PropertyShape.merge(this::setFiltered, this.getFiltered(), Boolean.TRUE);
        PropertyShape.merge(this::setOrdered, this.getOrdered(), Boolean.TRUE);
        PropertyShape.merge(this::setRestrictive, this.isRestrictive(), Boolean.FALSE);
        PropertyShape.merge(this::setValuesListExclusive, this.isValuesListExclusive(), Boolean.TRUE);
        if (this.getKind() == null) {
            if (this.isScalarType() || ScalarTypes.TEXT_TYPES.contains(this.getRange()) || ScalarTypes.NUMBER_TYPES.contains(this.getRange()) || ScalarTypes.TEMPORAL_TYPES.contains(this.getRange()) || ScalarTypes.DURATION_TYPES.contains(this.getRange()) || "boolean".equals(this.getRange())) {
                this.setKind("literal");
            } else if (Character.isUpperCase(this.getRange().charAt(0)) || "iri".equals(this.getRange()) || this.getRange().contains(":") && Character.isUpperCase(this.getRange().charAt(this.getRange().indexOf(":") + 1))) {
                this.setKind("object");
            }
        }
        if (this.getInverseAlias() != null) {
            PropertyShape.merge(this::setRangeCheck, this.getRangeCheck(), Boolean.TRUE);
        } else if (this.getKind() == null) {
            PropertyShape.merge(this::setRangeCheck, this.getRangeCheck(), Boolean.FALSE);
        }
        if (this.getRdfProp() == null) {
            ObjectsUtil.setIfNotNull(this::getName, this::setRdfProp);
        }
        if (this.isScalarType() && "decimal".equals(this.getScalarType().getName()) && this.getScaleFactor() == null) {
            this.setScaleFactor(PropertiesDefaultValues.SCALE_FACTOR);
        }
    }

    private static <T> void merge(Consumer<T> valueConsumer, T value, T defaultValue) {
        valueConsumer.accept(ObjectsUtil.getOrDefault(value, defaultValue));
    }

    public Template getSparqlTemplate() {
        return this.template;
    }

    public void setSparqlTemplate(Template template) {
        this.template = template;
    }

    public Boolean isRestrictive() {
        return this.restrictive;
    }

    public void setRestrictive(Boolean restrictive) {
        this.restrictive = restrictive;
        this.tracker.trackValue(RESTRICTIVE_FIELD, restrictive);
    }

    public boolean isCountProperty() {
        return this.isGenerated() && this.getName().endsWith("_count") && !this.getName().equals("affected_count");
    }

    public Optional<PropertyShape> resolveCountedProperty() {
        if (this.isCountProperty()) {
            return this.getContainedIn().getContainedIn().getProperty(this.getName().substring(0, this.getName().length() - "_count".length()));
        }
        return Optional.empty();
    }
}

