/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.Operation;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.soaas.plugin.PluginsManager;
import java.util.List;

public class OperationValidators {
    private List<OperationValidator> validators;

    public OperationResponse validate(Operation operation, ValidationContext validationContext) {
        return this.getValidators().stream().map(operationValidator -> operationValidator.validate(operation, validationContext)).reduce(new OperationResponse(), OperationResponse::addAll);
    }

    private List<OperationValidator> getValidators() {
        if (this.validators == null) {
            this.validators = PluginsManager.loadPlugins(OperationValidator.class, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        return this.validators;
    }
}

