/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.OperationType;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.Arguments;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public interface Operation
extends Selectable {
    @Nullable
    public String getRequestOperationName();

    @Override
    public String getName();

    @Override
    default public Optional<PropertyShape> getProperty() {
        return Optional.empty();
    }

    public OperationType getOperationType();

    @Override
    public Arguments getArguments();

    public void setArguments(Arguments var1);

    public boolean isValid();

    public void invalidate();

    default public SomlSchema getSchema() {
        return this.getDefinedInType().getContainedIn().getContainedIn();
    }

    @Override
    default public boolean isCountSelection() {
        return this.getName().endsWith("_count");
    }

    default public Optional<Shape> getCountedType() {
        if (this.isCountSelection()) {
            String typeName = this.getName().substring(0, this.getName().length() - "_count".length());
            return this.getSchema().getObjects().resolveShape(StringUtils.capitalize((String)typeName));
        }
        return Optional.empty();
    }
}

