/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public interface ModelTracker {
    public void trackValue(String var1, Object var2);

    public void trackModelEntry(String var1);

    public boolean isTracked(String var1);

    public Set<String> getTrackedEntities();

    default public void clear() {
    }

    default public boolean updateKey(String oldKey, String newKey) {
        return false;
    }

    public static ModelTracker tracked() {
        return new ActiveModelTracker();
    }

    public static ModelTracker notTracked() {
        return NoOpModelTracker.INSTANCE;
    }

    public static ModelTracker enableTracking(ModelTracker tracker) {
        if (tracker instanceof ReadOnlyModelTracker) {
            ReadOnlyModelTracker readOnly = (ReadOnlyModelTracker)tracker;
            return readOnly.delegate;
        }
        return tracker;
    }

    public static ModelTracker disableTracking(ModelTracker tracker) {
        if (tracker instanceof ReadOnlyModelTracker) {
            return tracker;
        }
        return new ReadOnlyModelTracker(tracker);
    }

    public static class ActiveModelTracker
    implements ModelTracker {
        private final Set<String> nodes = new LinkedHashSet<String>();

        @Override
        public void trackValue(String name, Object value) {
            if (value != null) {
                this.nodes.add(name);
            }
        }

        @Override
        public void trackModelEntry(String name) {
            this.nodes.add(name);
        }

        @Override
        public boolean isTracked(String name) {
            return this.nodes.contains(name);
        }

        @Override
        public Set<String> getTrackedEntities() {
            return this.nodes;
        }

        @Override
        public void clear() {
            this.nodes.clear();
        }

        @Override
        public boolean updateKey(String oldKey, String newKey) {
            if (StringUtils.isNotBlank((CharSequence)oldKey) && StringUtils.isNotBlank((CharSequence)newKey) && this.nodes.remove(oldKey)) {
                return this.nodes.add(newKey);
            }
            return false;
        }
    }

    public static class NoOpModelTracker
    implements ModelTracker {
        public static final ModelTracker INSTANCE = new NoOpModelTracker();

        @Override
        public void trackValue(String name, Object value) {
        }

        @Override
        public void trackModelEntry(String name) {
        }

        @Override
        public boolean isTracked(String name) {
            return false;
        }

        @Override
        public Set<String> getTrackedEntities() {
            return Collections.emptySet();
        }
    }

    public static class ReadOnlyModelTracker
    implements ModelTracker {
        private final ModelTracker delegate;

        ReadOnlyModelTracker(ModelTracker delegate) {
            this.delegate = delegate;
        }

        @Override
        public void trackValue(String name, Object value) {
        }

        @Override
        public void trackModelEntry(String name) {
        }

        @Override
        public boolean isTracked(String name) {
            return this.delegate.isTracked(name);
        }

        @Override
        public Set<String> getTrackedEntities() {
            return this.delegate.getTrackedEntities();
        }

        @Override
        public boolean updateKey(String oldKey, String newKey) {
            return this.delegate.updateKey(oldKey, newKey);
        }
    }
}

