/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.Configs;
import com.ontotext.models.ModelTracker;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.query.LangFilter;
import com.ontotext.models.query.LangValidator;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import com.ontotext.soaas.common.ObjectsUtil;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

public class LangConfig
implements TrackedModel,
YamlRepresentable {
    public static final String FETCH_FIELD = "fetch";
    public static final String VALIDATE_FIELD = "validate";
    public static final String IMPLICIT_FIELD = "implicit";
    public static final String UNIQ_LANG = "UNIQ";
    private String fetch;
    private String validate;
    private String implicit;
    private String effectiveImplicit;
    protected boolean singleValueMode = false;
    private LangValidator validator;
    protected ModelTracker tracker = ModelTracker.notTracked();

    public LangConfig() {
        this.tracker = ModelTracker.tracked();
    }

    protected LangConfig(LangConfig copyFrom) {
        if (!copyFrom.isEmptyValue()) {
            this.tracker = ModelTracker.tracked();
        }
        this.singleValueMode = copyFrom.singleValueMode;
        this.fetch = copyFrom.fetch;
        this.validate = copyFrom.validate;
        this.implicit = copyFrom.implicit;
        this.effectiveImplicit = copyFrom.effectiveImplicit;
        this.copyTrackInformation(copyFrom);
        this.stopTracking();
    }

    public static LangConfig parse(Object value) {
        if (value instanceof String) {
            return new LangConfig(value.toString());
        }
        if (value instanceof Map) {
            return new LangConfig((Map)value);
        }
        if (value instanceof LangConfig) {
            LangConfig langConfig = (LangConfig)value;
            return new LangConfig(langConfig);
        }
        return new LangConfig();
    }

    protected LangConfig(String fetch) {
        this.singleValueMode = true;
        this.tracker = ModelTracker.tracked();
        this.setFetch(Objects.toString(fetch, null));
    }

    protected LangConfig(Map<String, Object> map) {
        if (map.isEmpty()) {
            this.setFetch(Objects.toString(this.getDefaultFetchValue(), ""));
            this.setValidate(Objects.toString(this.getDefaultValidateValue(), ""));
            this.setImplicit(Objects.toString(this.getDefaultImplicitValue(), ""));
            return;
        }
        this.tracker = ModelTracker.tracked();
        this.setFetch(Objects.toString(map.get(FETCH_FIELD), null));
        this.setValidate(Objects.toString(map.get(VALIDATE_FIELD), null));
        this.setImplicit(Objects.toString(map.get(IMPLICIT_FIELD), null));
    }

    private Object getDefaultFetchValue() {
        return Configs.getConfigInfo().get("lang.fetch").defaultValue();
    }

    private Object getDefaultValidateValue() {
        return Configs.getConfigInfo().get("lang.validate").defaultValue();
    }

    private Object getDefaultImplicitValue() {
        return Configs.getConfigInfo().get("lang.implicit").defaultValue();
    }

    public LangConfig(boolean notTracked) {
    }

    public String getFetch() {
        return this.fetch;
    }

    public void setFetch(String fetch) {
        this.fetch = fetch;
        this.tracker.trackValue(FETCH_FIELD, fetch);
    }

    public String getValidate() {
        return this.validate;
    }

    public void setValidate(String validate) {
        this.validate = validate;
        this.validator = null;
        this.tracker.trackValue(VALIDATE_FIELD, validate);
    }

    public LangValidator getValidator() {
        if (this.validator == null) {
            this.validator = LangFilter.parseForValidation(this.validate);
        }
        return this.validator;
    }

    public boolean hasValidation() {
        return !this.getValidator().getTokens().isEmpty();
    }

    public String getImplicit() {
        return this.implicit;
    }

    public String getEffectiveImplicit() {
        return this.effectiveImplicit;
    }

    public void setImplicit(String implicit) {
        this.implicit = implicit;
        this.effectiveImplicit = "NONE".equals(implicit) ? "" : StringUtils.trimToNull((String)implicit);
        this.tracker.trackValue(IMPLICIT_FIELD, implicit);
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId);
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        if (this.singleValueMode && this.fetch != null) {
            if (this.fetch.isEmpty()) {
                return "\"\"";
            }
            return this.fetch;
        }
        StringBuilder builder = new StringBuilder(32);
        builder.append('{');
        this.propertiesToYaml(builder);
        builder.append('}');
        String yaml = builder.toString();
        if (yaml.equals("{}") && !this.isEmptyValue()) {
            if (this.isDefault()) {
                return yaml;
            }
            return "";
        }
        return yaml;
    }

    protected boolean propertiesToYaml(StringBuilder builder) {
        boolean hasPreviousValue = this.appendProperty(builder, false, FETCH_FIELD, this.fetch);
        hasPreviousValue = this.appendProperty(builder, hasPreviousValue, VALIDATE_FIELD, this.validate);
        return this.appendProperty(builder, hasPreviousValue, IMPLICIT_FIELD, this.implicit);
    }

    protected boolean appendProperty(StringBuilder builder, boolean hasPreviousValue, String property, String value) {
        if (this.tracker.isTracked(property) && value != null) {
            if (hasPreviousValue) {
                builder.append(", ");
            }
            builder.append(property).append(": \"").append(value).append('\"');
            hasPreviousValue = true;
        }
        return hasPreviousValue;
    }

    public String toString() {
        return "{fetch: '" + this.fetch + "', validate: '" + this.validate + "', implicit: '" + this.implicit + "'}";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LangConfig)) {
            return false;
        }
        LangConfig that = (LangConfig)obj;
        return Objects.equals(this.fetch, that.fetch) && Objects.equals(this.validate, that.validate) && Objects.equals(this.implicit, that.implicit);
    }

    public int hashCode() {
        return Objects.hash(this.fetch, this.validate, this.implicit);
    }

    protected boolean isEmptyValue() {
        return "".equals(this.fetch) && "".equals(this.validate) && "".equals(this.implicit);
    }

    protected static boolean isDefaultValue(Object defaultValue, String value) {
        if (defaultValue == null && value == null) {
            return true;
        }
        if (value != null && value.isEmpty()) {
            return true;
        }
        if (defaultValue != null) {
            return defaultValue.equals(value);
        }
        return false;
    }

    protected boolean isDefault() {
        return LangConfig.isDefaultValue(this.getDefaultFetchValue(), this.getFetch()) && LangConfig.isDefaultValue(this.getDefaultValidateValue(), this.getValidate()) && LangConfig.isDefaultValue(this.getDefaultImplicitValue(), this.getImplicit());
    }

    public void merge(LangConfig parentConfig) {
        if (parentConfig == null) {
            return;
        }
        LangConfig.merge(value -> {
            this.fetch = value;
        }, this.getFetch(), parentConfig.getFetch());
        LangConfig.merge(value -> {
            this.validate = value;
        }, this.getValidate(), parentConfig.getValidate());
        LangConfig.merge(value -> {
            this.implicit = value;
        }, this.getImplicit(), parentConfig.getImplicit());
        LangConfig.merge(value -> {
            this.effectiveImplicit = value;
        }, this.getEffectiveImplicit(), parentConfig.getEffectiveImplicit());
    }

    static <T> void merge(Consumer<T> valueConsumer, T value, T defaultValue) {
        valueConsumer.accept(ObjectsUtil.getOrDefault(value, defaultValue));
    }

    protected void copyTrackInformation(LangConfig parentConfig) {
        if (parentConfig.isTracked(FETCH_FIELD)) {
            this.tracker.trackModelEntry(FETCH_FIELD);
        }
        if (parentConfig.isTracked(VALIDATE_FIELD)) {
            this.tracker.trackModelEntry(VALIDATE_FIELD);
        }
        if (parentConfig.isTracked(IMPLICIT_FIELD)) {
            this.tracker.trackModelEntry(IMPLICIT_FIELD);
        }
    }
}

