/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.ModelTracker;
import com.ontotext.models.ScalarType;
import com.ontotext.models.TrackedModel;
import com.ontotext.models.yaml.YamlPrinter;
import com.ontotext.models.yaml.YamlRepresentable;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EnumValueDef
implements TrackedModel,
YamlRepresentable {
    public static final String NAME_FIELD = "name";
    public static final String VALUE_FIELD = "value";
    public static final String LABEL_FIELD = "label";
    private String name;
    private Object value;
    private Object originalValue;
    private String label;
    private boolean singleField;
    private ModelTracker tracker = ModelTracker.tracked();

    public EnumValueDef() {
    }

    public EnumValueDef(Object value) {
        this();
        this.setValue(value);
        this.singleField = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.tracker.trackValue(NAME_FIELD, name);
        this.name = name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.tracker.trackValue(VALUE_FIELD, value);
        this.originalValue = value;
        this.value = value;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.tracker.trackValue(LABEL_FIELD, label);
        this.label = label;
    }

    public String toString() {
        return String.format("EnumValueDef{name='%s', value='%s', label='%s'}", this.name, this.value, this.label);
    }

    @Override
    public void clearTrackedInformation() {
        this.tracker.clear();
    }

    @Override
    public void startTracking() {
        this.tracker = ModelTracker.enableTracking(this.tracker);
    }

    @Override
    public void stopTracking() {
        this.tracker = ModelTracker.disableTracking(this.tracker);
    }

    @Override
    public boolean isTracked(String modelId) {
        return this.tracker.isTracked(modelId);
    }

    @Override
    public String toYaml(YamlPrinter.Configuration configuration) {
        if (this.singleField) {
            return YamlPrinter.getValueAsString(this.originalValue, configuration);
        }
        return new YamlPrinter(configuration).beginMap().addMapEntry(NAME_FIELD, this.name, this.tracker::isTracked, true).addMapEntry(VALUE_FIELD, this.originalValue, this.tracker::isTracked, true).addMapEntry(LABEL_FIELD, this.label, this.tracker::isTracked, false).endMap().asString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EnumValueDef)) {
            return false;
        }
        EnumValueDef that = (EnumValueDef)obj;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.label, that.label);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.label);
    }

    void expand(ScalarType scalarType, int idx) {
        if (this.name == null && this.label != null) {
            this.name = this.label.toUpperCase().replaceAll("[\\W_]+", "_");
            this.name = StringUtils.prependIfMissing((String)this.name, (CharSequence)"_", (CharSequence[])new CharSequence[0]);
        }
        if (this.value == null) {
            this.resolveValue(scalarType, idx);
        } else if ("rdfs:Resource".equals(scalarType.getRdf())) {
            try {
                this.value = scalarType.getContainedIn().getContainedIn().getPrefixes().toIri(this.value.toString());
            }
            catch (InvalidSchemaException invalidSchemaException) {
                // empty catch block
            }
        }
        if (this.name == null && this.value != null) {
            this.name = Objects.toString(StringUtils.trimToNull((String)this.value.toString()), "_").toUpperCase().replaceAll("[\\W_]+", "_");
            if (Character.isDigit(this.name.charAt(0))) {
                this.name = StringUtils.prependIfMissing((String)this.name, (CharSequence)"_", (CharSequence[])new CharSequence[0]);
            }
        }
        if (this.label == null && this.name != null) {
            this.label = this.name.replaceAll("_+", " ").trim();
            this.label = Arrays.stream(this.label.toLowerCase().split(" ")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
        }
    }

    private void resolveValue(ScalarType scalarType, int idx) {
        if ("xsd:int".equals(scalarType.getRdf())) {
            this.value = idx;
        } else if (this.name != null) {
            if ("rdfs:Resource".equals(scalarType.getRdf())) {
                try {
                    this.value = scalarType.getContainedIn().getContainedIn().getPrefixes().toIri(this.name);
                }
                catch (InvalidSchemaException invalidSchemaException) {}
            } else {
                this.value = this.name;
            }
        }
    }
}

