/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ActionFilter;
import com.ontotext.models.Constraint;
import com.ontotext.models.Shape;
import com.ontotext.models.SimpleActionFilter;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.query.And;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionCollection;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.Value;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Literal;

public class Constraints {
    private static final SimpleActionFilter EMTPY = new SimpleActionFilter(null, Collections.emptyList());

    private Constraints() {
    }

    public static Set<Constraint> fromShapeIds(Set<String> shapeIds) {
        return shapeIds.stream().map(Constraint::new).sorted(Constraints.byShapeId()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<Constraint> fromShapeIds(String ... shapeIds) {
        return Stream.of(shapeIds).map(Constraint::new).sorted(Constraints.byShapeId()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static boolean constrainOnlyByFilters(Collection<Constraint> constraints, Shape shape) {
        Set<String> shapeTypes = Constraints.getConcreteSubclasses(shape);
        SomlSchema schema = shape.getContainedIn().getContainedIn();
        Set accessibleTypes = constraints.stream().map(Constraint::getShapeId).flatMap(shapeId -> Constraints.getConcreteSubclasses((Shape)schema.getObjects().get(shapeId)).stream()).collect(Collectors.toSet());
        return shapeTypes.equals(accessibleTypes);
    }

    private static Set<String> getConcreteSubclasses(Shape shape) {
        HashSet<String> shapeTypes = new HashSet<String>();
        if (!shape.isAbstract() && !shape.isUnion()) {
            shapeTypes.add(shape.getId());
        } else {
            shape.getConcreteSubTypes().stream().map(Shape::getId).forEach(shapeTypes::add);
        }
        return shapeTypes;
    }

    public static String printUserFriendlyFilter(Object filter) {
        if (filter instanceof And || filter instanceof ExpressionCollection) {
            return Constraints.combineMultiple(((Expression)filter).getTerms());
        }
        if (filter instanceof Expression) {
            return "{" + ((Expression)filter).getName() + ": " + Constraints.combineMultiple(((Expression)filter).getTerms()) + "}";
        }
        if (filter instanceof ExpressionTerm) {
            return "{" + ((ExpressionTerm)filter).getName() + ": " + Constraints.printUserFriendlyFilter(((ExpressionTerm)filter).getValue()) + "}";
        }
        if (filter instanceof Value) {
            return Constraints.printUserFriendlyFilter(((Value)filter).getValue());
        }
        if (filter instanceof Literal) {
            return "\"" + ((Literal)filter).getLabel() + "\"";
        }
        if (filter instanceof Collection) {
            return Constraints.combineMultiple((Collection)filter);
        }
        return filter.toString();
    }

    public static Object asUserMessage(Set<Constraint> constraints, Shape rootShape) {
        boolean isSingleFilterApplied = constraints.stream().map(Constraint::getFilter).map(actionFilter -> actionFilter == null ? EMTPY : actionFilter).map(ActionFilter::getFilter).distinct().count() == 1L;
        Object constraintsAsString = isSingleFilterApplied ? constraints.iterator().next().toMessage(true) : constraints.stream().map(constraint -> constraint.toMessage(constraint.getShapeId().equals(rootShape.getId()))).collect(Collectors.toSet());
        return constraintsAsString;
    }

    private static String combineMultiple(Collection<?> terms) {
        return terms.stream().map(Constraints::printUserFriendlyFilter).collect(Collectors.toList()).toString();
    }

    private static Comparator<Constraint> byShapeId() {
        return Comparator.comparing(obj -> obj.shapeId);
    }
}

