/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.models;

import com.ontotext.models.ActionFilter;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.ExpressionsFactory;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CompositeActionFilter
implements ActionFilter {
    private Set<ActionFilter> positives;
    private Set<ActionFilter> negatives;
    private ExpressionValue<Object> filter;
    private Selectable selection;

    public CompositeActionFilter(Set<ActionFilter> positives, Set<ActionFilter> negatives) {
        this.positives = positives;
        this.negatives = negatives;
    }

    @Override
    public ExpressionValue<Object> getFilter() {
        if (this.shouldInit()) {
            this.init();
        }
        return this.filter;
    }

    @Override
    public List<Selectable> getSelections() {
        if (this.shouldInit()) {
            this.init();
        }
        return Collections.singletonList(this.selection);
    }

    @Override
    public <R, C extends ExpressionVisitorContext> CompositeActionFilter acceptFilterVisitor(ExpressionVisitor<R, C> visitor, C context) {
        LinkedHashSet posCpy = this.positives.stream().map(filter -> filter.acceptFilterVisitor(visitor, context)).collect(Collectors.toCollection(LinkedHashSet::new));
        LinkedHashSet negCpy = this.negatives.stream().map(filter -> filter.acceptFilterVisitor(visitor, context)).collect(Collectors.toCollection(LinkedHashSet::new));
        if (Objects.equals(this.positives, posCpy) && Objects.equals(this.negatives, negCpy)) {
            return this;
        }
        return new CompositeActionFilter(posCpy, negCpy);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeActionFilter that = (CompositeActionFilter)obj;
        return Objects.equals(this.positives, that.positives) && Objects.equals(this.negatives, that.negatives);
    }

    public int hashCode() {
        return Objects.hash(this.positives, this.negatives);
    }

    public String toString() {
        return "CompositeActionFilter{positives=" + String.valueOf(this.positives) + ", negatives=" + String.valueOf(this.negatives) + "}";
    }

    public boolean hasNegatives() {
        return !this.negatives.isEmpty();
    }

    public CompositeActionFilter merge(CompositeActionFilter other) {
        return new CompositeActionFilter(Stream.concat(this.positives.stream(), other.positives.stream()).collect(Collectors.toSet()), Stream.concat(this.negatives.stream(), other.negatives.stream()).collect(Collectors.toSet()));
    }

    private boolean shouldInit() {
        return this.filter == null || this.selection == null;
    }

    private void init() {
        if (this.positives.isEmpty() && this.negatives.isEmpty()) {
            throw new IllegalArgumentException("Composite filter does not have any action filters");
        }
        Selection rootSelection = new Selection();
        rootSelection.setName("rbac-filter");
        rootSelection.setType("Object");
        rootSelection.setSelections(new LinkedList<Selection>());
        Expression positiveExpression = this.buildPositiveExpression(this.positives, rootSelection);
        Expression negativeExpression = this.buildNegativeExpression(this.negatives, rootSelection);
        Expression returnExpression = positiveExpression == null ? negativeExpression : (negativeExpression == null ? positiveExpression : ExpressionsFactory.and().addTerm(positiveExpression).addTerm(negativeExpression));
        this.filter = returnExpression;
        this.selection = rootSelection;
    }

    private Expression buildPositiveExpression(Set<ActionFilter> positives, Selection rootSelection) {
        Expression positiveExpression = null;
        if (!positives.isEmpty()) {
            for (ActionFilter positive : positives) {
                this.addSelectionToRootSelection(rootSelection, positive.getSelections());
            }
            if (positives.size() == 1) {
                ActionFilter af = positives.iterator().next();
                positiveExpression = ExpressionsFactory.and().addTerm((ExpressionTerm)af.getFilter());
            } else {
                positiveExpression = ExpressionsFactory.or();
                for (ActionFilter positive : positives) {
                    positiveExpression.addTerm((ExpressionTerm)positive.getFilter());
                }
            }
        }
        return positiveExpression;
    }

    private Expression buildNegativeExpression(Set<ActionFilter> negatives, Selection rootSelection) {
        Expression negativeExpression = null;
        if (!negatives.isEmpty()) {
            for (ActionFilter negative : negatives) {
                this.addSelectionToRootSelection(rootSelection, negative.getSelections());
            }
            if (negatives.size() == 1) {
                ActionFilter af = negatives.iterator().next();
                negativeExpression = ExpressionsFactory.not().addTerm(ExpressionsFactory.exists().addTerm((ExpressionTerm)af.getFilter()));
            } else {
                Expression tmp = ExpressionsFactory.or();
                for (ActionFilter negative : negatives) {
                    tmp.addTerm((ExpressionTerm)negative.getFilter());
                }
                negativeExpression = ExpressionsFactory.not().addTerm(ExpressionsFactory.exists().addTerm(tmp));
            }
        }
        return negativeExpression;
    }

    private void addSelectionToRootSelection(Selection rootSelection, List<? extends Selectable> selections) {
        for (Selectable selectable : selections) {
            Optional<Selectable> sameSelInParent = rootSelection.getWhereSelections().stream().filter(Selectable.byNameAndParentType(selectable.getName(), selectable.getDefinedIn())).findFirst();
            if (sameSelInParent.isPresent()) {
                this.addSelectionToRootSelection((Selection)sameSelInParent.get(), selectable.getWhereSelections());
                continue;
            }
            rootSelection.getWhereSelections().add((Selection)selectable);
        }
    }
}

